/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.Environment;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class FMLServiceProvider
implements ITransformationService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<String, Object> arguments;

    public FMLServiceProvider() {
        String[] markers;
        for (String marker : markers = System.getProperty("forge.logging.markers", "").split(",")) {
            System.setProperty("forge.logging.marker." + marker.toLowerCase(Locale.ROOT), "ACCEPT");
        }
    }

    public String name() {
        return "fml";
    }

    public void initialize(IEnvironment environment) {
        LOGGER.debug(LogMarkers.CORE, "Setting up basic FML game directories");
        FMLPaths.setup(environment);
        LOGGER.debug(LogMarkers.CORE, "Loading configuration");
        FMLConfig.load();
        LOGGER.debug(LogMarkers.CORE, "Preparing ModFile");
        environment.computePropertyIfAbsent((TypesafeMap.Key)Environment.Keys.MODFILEFACTORY.get(), k -> ModFile::new);
        this.arguments = new HashMap<String, Object>();
        LOGGER.debug(LogMarkers.CORE, "Preparing launch handler");
        FMLLoader.setupLaunchHandler(environment, this.arguments);
        FMLEnvironment.setupInteropEnvironment(environment);
        Environment.build((IEnvironment)environment);
    }

    public List<ITransformationService.Resource> beginScanning(IEnvironment environment) {
        LOGGER.debug(LogMarkers.CORE, "Initiating mod scan");
        return FMLLoader.beginModScan(this.arguments);
    }

    public List<ITransformationService.Resource> completeScan(IModuleLayerManager layerManager) {
        return FMLLoader.completeScan(layerManager);
    }

    public void onLoad(IEnvironment environment, Set<String> otherServices) throws IncompatibleEnvironmentException {
        FMLLoader.onInitialLoad(environment, otherServices);
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
    }

    public void argumentValues(ITransformationService.OptionResult option) {
    }

    @NotNull
    public List<ITransformer> transformers() {
        LOGGER.debug(LogMarkers.CORE, "Loading coremod transformers");
        return new ArrayList<ITransformer>(FMLLoader.getCoreModProvider().getCoreModTransformers());
    }
}

