/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer.parser;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.accesstransformer.AccessTransformer;
import net.minecraftforge.accesstransformer.ClassTarget;
import net.minecraftforge.accesstransformer.FieldTarget;
import net.minecraftforge.accesstransformer.INameHandler;
import net.minecraftforge.accesstransformer.IdentityNameHandler;
import net.minecraftforge.accesstransformer.InnerClassTarget;
import net.minecraftforge.accesstransformer.MethodTarget;
import net.minecraftforge.accesstransformer.Target;
import net.minecraftforge.accesstransformer.TargetType;
import net.minecraftforge.accesstransformer.WildcardTarget;
import net.minecraftforge.accesstransformer.parser.ModifierProcessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;

public class AccessTransformerList {
    private static final Logger LOGGER = LogManager.getLogger((String)"AXFORM");
    private static final Marker AXFORM_MARKER = MarkerManager.getMarker((String)"AXFORM");
    private final Map<Target<?>, AccessTransformer> accessTransformers = new HashMap();
    private final Set<Type> validAtTypes = new HashSet<Type>();
    private final Renamer renamer = new Renamer();
    private INameHandler nameHandler = new IdentityNameHandler();

    public void loadFromResource(String resourceName) throws URISyntaxException, IOException {
        Path path = Paths.get(this.getClass().getClassLoader().getResource(resourceName).toURI());
        this.loadFromPath(path, resourceName);
    }

    public void loadFromPath(Path path, String resourceName) throws IOException {
        LOGGER.debug(AXFORM_MARKER, "Loading access transformer {} from path {}", (Object)resourceName, (Object)path);
        this.load(path, resourceName, Files.readAllLines(path));
    }

    public void load(Path path, String resourceName, List<String> lines) {
        boolean failed = false;
        ArrayList<AccessTransformer> ats = new ArrayList<AccessTransformer>();
        int lineIndex = -1;
        for (String line : lines) {
            int idx;
            String name;
            ++lineIndex;
            List<String> tokens = AccessTransformerList.tokenize(line);
            if (tokens.isEmpty()) continue;
            if (tokens.size() < 2 || tokens.size() > 3) {
                LOGGER.error(AXFORM_MARKER, "Invalid access transformer line in {}: {}", (Object)resourceName, (Object)line);
                failed = true;
                continue;
            }
            AccessTransformer.Modifier mod = ModifierProcessor.modifier(tokens.get(0));
            if (mod == null) {
                LOGGER.error(AXFORM_MARKER, "Invalid access transformer line in {}: {}", (Object)resourceName, (Object)line);
                failed = true;
                continue;
            }
            AccessTransformer.FinalState fmod = ModifierProcessor.finalState(tokens.get(0));
            Target target = null;
            String cls = tokens.get(1).replace('.', '/');
            String string = name = tokens.size() == 2 ? null : tokens.get(2);
            if (tokens.size() == 2) {
                target = new ClassTarget(this.renamer.map(cls));
                idx = target.getClassName().lastIndexOf(36);
                if (idx != -1) {
                    String parent = target.getClassName().substring(0, idx);
                    ats.add(new AccessTransformer(new InnerClassTarget(parent, target.getClassName()), mod, fmod, resourceName, lineIndex));
                }
            } else if ("*".equals(name)) {
                target = new WildcardTarget(this.renamer.map(cls), false);
            } else if ("*()".equals(name)) {
                target = new WildcardTarget(this.renamer.map(cls), true);
            } else if (name.indexOf(40) == -1) {
                target = new FieldTarget(this.renamer.map(cls), this.renamer.mapFieldName(cls, name, null));
            } else {
                idx = name.indexOf(40);
                String desc = name.substring(idx).replace('.', '/');
                name = name.substring(0, idx);
                target = new MethodTarget(this.renamer.map(cls), this.renamer.mapMethodName(cls, name, desc), this.renamer.mapMethodDesc(desc));
            }
            ats.add(new AccessTransformer(target, mod, fmod, resourceName, lineIndex));
        }
        if (failed) {
            throw new IllegalArgumentException("Invalid AccessTransformer config, see log for details");
        }
        HashMap localATCopy = new HashMap(this.accessTransformers);
        this.mergeAccessTransformers(ats, localATCopy, resourceName);
        List<AccessTransformer> invalidTransformers = this.invalidTransformers(localATCopy);
        if (!invalidTransformers.isEmpty()) {
            invalidTransformers.forEach(at -> LOGGER.error(AXFORM_MARKER, "Invalid access transform final state for target {}. Referred in resources {}.", at.getTarget(), at.getOrigins()));
            throw new IllegalArgumentException("Invalid AT final conflicts");
        }
        this.accessTransformers.clear();
        this.accessTransformers.putAll(localATCopy);
        for (AccessTransformer newAT : ats) {
            this.validAtTypes.add(newAT.getTarget().getASMType());
        }
        LOGGER.debug(AXFORM_MARKER, "Loaded access transformer {} from path {}", (Object)resourceName, (Object)path);
    }

    private static List<String> tokenize(String line) {
        if (line.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        int start = 0;
        for (int x = 0; x < line.length(); ++x) {
            char c = line.charAt(x);
            if (c == ' ' || c == '\t') {
                if (start == x) {
                    ret.add("");
                } else {
                    ret.add(line.substring(start, x));
                }
                while (++x != line.length() && ((c = line.charAt(x)) == ' ' || c == '\t')) {
                }
                if (c == '#') break;
                start = x--;
                continue;
            }
            if (x == line.length() - 1) {
                ret.add(line.substring(start));
                continue;
            }
            if (c != '#') continue;
            if (start == x) break;
            ret.add(line.substring(start, x));
            break;
        }
        return ret;
    }

    private void mergeAccessTransformers(List<AccessTransformer> atList, Map<Target<?>, AccessTransformer> accessTransformers, String resourceName) {
        for (AccessTransformer at : atList) {
            accessTransformers.merge(at.getTarget(), at, (at1, at2) -> at1.mergeStates((AccessTransformer)at2, resourceName));
        }
    }

    private List<AccessTransformer> invalidTransformers(HashMap<Target<?>, AccessTransformer> accessTransformers) {
        ArrayList<AccessTransformer> ret = new ArrayList<AccessTransformer>();
        for (AccessTransformer at : accessTransformers.values()) {
            if (at.isValid()) continue;
            ret.add(at);
        }
        return ret;
    }

    public Map<String, List<AccessTransformer>> getAccessTransformers() {
        HashMap<String, List<AccessTransformer>> ret = new HashMap<String, List<AccessTransformer>>();
        this.accessTransformers.forEach((k, v) -> ret.computeIfAbsent(v.getTarget().getClassName(), t -> new ArrayList()).add(v));
        return ret;
    }

    public boolean containsClassTarget(Type type) {
        return this.validAtTypes.contains(type);
    }

    public Map<TargetType, Map<String, AccessTransformer>> getTransformersForTarget(Type type) {
        HashMap<TargetType, Map<String, AccessTransformer>> ret = new HashMap<TargetType, Map<String, AccessTransformer>>();
        this.accessTransformers.forEach((k, v) -> {
            if (!type.equals((Object)k.getASMType())) {
                return;
            }
            ret.computeIfAbsent(v.getTarget().getType(), t -> new HashMap()).put(v.getTarget().targetName(), v);
        });
        return ret;
    }

    public void setNameHandler(INameHandler nameHandler) {
        this.nameHandler = nameHandler;
        LOGGER.debug(AXFORM_MARKER, "Set name handler {}", (Object)nameHandler);
    }

    private final class Renamer
    extends Remapper {
        private Renamer() {
        }

        public String map(String internalName) {
            return AccessTransformerList.this.nameHandler.translateClassName(internalName);
        }

        public String mapFieldName(String owner, String name, String descriptor) {
            return AccessTransformerList.this.nameHandler.translateFieldName(name);
        }

        public String mapMethodName(String owner, String name, String descriptor) {
            return AccessTransformerList.this.nameHandler.translateMethodName(name);
        }
    }
}

