/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraftforge.eventbus.InternalUtils;
import net.minecraftforge.eventbus.ListenerList;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class EventListenerHelper {
    private static final BiFunction<Class<?>, Supplier<ListenerList>, ListenerList> listeners = InternalUtils.cachePublic();
    private static final ListenerList EVENTS_LIST = new ListenerList();
    private static final BiFunction<Class<?>, Supplier<Boolean>, Boolean> cancelable = InternalUtils.cachePublic();
    private static final BiFunction<Class<?>, Supplier<Boolean>, Boolean> hasResult = InternalUtils.cachePublic();

    public static ListenerList getListenerList(Class<?> eventClass) {
        return EventListenerHelper.getListenerListInternal(eventClass, false);
    }

    static ListenerList getListenerListInternal(Class<?> eventClass, boolean fromInstanceCall) {
        if (eventClass == Event.class) {
            return EVENTS_LIST;
        }
        return listeners.apply(eventClass, () -> EventListenerHelper.computeListenerList(eventClass, fromInstanceCall));
    }

    private static ListenerList computeListenerList(Class<?> eventClass, boolean fromInstanceCall) {
        if (eventClass == Event.class) {
            return EVENTS_LIST;
        }
        if (fromInstanceCall || Modifier.isAbstract(eventClass.getModifiers())) {
            Class<?> superclass = eventClass.getSuperclass();
            ListenerList parentList = EventListenerHelper.getListenerList(superclass);
            return new ListenerList(parentList);
        }
        try {
            Constructor<?> ctr = eventClass.getConstructor(new Class[0]);
            ctr.setAccessible(true);
            Event event = (Event)ctr.newInstance(new Object[0]);
            return event.getListenerList();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error computing listener list for " + eventClass.getName(), e);
        }
    }

    static boolean isCancelable(Class<?> eventClass) {
        return EventListenerHelper.hasAnnotation(eventClass, Cancelable.class, cancelable);
    }

    static boolean hasResult(Class<?> eventClass) {
        return EventListenerHelper.hasAnnotation(eventClass, Event.HasResult.class, hasResult);
    }

    private static boolean hasAnnotation(Class<?> eventClass, Class<? extends Annotation> annotation, BiFunction<Class<?>, Supplier<Boolean>, Boolean> cache) {
        if (eventClass == Event.class || eventClass == Object.class) {
            return false;
        }
        return cache.apply(eventClass, () -> {
            if (eventClass.isAnnotationPresent(annotation)) {
                return true;
            }
            Class parent = eventClass.getSuperclass();
            return parent != null && EventListenerHelper.hasAnnotation(parent, annotation, cache);
        });
    }
}

