/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory.tooltip;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ClientTooltipComponentManager;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public interface ClientTooltipComponent {
    public static ClientTooltipComponent create(FormattedCharSequence p_169949_) {
        return new ClientTextTooltip(p_169949_);
    }

    public static ClientTooltipComponent create(TooltipComponent p_169951_) {
        if (p_169951_ instanceof BundleTooltip) {
            BundleTooltip bundletooltip = (BundleTooltip)p_169951_;
            return new ClientBundleTooltip(bundletooltip.contents());
        }
        ClientTooltipComponent result = ClientTooltipComponentManager.createClientTooltipComponent((TooltipComponent)p_169951_);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Unknown TooltipComponent");
    }

    public int getHeight();

    public int getWidth(Font var1);

    default public void renderText(Font p_169953_, int p_169954_, int p_169955_, Matrix4f p_253692_, MultiBufferSource.BufferSource p_169957_) {
    }

    default public void renderImage(Font p_194048_, int p_194049_, int p_194050_, GuiGraphics p_283459_) {
    }
}

