/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.SectionBufferBuilderPool;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class SectionRenderDispatcher {
    private static final int MAX_HIGH_PRIORITY_QUOTA = 2;
    private final PriorityBlockingQueue<RenderSection.CompileTask> toBatchHighPriority = Queues.newPriorityBlockingQueue();
    private final Queue<RenderSection.CompileTask> toBatchLowPriority = Queues.newLinkedBlockingDeque();
    private int highPriorityQuota = 2;
    private final Queue<Runnable> toUpload = Queues.newConcurrentLinkedQueue();
    final SectionBufferBuilderPack fixedBuffers;
    private final SectionBufferBuilderPool bufferPool;
    private volatile int toBatchCount;
    private volatile boolean closed;
    private final ProcessorMailbox<Runnable> mailbox;
    private final Executor executor;
    ClientLevel level;
    final LevelRenderer renderer;
    private Vec3 camera = Vec3.ZERO;

    public SectionRenderDispatcher(ClientLevel p_299878_, LevelRenderer p_299032_, Executor p_298480_, RenderBuffers p_310401_) {
        this.level = p_299878_;
        this.renderer = p_299032_;
        this.fixedBuffers = p_310401_.fixedBufferPack();
        this.bufferPool = p_310401_.sectionBufferPool();
        this.executor = p_298480_;
        this.mailbox = ProcessorMailbox.create(p_298480_, "Section Renderer");
        this.mailbox.tell(this::runTask);
    }

    public void setLevel(ClientLevel p_298968_) {
        this.level = p_298968_;
    }

    private void runTask() {
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask;
        if (!this.closed && !this.bufferPool.isEmpty() && (sectionrenderdispatcher$rendersection$compiletask = this.pollTask()) != null) {
            SectionBufferBuilderPack sectionbufferbuilderpack = Objects.requireNonNull(this.bufferPool.acquire());
            this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
            ((CompletableFuture)CompletableFuture.supplyAsync(Util.wrapThreadWithTaskName(sectionrenderdispatcher$rendersection$compiletask.name(), () -> sectionrenderdispatcher$rendersection$compiletask.doTask(sectionbufferbuilderpack)), this.executor).thenCompose(p_298155_ -> p_298155_)).whenComplete((p_299295_, p_297995_) -> {
                if (p_297995_ != null) {
                    Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_297995_, "Batching sections"));
                } else {
                    this.mailbox.tell(() -> {
                        if (p_299295_ == SectionTaskResult.SUCCESSFUL) {
                            sectionbufferbuilderpack.clearAll();
                        } else {
                            sectionbufferbuilderpack.discardAll();
                        }
                        this.bufferPool.release(sectionbufferbuilderpack);
                        this.runTask();
                    });
                }
            });
        }
    }

    @Nullable
    private RenderSection.CompileTask pollTask() {
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask;
        if (this.highPriorityQuota <= 0 && (sectionrenderdispatcher$rendersection$compiletask = this.toBatchLowPriority.poll()) != null) {
            this.highPriorityQuota = 2;
            return sectionrenderdispatcher$rendersection$compiletask;
        }
        RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask1 = this.toBatchHighPriority.poll();
        if (sectionrenderdispatcher$rendersection$compiletask1 != null) {
            --this.highPriorityQuota;
            return sectionrenderdispatcher$rendersection$compiletask1;
        }
        this.highPriorityQuota = 2;
        return this.toBatchLowPriority.poll();
    }

    public String getStats() {
        return String.format(Locale.ROOT, "pC: %03d, pU: %02d, aB: %02d", this.toBatchCount, this.toUpload.size(), this.bufferPool.getFreeBufferCount());
    }

    public int getToBatchCount() {
        return this.toBatchCount;
    }

    public int getToUpload() {
        return this.toUpload.size();
    }

    public int getFreeBufferCount() {
        return this.bufferPool.getFreeBufferCount();
    }

    public void setCamera(Vec3 p_297762_) {
        this.camera = p_297762_;
    }

    public Vec3 getCameraPosition() {
        return this.camera;
    }

    public void uploadAllPendingUploads() {
        Runnable runnable;
        while ((runnable = this.toUpload.poll()) != null) {
            runnable.run();
        }
    }

    public void rebuildSectionSync(RenderSection p_299640_, RenderRegionCache p_297835_) {
        p_299640_.compileSync(p_297835_);
    }

    public void blockUntilClear() {
        this.clearBatchQueue();
    }

    public void schedule(RenderSection.CompileTask p_297747_) {
        if (!this.closed) {
            this.mailbox.tell(() -> {
                if (!this.closed) {
                    if (p_297747_.isHighPriority) {
                        this.toBatchHighPriority.offer(p_297747_);
                    } else {
                        this.toBatchLowPriority.offer(p_297747_);
                    }
                    this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
                    this.runTask();
                }
            });
        }
    }

    public CompletableFuture<Void> uploadSectionLayer(BufferBuilder.RenderedBuffer p_299767_, VertexBuffer p_298938_) {
        return this.closed ? CompletableFuture.completedFuture(null) : CompletableFuture.runAsync(() -> {
            if (p_298938_.isInvalid()) {
                p_299767_.release();
            } else {
                p_298938_.bind();
                p_298938_.upload(p_299767_);
                VertexBuffer.unbind();
            }
        }, this.toUpload::add);
    }

    private void clearBatchQueue() {
        while (!this.toBatchHighPriority.isEmpty()) {
            RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask = this.toBatchHighPriority.poll();
            if (sectionrenderdispatcher$rendersection$compiletask == null) continue;
            sectionrenderdispatcher$rendersection$compiletask.cancel();
        }
        while (!this.toBatchLowPriority.isEmpty()) {
            RenderSection.CompileTask sectionrenderdispatcher$rendersection$compiletask1 = this.toBatchLowPriority.poll();
            if (sectionrenderdispatcher$rendersection$compiletask1 == null) continue;
            sectionrenderdispatcher$rendersection$compiletask1.cancel();
        }
        this.toBatchCount = 0;
    }

    public boolean isQueueEmpty() {
        return this.toBatchCount == 0 && this.toUpload.isEmpty();
    }

    public void dispose() {
        this.closed = true;
        this.clearBatchQueue();
        this.uploadAllPendingUploads();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class RenderSection {
        public static final int SIZE = 16;
        public final int index;
        public final AtomicReference<CompiledSection> compiled = new AtomicReference<CompiledSection>(CompiledSection.UNCOMPILED);
        final AtomicInteger initialCompilationCancelCount = new AtomicInteger(0);
        @Nullable
        private RebuildTask lastRebuildTask;
        @Nullable
        private ResortTransparencyTask lastResortTransparencyTask;
        private final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
        private final Map<RenderType, VertexBuffer> buffers = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(p_298649_ -> p_298649_, p_299941_ -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
        private AABB bb;
        private boolean dirty = true;
        final BlockPos.MutableBlockPos origin = new BlockPos.MutableBlockPos(-1, -1, -1);
        private final BlockPos.MutableBlockPos[] relativeOrigins = Util.make(new BlockPos.MutableBlockPos[6], p_300613_ -> {
            for (int i = 0; i < ((BlockPos.MutableBlockPos[])p_300613_).length; ++i) {
                p_300613_[i] = new BlockPos.MutableBlockPos();
            }
        });
        private boolean playerChanged;

        public RenderSection(int p_299358_, int p_299044_, int p_300810_, int p_299840_) {
            this.index = p_299358_;
            this.setOrigin(p_299044_, p_300810_, p_299840_);
        }

        private boolean doesChunkExistAt(BlockPos p_297611_) {
            return SectionRenderDispatcher.this.level.getChunk(SectionPos.blockToSectionCoord(p_297611_.getX()), SectionPos.blockToSectionCoord(p_297611_.getZ()), ChunkStatus.FULL, false) != null;
        }

        public boolean hasAllNeighbors() {
            int i = 24;
            return !(this.getDistToPlayerSqr() > 576.0) ? true : this.doesChunkExistAt(this.relativeOrigins[Direction.WEST.ordinal()]) && this.doesChunkExistAt(this.relativeOrigins[Direction.NORTH.ordinal()]) && this.doesChunkExistAt(this.relativeOrigins[Direction.EAST.ordinal()]) && this.doesChunkExistAt(this.relativeOrigins[Direction.SOUTH.ordinal()]);
        }

        public AABB getBoundingBox() {
            return this.bb;
        }

        public VertexBuffer getBuffer(RenderType p_298748_) {
            return this.buffers.get((Object)p_298748_);
        }

        public void setOrigin(int p_298099_, int p_299019_, int p_299020_) {
            this.reset();
            this.origin.set(p_298099_, p_299019_, p_299020_);
            this.bb = new AABB(p_298099_, p_299019_, p_299020_, p_298099_ + 16, p_299019_ + 16, p_299020_ + 16);
            for (Direction direction : Direction.values()) {
                this.relativeOrigins[direction.ordinal()].set(this.origin).move(direction, 16);
            }
        }

        protected double getDistToPlayerSqr() {
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            double d0 = this.bb.minX + 8.0 - camera.getPosition().x;
            double d1 = this.bb.minY + 8.0 - camera.getPosition().y;
            double d2 = this.bb.minZ + 8.0 - camera.getPosition().z;
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        void beginLayer(BufferBuilder p_300604_) {
            p_300604_.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        }

        public CompiledSection getCompiled() {
            return this.compiled.get();
        }

        private void reset() {
            this.cancelTasks();
            this.compiled.set(CompiledSection.UNCOMPILED);
            this.dirty = true;
        }

        public void releaseBuffers() {
            this.reset();
            this.buffers.values().forEach(VertexBuffer::close);
        }

        public BlockPos getOrigin() {
            return this.origin;
        }

        public void setDirty(boolean p_298731_) {
            boolean flag = this.dirty;
            this.dirty = true;
            this.playerChanged = p_298731_ | (flag && this.playerChanged);
        }

        public void setNotDirty() {
            this.dirty = false;
            this.playerChanged = false;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public boolean isDirtyFromPlayer() {
            return this.dirty && this.playerChanged;
        }

        public BlockPos getRelativeOrigin(Direction p_299060_) {
            return this.relativeOrigins[p_299060_.ordinal()];
        }

        public boolean resortTransparency(RenderType p_301074_, SectionRenderDispatcher p_298196_) {
            CompiledSection sectionrenderdispatcher$compiledsection = this.getCompiled();
            if (this.lastResortTransparencyTask != null) {
                this.lastResortTransparencyTask.cancel();
            }
            if (!sectionrenderdispatcher$compiledsection.hasBlocks.contains((Object)p_301074_)) {
                return false;
            }
            this.lastResortTransparencyTask = new ResortTransparencyTask(new ChunkPos(this.getOrigin()), this.getDistToPlayerSqr(), sectionrenderdispatcher$compiledsection);
            p_298196_.schedule(this.lastResortTransparencyTask);
            return true;
        }

        protected boolean cancelTasks() {
            boolean flag = false;
            if (this.lastRebuildTask != null) {
                this.lastRebuildTask.cancel();
                this.lastRebuildTask = null;
                flag = true;
            }
            if (this.lastResortTransparencyTask != null) {
                this.lastResortTransparencyTask.cancel();
                this.lastResortTransparencyTask = null;
            }
            return flag;
        }

        public CompileTask createCompileTask(RenderRegionCache p_300037_) {
            boolean flag1;
            boolean flag = this.cancelTasks();
            BlockPos blockpos = this.origin.immutable();
            boolean i = true;
            RenderChunkRegion renderchunkregion = p_300037_.createRegion((Level)SectionRenderDispatcher.this.level, blockpos.offset(-1, -1, -1), blockpos.offset(16, 16, 16), 1);
            boolean bl = flag1 = this.compiled.get() == CompiledSection.UNCOMPILED;
            if (flag1 && flag) {
                this.initialCompilationCancelCount.incrementAndGet();
            }
            this.lastRebuildTask = new RebuildTask(new ChunkPos(this.getOrigin()), this.getDistToPlayerSqr(), renderchunkregion, !flag1 || this.initialCompilationCancelCount.get() > 2);
            return this.lastRebuildTask;
        }

        public void rebuildSectionAsync(SectionRenderDispatcher p_299090_, RenderRegionCache p_297331_) {
            CompileTask sectionrenderdispatcher$rendersection$compiletask = this.createCompileTask(p_297331_);
            p_299090_.schedule(sectionrenderdispatcher$rendersection$compiletask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateGlobalBlockEntities(Collection<BlockEntity> p_300373_) {
            HashSet set1;
            HashSet set = Sets.newHashSet(p_300373_);
            Set<BlockEntity> set2 = this.globalBlockEntities;
            synchronized (set2) {
                set1 = Sets.newHashSet(this.globalBlockEntities);
                set.removeAll(this.globalBlockEntities);
                set1.removeAll(p_300373_);
                this.globalBlockEntities.clear();
                this.globalBlockEntities.addAll(p_300373_);
            }
            SectionRenderDispatcher.this.renderer.updateGlobalBlockEntities(set1, set);
        }

        public void compileSync(RenderRegionCache p_298605_) {
            CompileTask sectionrenderdispatcher$rendersection$compiletask = this.createCompileTask(p_298605_);
            sectionrenderdispatcher$rendersection$compiletask.doTask(SectionRenderDispatcher.this.fixedBuffers);
        }

        public boolean isAxisAlignedWith(int p_297900_, int p_299871_, int p_299328_) {
            BlockPos blockpos = this.getOrigin();
            return p_297900_ == SectionPos.blockToSectionCoord(blockpos.getX()) || p_299328_ == SectionPos.blockToSectionCoord(blockpos.getZ()) || p_299871_ == SectionPos.blockToSectionCoord(blockpos.getY());
        }

        @OnlyIn(value=Dist.CLIENT)
        class ResortTransparencyTask
        extends CompileTask {
            private final CompiledSection compiledSection;

            @Deprecated
            public ResortTransparencyTask(double p_300619_, CompiledSection p_297742_) {
                this(null, p_300619_, p_297742_);
            }

            public ResortTransparencyTask(ChunkPos pos, double p_300619_, CompiledSection p_297742_) {
                super(RenderSection.this, pos, p_300619_, true);
                this.compiledSection = p_297742_;
            }

            @Override
            protected String name() {
                return "rend_chk_sort";
            }

            @Override
            public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack p_297366_) {
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.hasAllNeighbors()) {
                    this.isCancelled.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                Vec3 vec3 = SectionRenderDispatcher.this.getCameraPosition();
                float f = (float)vec3.x;
                float f1 = (float)vec3.y;
                float f2 = (float)vec3.z;
                BufferBuilder.SortState bufferbuilder$sortstate = this.compiledSection.transparencyState;
                if (bufferbuilder$sortstate != null && !this.compiledSection.isEmpty(RenderType.translucent())) {
                    BufferBuilder bufferbuilder = p_297366_.builder(RenderType.translucent());
                    RenderSection.this.beginLayer(bufferbuilder);
                    bufferbuilder.restoreSortState(bufferbuilder$sortstate);
                    bufferbuilder.setQuadSorting(VertexSorting.byDistance((float)(f - (float)RenderSection.this.origin.getX()), (float)(f1 - (float)RenderSection.this.origin.getY()), (float)(f2 - (float)RenderSection.this.origin.getZ())));
                    this.compiledSection.transparencyState = bufferbuilder.getSortState();
                    BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = bufferbuilder.end();
                    if (this.isCancelled.get()) {
                        bufferbuilder$renderedbuffer.release();
                        return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                    }
                    CompletionStage completablefuture = SectionRenderDispatcher.this.uploadSectionLayer(bufferbuilder$renderedbuffer, RenderSection.this.getBuffer(RenderType.translucent())).thenApply(p_297230_ -> SectionTaskResult.CANCELLED);
                    return ((CompletableFuture)completablefuture).handle((p_301037_, p_300486_) -> {
                        if (p_300486_ != null && !(p_300486_ instanceof CancellationException) && !(p_300486_ instanceof InterruptedException)) {
                            Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_300486_, "Rendering section"));
                        }
                        return this.isCancelled.get() ? SectionTaskResult.CANCELLED : SectionTaskResult.SUCCESSFUL;
                    });
                }
                return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
            }

            @Override
            public void cancel() {
                this.isCancelled.set(true);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        abstract class CompileTask
        implements Comparable<CompileTask> {
            protected final double distAtCreation;
            protected final AtomicBoolean isCancelled = new AtomicBoolean(false);
            protected final boolean isHighPriority;
            protected Map<BlockPos, ModelData> modelData;

            @Deprecated
            public CompileTask(RenderSection this$1, double p_300617_, boolean p_299251_) {
                this(this$1, null, p_300617_, p_299251_);
            }

            public CompileTask(@Nullable RenderSection this$1, ChunkPos pos, double p_300617_, boolean p_299251_) {
                this.distAtCreation = p_300617_;
                this.isHighPriority = p_299251_;
                this.modelData = pos == null ? Collections.emptyMap() : Minecraft.getInstance().level.getModelDataManager().getAt(pos);
            }

            public abstract CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack var1);

            public abstract void cancel();

            protected abstract String name();

            @Override
            public int compareTo(CompileTask p_298947_) {
                return Doubles.compare((double)this.distAtCreation, (double)p_298947_.distAtCreation);
            }

            public ModelData getModelData(BlockPos pos) {
                return this.modelData.getOrDefault(pos, ModelData.EMPTY);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class RebuildTask
        extends CompileTask {
            @Nullable
            protected RenderChunkRegion region;

            @Deprecated
            public RebuildTask(@Nullable double p_301300_, RenderChunkRegion p_300496_, boolean p_299891_) {
                this(null, p_301300_, p_300496_, p_299891_);
            }

            public RebuildTask(ChunkPos pos, @Nullable double p_301300_, RenderChunkRegion p_300496_, boolean p_299891_) {
                super(RenderSection.this, pos, p_301300_, p_299891_);
                this.region = p_300496_;
            }

            @Override
            protected String name() {
                return "rend_chk_rebuild";
            }

            @Override
            public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack p_299595_) {
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.hasAllNeighbors()) {
                    this.region = null;
                    RenderSection.this.setDirty(false);
                    this.isCancelled.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                Vec3 vec3 = SectionRenderDispatcher.this.getCameraPosition();
                float f = (float)vec3.x;
                float f1 = (float)vec3.y;
                float f2 = (float)vec3.z;
                CompileResults sectionrenderdispatcher$rendersection$rebuildtask$compileresults = this.compile(f, f1, f2, p_299595_);
                RenderSection.this.updateGlobalBlockEntities(sectionrenderdispatcher$rendersection$rebuildtask$compileresults.globalBlockEntities);
                if (this.isCancelled.get()) {
                    sectionrenderdispatcher$rendersection$rebuildtask$compileresults.renderedLayers.values().forEach(BufferBuilder.RenderedBuffer::release);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                CompiledSection sectionrenderdispatcher$compiledsection = new CompiledSection();
                sectionrenderdispatcher$compiledsection.visibilitySet = sectionrenderdispatcher$rendersection$rebuildtask$compileresults.visibilitySet;
                sectionrenderdispatcher$compiledsection.renderableBlockEntities.addAll(sectionrenderdispatcher$rendersection$rebuildtask$compileresults.blockEntities);
                sectionrenderdispatcher$compiledsection.transparencyState = sectionrenderdispatcher$rendersection$rebuildtask$compileresults.transparencyState;
                ArrayList list = Lists.newArrayList();
                sectionrenderdispatcher$rendersection$rebuildtask$compileresults.renderedLayers.forEach((p_301240_, p_299440_) -> {
                    list.add(SectionRenderDispatcher.this.uploadSectionLayer((BufferBuilder.RenderedBuffer)p_299440_, RenderSection.this.getBuffer((RenderType)((Object)p_301240_))));
                    sectionrenderdispatcher$compiledsection.hasBlocks.add((RenderType)((Object)p_301240_));
                });
                return Util.sequenceFailFast(list).handle((p_297447_, p_298622_) -> {
                    if (p_298622_ != null && !(p_298622_ instanceof CancellationException) && !(p_298622_ instanceof InterruptedException)) {
                        Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_298622_, "Rendering section"));
                    }
                    if (this.isCancelled.get()) {
                        return SectionTaskResult.CANCELLED;
                    }
                    RenderSection.this.compiled.set(sectionrenderdispatcher$compiledsection);
                    RenderSection.this.initialCompilationCancelCount.set(0);
                    SectionRenderDispatcher.this.renderer.addRecentlyCompiledSection(RenderSection.this);
                    return SectionTaskResult.SUCCESSFUL;
                });
            }

            private CompileResults compile(float p_297372_, float p_300511_, float p_298415_, SectionBufferBuilderPack p_300020_) {
                CompileResults sectionrenderdispatcher$rendersection$rebuildtask$compileresults = new CompileResults();
                boolean i = true;
                BlockPos blockpos = RenderSection.this.origin.immutable();
                BlockPos blockpos1 = blockpos.offset(15, 15, 15);
                VisGraph visgraph = new VisGraph();
                RenderChunkRegion renderchunkregion = this.region;
                this.region = null;
                PoseStack posestack = new PoseStack();
                if (renderchunkregion != null) {
                    BufferBuilder bufferbuilder1;
                    ModelBlockRenderer.enableCaching();
                    ReferenceArraySet set = new ReferenceArraySet(RenderType.chunkBufferLayers().size());
                    RandomSource randomsource = RandomSource.create();
                    BlockRenderDispatcher blockrenderdispatcher = Minecraft.getInstance().getBlockRenderer();
                    for (BlockPos blockpos2 : BlockPos.betweenClosed(blockpos, blockpos1)) {
                        FluidState fluidstate;
                        BlockEntity blockentity;
                        BlockState blockstate = renderchunkregion.getBlockState(blockpos2);
                        if (blockstate.isSolidRender(renderchunkregion, blockpos2)) {
                            visgraph.setOpaque(blockpos2);
                        }
                        if (blockstate.hasBlockEntity() && (blockentity = renderchunkregion.getBlockEntity(blockpos2)) != null) {
                            this.handleBlockEntity(sectionrenderdispatcher$rendersection$rebuildtask$compileresults, blockentity);
                        }
                        if (!(fluidstate = blockstate.getFluidState()).isEmpty()) {
                            RenderType rendertype = ItemBlockRenderTypes.getRenderLayer(fluidstate);
                            BufferBuilder bufferbuilder = p_300020_.builder(rendertype);
                            if (set.add(rendertype)) {
                                RenderSection.this.beginLayer(bufferbuilder);
                            }
                            blockrenderdispatcher.renderLiquid(blockpos2, renderchunkregion, (VertexConsumer)((Object)bufferbuilder), blockstate, fluidstate);
                        }
                        if (blockstate.getRenderShape() == RenderShape.INVISIBLE) continue;
                        BakedModel model = blockrenderdispatcher.getBlockModel(blockstate);
                        ModelData modelData = model.getModelData(renderchunkregion, blockpos2, blockstate, this.getModelData(blockpos2));
                        randomsource.setSeed(blockstate.getSeed(blockpos2));
                        for (RenderType rendertype2 : model.getRenderTypes(blockstate, randomsource, modelData)) {
                            BufferBuilder bufferbuilder2 = p_300020_.builder(rendertype2);
                            if (set.add(rendertype2)) {
                                RenderSection.this.beginLayer(bufferbuilder2);
                            }
                            posestack.pushPose();
                            posestack.translate(blockpos2.getX() & 0xF, blockpos2.getY() & 0xF, blockpos2.getZ() & 0xF);
                            blockrenderdispatcher.renderBatched(blockstate, blockpos2, renderchunkregion, posestack, (VertexConsumer)((Object)bufferbuilder2), true, randomsource, modelData, rendertype2);
                            posestack.popPose();
                        }
                    }
                    if (set.contains((Object)RenderType.translucent()) && !(bufferbuilder1 = p_300020_.builder(RenderType.translucent())).isCurrentBatchEmpty()) {
                        bufferbuilder1.setQuadSorting(VertexSorting.byDistance((float)(p_297372_ - (float)blockpos.getX()), (float)(p_300511_ - (float)blockpos.getY()), (float)(p_298415_ - (float)blockpos.getZ())));
                        sectionrenderdispatcher$rendersection$rebuildtask$compileresults.transparencyState = bufferbuilder1.getSortState();
                    }
                    for (RenderType rendertype1 : set) {
                        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = p_300020_.builder(rendertype1).endOrDiscardIfEmpty();
                        if (bufferbuilder$renderedbuffer == null) continue;
                        sectionrenderdispatcher$rendersection$rebuildtask$compileresults.renderedLayers.put(rendertype1, bufferbuilder$renderedbuffer);
                    }
                    ModelBlockRenderer.clearCache();
                }
                sectionrenderdispatcher$rendersection$rebuildtask$compileresults.visibilitySet = visgraph.resolve();
                return sectionrenderdispatcher$rendersection$rebuildtask$compileresults;
            }

            private <E extends BlockEntity> void handleBlockEntity(CompileResults p_297364_, E p_299361_) {
                BlockEntityRenderer blockentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(p_299361_);
                if (blockentityrenderer != null) {
                    if (blockentityrenderer.shouldRenderOffScreen(p_299361_)) {
                        p_297364_.globalBlockEntities.add(p_299361_);
                    } else {
                        p_297364_.blockEntities.add(p_299361_);
                    }
                }
            }

            @Override
            public void cancel() {
                this.region = null;
                if (this.isCancelled.compareAndSet(false, true)) {
                    RenderSection.this.setDirty(false);
                }
            }

            @OnlyIn(value=Dist.CLIENT)
            static final class CompileResults {
                public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
                public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
                public final Map<RenderType, BufferBuilder.RenderedBuffer> renderedLayers = new Reference2ObjectArrayMap();
                public VisibilitySet visibilitySet = new VisibilitySet();
                @Nullable
                public BufferBuilder.SortState transparencyState;

                CompileResults() {
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum SectionTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CompiledSection {
        public static final CompiledSection UNCOMPILED = new CompiledSection(){

            @Override
            public boolean facesCanSeeEachother(Direction p_301280_, Direction p_299155_) {
                return false;
            }
        };
        final Set<RenderType> hasBlocks = new ObjectArraySet(RenderType.chunkBufferLayers().size());
        final List<BlockEntity> renderableBlockEntities = Lists.newArrayList();
        VisibilitySet visibilitySet = new VisibilitySet();
        @Nullable
        BufferBuilder.SortState transparencyState;

        public boolean hasNoRenderableLayers() {
            return this.hasBlocks.isEmpty();
        }

        public boolean isEmpty(RenderType p_300861_) {
            return !this.hasBlocks.contains((Object)p_300861_);
        }

        public List<BlockEntity> getRenderableBlockEntities() {
            return this.renderableBlockEntities;
        }

        public boolean facesCanSeeEachother(Direction p_301006_, Direction p_300193_) {
            return this.visibilitySet.visibilityBetween(p_301006_, p_300193_);
        }
    }
}

