/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import net.minecraftforge.client.event.RenderNameTagEvent;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityRenderer<T extends Entity> {
    protected static final float NAMETAG_SCALE = 0.025f;
    protected final EntityRenderDispatcher entityRenderDispatcher;
    private final Font font;
    protected float shadowRadius;
    protected float shadowStrength = 1.0f;

    protected EntityRenderer(EntityRendererProvider.Context p_174008_) {
        this.entityRenderDispatcher = p_174008_.getEntityRenderDispatcher();
        this.font = p_174008_.getFont();
    }

    public final int getPackedLightCoords(T p_114506_, float p_114507_) {
        BlockPos blockpos = BlockPos.containing(((Entity)p_114506_).getLightProbePosition(p_114507_));
        return LightTexture.pack(this.getBlockLightLevel(p_114506_, blockpos), this.getSkyLightLevel(p_114506_, blockpos));
    }

    protected int getSkyLightLevel(T p_114509_, BlockPos p_114510_) {
        return ((Entity)p_114509_).level().getBrightness(LightLayer.SKY, p_114510_);
    }

    protected int getBlockLightLevel(T p_114496_, BlockPos p_114497_) {
        return ((Entity)p_114496_).isOnFire() ? 15 : ((Entity)p_114496_).level().getBrightness(LightLayer.BLOCK, p_114497_);
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        if (!((Entity)p_114491_).shouldRender(p_114493_, p_114494_, p_114495_)) {
            return false;
        }
        if (((Entity)p_114491_).noCulling) {
            return true;
        }
        AABB aabb = ((Entity)p_114491_).getBoundingBoxForCulling().inflate(0.5);
        if (aabb.hasNaN() || aabb.getSize() == 0.0) {
            aabb = new AABB(((Entity)p_114491_).getX() - 2.0, ((Entity)p_114491_).getY() - 2.0, ((Entity)p_114491_).getZ() - 2.0, ((Entity)p_114491_).getX() + 2.0, ((Entity)p_114491_).getY() + 2.0, ((Entity)p_114491_).getZ() + 2.0);
        }
        return p_114492_.isVisible(aabb);
    }

    public Vec3 getRenderOffset(T p_114483_, float p_114484_) {
        return Vec3.ZERO;
    }

    public void render(T p_114485_, float p_114486_, float p_114487_, PoseStack p_114488_, MultiBufferSource p_114489_, int p_114490_) {
        RenderNameTagEvent event = ForgeEventFactoryClient.fireRenderNameTagEvent(p_114485_, (Component)((Entity)p_114485_).getDisplayName(), (EntityRenderer)this, (PoseStack)p_114488_, (MultiBufferSource)p_114489_, (int)p_114490_, (float)p_114487_);
        if (!event.getResult().isDenied() && (event.getResult().isAllowed() || this.shouldShowName(p_114485_))) {
            this.renderNameTag(p_114485_, event.getContent(), p_114488_, p_114489_, p_114490_, p_114487_);
        }
    }

    protected boolean shouldShowName(T p_114504_) {
        return ((Entity)p_114504_).shouldShowName() || ((Entity)p_114504_).hasCustomName() && p_114504_ == this.entityRenderDispatcher.crosshairPickEntity;
    }

    public abstract ResourceLocation getTextureLocation(T var1);

    public Font getFont() {
        return this.font;
    }

    protected void renderNameTag(T p_114498_, Component p_114499_, PoseStack p_114500_, MultiBufferSource p_114501_, int p_114502_, float p_334448_) {
        Vec3 vec3;
        double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)p_114498_);
        if (ForgeHooksClient.isNameplateInRenderDistance(p_114498_, (double)d0) && (vec3 = ((Entity)p_114498_).getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, ((Entity)p_114498_).getViewYRot(p_334448_))) != null) {
            boolean flag = !((Entity)p_114498_).isDiscrete();
            int i = "deadmau5".equals(p_114499_.getString()) ? -10 : 0;
            p_114500_.pushPose();
            p_114500_.translate(vec3.x, vec3.y + 0.5, vec3.z);
            p_114500_.mulPose(this.entityRenderDispatcher.cameraOrientation());
            p_114500_.scale(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = p_114500_.last().pose();
            float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int j = (int)(f * 255.0f) << 24;
            Font font = this.getFont();
            float f1 = -font.width(p_114499_) / 2;
            font.drawInBatch(p_114499_, f1, (float)i, 0x20FFFFFF, false, matrix4f, p_114501_, flag ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, p_114502_);
            if (flag) {
                font.drawInBatch(p_114499_, f1, (float)i, -1, false, matrix4f, p_114501_, Font.DisplayMode.NORMAL, 0, p_114502_);
            }
            p_114500_.popPose();
        }
    }

    protected float getShadowRadius(T p_335587_) {
        return this.shadowRadius;
    }
}

