/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.Dumpable;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TextureAtlas
extends AbstractTexture
implements Dumpable,
Tickable {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Deprecated
    public static final ResourceLocation LOCATION_BLOCKS = InventoryMenu.BLOCK_ATLAS;
    @Deprecated
    public static final ResourceLocation LOCATION_PARTICLES = new ResourceLocation("textures/atlas/particles.png");
    private List<SpriteContents> sprites = List.of();
    private List<TextureAtlasSprite.Ticker> animatedTextures = List.of();
    private Map<ResourceLocation, TextureAtlasSprite> texturesByName = Map.of();
    @Nullable
    private TextureAtlasSprite missingSprite;
    private final ResourceLocation location;
    private final int maxSupportedTextureSize;
    private int width;
    private int height;
    private int mipLevel;

    public TextureAtlas(ResourceLocation p_118269_) {
        this.location = p_118269_;
        this.maxSupportedTextureSize = RenderSystem.maxSupportedTextureSize();
    }

    @Override
    public void load(ResourceManager p_118282_) {
    }

    public void upload(SpriteLoader.Preparations p_250662_) {
        LOGGER.info("Created: {}x{}x{} {}-atlas", new Object[]{p_250662_.width(), p_250662_.height(), p_250662_.mipLevel(), this.location});
        TextureUtil.prepareImage((int)this.getId(), (int)p_250662_.mipLevel(), (int)p_250662_.width(), (int)p_250662_.height());
        this.width = p_250662_.width();
        this.height = p_250662_.height();
        this.mipLevel = p_250662_.mipLevel();
        this.clearTextureData();
        this.texturesByName = Map.copyOf(p_250662_.regions());
        this.missingSprite = this.texturesByName.get(MissingTextureAtlasSprite.getLocation());
        if (this.missingSprite == null) {
            throw new IllegalStateException("Atlas '" + String.valueOf(this.location) + "' (" + this.texturesByName.size() + " sprites) has no missing texture sprite");
        }
        ArrayList<SpriteContents> list = new ArrayList<SpriteContents>();
        ArrayList<TextureAtlasSprite.Ticker> list1 = new ArrayList<TextureAtlasSprite.Ticker>();
        for (TextureAtlasSprite textureatlassprite : p_250662_.regions().values()) {
            list.add(textureatlassprite.contents());
            try {
                textureatlassprite.uploadFirstFrame();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Stitching texture atlas");
                CrashReportCategory crashreportcategory = crashreport.addCategory("Texture being stitched together");
                crashreportcategory.setDetail("Atlas path", this.location);
                crashreportcategory.setDetail("Sprite", textureatlassprite);
                throw new ReportedException(crashreport);
            }
            TextureAtlasSprite.Ticker textureatlassprite$ticker = textureatlassprite.createTicker();
            if (textureatlassprite$ticker == null) continue;
            list1.add(textureatlassprite$ticker);
        }
        this.sprites = List.copyOf(list);
        this.animatedTextures = List.copyOf(list1);
        ForgeHooksClient.onTextureStitchedPost((TextureAtlas)this);
    }

    public void dumpContents(ResourceLocation p_276106_, Path p_276127_) throws IOException {
        String s = p_276106_.toDebugFileName();
        TextureUtil.writeAsPNG((Path)p_276127_, (String)s, (int)this.getId(), (int)this.mipLevel, (int)this.width, (int)this.height);
        TextureAtlas.dumpSpriteNames(p_276127_, s, this.texturesByName);
    }

    private static void dumpSpriteNames(Path p_261769_, String p_262102_, Map<ResourceLocation, TextureAtlasSprite> p_261722_) {
        Path path = p_261769_.resolve(p_262102_ + ".txt");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (Map.Entry entry : p_261722_.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)entry.getValue();
                writer.write(String.format(Locale.ROOT, "%s\tx=%d\ty=%d\tw=%d\th=%d%n", entry.getKey(), textureatlassprite.getX(), textureatlassprite.getY(), textureatlassprite.contents().width(), textureatlassprite.contents().height()));
            }
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to write file {}", (Object)path, (Object)ioexception);
        }
    }

    public void cycleAnimationFrames() {
        this.bind();
        for (TextureAtlasSprite.Ticker textureatlassprite$ticker : this.animatedTextures) {
            textureatlassprite$ticker.tickAndUpload();
        }
    }

    public void tick() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::cycleAnimationFrames);
        } else {
            this.cycleAnimationFrames();
        }
    }

    public TextureAtlasSprite getSprite(ResourceLocation p_118317_) {
        TextureAtlasSprite textureatlassprite = this.texturesByName.getOrDefault(p_118317_, this.missingSprite);
        if (textureatlassprite == null) {
            throw new IllegalStateException("Tried to lookup sprite, but atlas is not initialized");
        }
        return textureatlassprite;
    }

    public void clearTextureData() {
        this.sprites.forEach(SpriteContents::close);
        this.animatedTextures.forEach(TextureAtlasSprite.Ticker::close);
        this.sprites = List.of();
        this.animatedTextures = List.of();
        this.texturesByName = Map.of();
        this.missingSprite = null;
    }

    public ResourceLocation location() {
        return this.location;
    }

    public int maxSupportedTextureSize() {
        return this.maxSupportedTextureSize;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    public void updateFilter(SpriteLoader.Preparations p_251993_) {
        this.setFilter(false, p_251993_.mipLevel() > 0);
    }

    public Set<ResourceLocation> getTextureLocations() {
        return Collections.unmodifiableSet(this.texturesByName.keySet());
    }
}

