/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakery {
    public static final Material FIRE_0 = new Material(TextureAtlas.LOCATION_BLOCKS, new ResourceLocation("block/fire_0"));
    public static final Material FIRE_1 = new Material(TextureAtlas.LOCATION_BLOCKS, new ResourceLocation("block/fire_1"));
    public static final Material LAVA_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, new ResourceLocation("block/lava_flow"));
    public static final Material WATER_FLOW = new Material(TextureAtlas.LOCATION_BLOCKS, new ResourceLocation("block/water_flow"));
    public static final Material WATER_OVERLAY = new Material(TextureAtlas.LOCATION_BLOCKS, new ResourceLocation("block/water_overlay"));
    public static final Material BANNER_BASE = new Material(Sheets.BANNER_SHEET, new ResourceLocation("entity/banner_base"));
    public static final Material SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, new ResourceLocation("entity/shield_base"));
    public static final Material NO_PATTERN_SHIELD = new Material(Sheets.SHIELD_SHEET, new ResourceLocation("entity/shield_base_nopattern"));
    public static final int DESTROY_STAGE_COUNT = 10;
    public static final List<ResourceLocation> DESTROY_STAGES = IntStream.range(0, 10).mapToObj(p_119253_ -> new ResourceLocation("block/destroy_stage_" + p_119253_)).collect(Collectors.toList());
    public static final List<ResourceLocation> BREAKING_LOCATIONS = DESTROY_STAGES.stream().map(p_119371_ -> new ResourceLocation("textures/" + p_119371_.getPath() + ".png")).collect(Collectors.toList());
    public static final List<RenderType> DESTROY_TYPES = BREAKING_LOCATIONS.stream().map(RenderType::crumbling).collect(Collectors.toList());
    static final int SINGLETON_MODEL_GROUP = -1;
    private static final int INVISIBLE_MODEL_GROUP = 0;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String BUILTIN_SLASH = "builtin/";
    private static final String BUILTIN_SLASH_GENERATED = "builtin/generated";
    private static final String BUILTIN_BLOCK_ENTITY = "builtin/entity";
    private static final String MISSING_MODEL_NAME = "missing";
    public static final ModelResourceLocation MISSING_MODEL_LOCATION = ModelResourceLocation.vanilla((String)"builtin/missing", (String)"missing");
    public static final FileToIdConverter BLOCKSTATE_LISTER = FileToIdConverter.json("blockstates");
    public static final FileToIdConverter MODEL_LISTER = FileToIdConverter.json("models");
    @VisibleForTesting
    public static final String MISSING_MODEL_MESH = ("{    'textures': {       'particle': '" + MissingTextureAtlasSprite.getLocation().getPath() + "',       'missingno': '" + MissingTextureAtlasSprite.getLocation().getPath() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> BUILTIN_MODELS = Maps.newHashMap((Map)ImmutableMap.of((Object)"missing", (Object)MISSING_MODEL_MESH));
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);
    public static final BlockModel GENERATION_MARKER = Util.make(BlockModel.fromString("{\"gui_light\": \"front\"}"), p_119359_ -> {
        p_119359_.name = "generation marker";
    });
    public static final BlockModel BLOCK_ENTITY_MARKER = Util.make(BlockModel.fromString("{\"gui_light\": \"side\"}"), p_119297_ -> {
        p_119297_.name = "block entity marker";
    });
    private static final StateDefinition<Block, BlockState> ITEM_FRAME_FAKE_DEFINITION = new StateDefinition.Builder(Blocks.AIR).add(BooleanProperty.create("map")).create(Block::defaultBlockState, BlockState::new);
    static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private static final Map<ResourceLocation, StateDefinition<Block, BlockState>> STATIC_DEFINITIONS = ImmutableMap.of((Object)new ResourceLocation("item_frame"), ITEM_FRAME_FAKE_DEFINITION, (Object)new ResourceLocation("glow_item_frame"), ITEM_FRAME_FAKE_DEFINITION);
    private final BlockColors blockColors;
    private final Map<ResourceLocation, BlockModel> modelResources;
    private final Map<ResourceLocation, List<LoadedJson>> blockStateResources;
    private final Set<ResourceLocation> loadingStack = Sets.newHashSet();
    private final BlockModelDefinition.Context context = new BlockModelDefinition.Context();
    private final Map<ResourceLocation, UnbakedModel> unbakedCache = Maps.newHashMap();
    final Map<BakedCacheKey, BakedModel> bakedCache = Maps.newHashMap();
    private final Map<ResourceLocation, UnbakedModel> topLevelModels = Maps.newHashMap();
    private final Map<ResourceLocation, BakedModel> bakedTopLevelModels = Maps.newHashMap();
    private int nextModelGroup = 1;
    private final Object2IntMap<BlockState> modelGroups = (Object2IntMap)Util.make(new Object2IntOpenHashMap(), p_119309_ -> p_119309_.defaultReturnValue(-1));

    public ModelBakery(BlockColors p_249183_, ProfilerFiller p_252014_, Map<ResourceLocation, BlockModel> p_251087_, Map<ResourceLocation, List<LoadedJson>> p_250416_) {
        this.blockColors = p_249183_;
        this.modelResources = p_251087_;
        this.blockStateResources = p_250416_;
        p_252014_.push("missing_model");
        try {
            this.unbakedCache.put((ResourceLocation)MISSING_MODEL_LOCATION, this.loadBlockModel((ResourceLocation)MISSING_MODEL_LOCATION));
            this.loadTopLevel(MISSING_MODEL_LOCATION);
        }
        catch (IOException ioexception) {
            LOGGER.error("Error loading missing model, should never happen :(", (Throwable)ioexception);
            throw new RuntimeException(ioexception);
        }
        p_252014_.popPush("static_definitions");
        STATIC_DEFINITIONS.forEach((p_119347_, p_119348_) -> p_119348_.getPossibleStates().forEach(p_174905_ -> this.loadTopLevel(BlockModelShaper.stateToModelLocation(p_119347_, p_174905_))));
        p_252014_.popPush("blocks");
        for (Block block : BuiltInRegistries.BLOCK) {
            block.getStateDefinition().getPossibleStates().forEach(p_119264_ -> this.loadTopLevel(BlockModelShaper.stateToModelLocation(p_119264_)));
        }
        p_252014_.popPush("items");
        for (ResourceLocation resourcelocation : BuiltInRegistries.ITEM.keySet()) {
            this.loadTopLevel(new ModelResourceLocation(resourcelocation, "inventory"));
        }
        p_252014_.popPush("special");
        this.loadTopLevel(ItemRenderer.TRIDENT_IN_HAND_MODEL);
        this.loadTopLevel(ItemRenderer.SPYGLASS_IN_HAND_MODEL);
        HashSet additionalModels = Sets.newHashSet();
        ForgeHooksClient.onRegisterAdditionalModels((Set)additionalModels);
        for (ResourceLocation rl : additionalModels) {
            UnbakedModel unbakedmodel = this.getModel(rl);
            this.unbakedCache.put(rl, unbakedmodel);
            this.topLevelModels.put(rl, unbakedmodel);
        }
        this.topLevelModels.values().forEach(p_247954_ -> p_247954_.resolveParents(this::getModel));
        p_252014_.pop();
    }

    public void bakeModels(BiFunction<ResourceLocation, Material, TextureAtlasSprite> p_248669_) {
        this.topLevelModels.keySet().forEach(p_247958_ -> {
            BakedModel bakedmodel = null;
            try {
                bakedmodel = new ModelBakerImpl(p_248669_, (ResourceLocation)p_247958_).bake((ResourceLocation)p_247958_, (ModelState)BlockModelRotation.X0_Y0);
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to bake model: '{}': {}", p_247958_, (Object)exception);
            }
            if (bakedmodel != null) {
                this.bakedTopLevelModels.put((ResourceLocation)p_247958_, bakedmodel);
            }
        });
    }

    private static Predicate<BlockState> predicate(StateDefinition<Block, BlockState> p_119274_, String p_119275_) {
        HashMap map = Maps.newHashMap();
        for (String s : COMMA_SPLITTER.split((CharSequence)p_119275_)) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            Property<?> property = p_119274_.getProperty(s1);
            if (property != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Object comparable = ModelBakery.getValueHelper(property, s2);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + String.valueOf(property.getPossibleValues()));
                }
                map.put(property, comparable);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        Block block = p_119274_.getOwner();
        return p_119262_ -> {
            if (p_119262_ != null && p_119262_.is(block)) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(p_119262_.getValue((Property)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T getValueHelper(Property<T> p_119277_, String p_119278_) {
        return (T)((Comparable)p_119277_.getValue(p_119278_).orElse(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnbakedModel getModel(ResourceLocation p_119342_) {
        if (this.unbakedCache.containsKey(p_119342_)) {
            return this.unbakedCache.get(p_119342_);
        }
        if (this.loadingStack.contains(p_119342_)) {
            throw new IllegalStateException("Circular reference while loading " + String.valueOf(p_119342_));
        }
        this.loadingStack.add(p_119342_);
        UnbakedModel unbakedmodel = this.unbakedCache.get(MISSING_MODEL_LOCATION);
        while (!this.loadingStack.isEmpty()) {
            ResourceLocation resourcelocation = this.loadingStack.iterator().next();
            try {
                if (this.unbakedCache.containsKey(resourcelocation)) continue;
                this.loadModel(resourcelocation);
            }
            catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                LOGGER.warn(modelbakery$blockstatedefinitionexception.getMessage());
                this.unbakedCache.put(resourcelocation, unbakedmodel);
            }
            catch (Exception exception) {
                LOGGER.warn("Unable to load model: '{}' referenced from: {}: {}", new Object[]{resourcelocation, p_119342_, exception});
                this.unbakedCache.put(resourcelocation, unbakedmodel);
            }
            finally {
                this.loadingStack.remove(resourcelocation);
            }
        }
        return this.unbakedCache.getOrDefault(p_119342_, unbakedmodel);
    }

    private void loadModel(ResourceLocation p_119363_) throws Exception {
        if (!(p_119363_ instanceof ModelResourceLocation)) {
            this.cacheAndQueueDependencies(p_119363_, this.loadBlockModel(p_119363_));
        } else {
            ModelResourceLocation modelresourcelocation = (ModelResourceLocation)p_119363_;
            if (Objects.equals(modelresourcelocation.getVariant(), "inventory")) {
                ResourceLocation resourcelocation = p_119363_.withPrefix("item/");
                BlockModel blockmodel = this.loadBlockModel(resourcelocation);
                this.cacheAndQueueDependencies((ResourceLocation)modelresourcelocation, blockmodel);
                this.unbakedCache.put(resourcelocation, blockmodel);
            } else {
                ResourceLocation resourcelocation2 = new ResourceLocation(p_119363_.getNamespace(), p_119363_.getPath());
                StateDefinition statedefinition = Optional.ofNullable(STATIC_DEFINITIONS.get(resourcelocation2)).orElseGet(() -> BuiltInRegistries.BLOCK.get(resourcelocation2).getStateDefinition());
                this.context.setDefinition(statedefinition);
                ImmutableList list = ImmutableList.copyOf(this.blockColors.getColoringProperties((Block)statedefinition.getOwner()));
                ImmutableList immutablelist = statedefinition.getPossibleStates();
                HashMap map = Maps.newHashMap();
                immutablelist.forEach(p_119330_ -> map.put(BlockModelShaper.stateToModelLocation(resourcelocation2, p_119330_), p_119330_));
                HashMap map1 = Maps.newHashMap();
                ResourceLocation resourcelocation1 = BLOCKSTATE_LISTER.idToFile(p_119363_);
                UnbakedModel unbakedmodel = this.unbakedCache.get(MISSING_MODEL_LOCATION);
                ModelGroupKey modelbakery$modelgroupkey = new ModelGroupKey((List<UnbakedModel>)ImmutableList.of((Object)unbakedmodel), (List<Object>)ImmutableList.of());
                Pair pair = Pair.of((Object)unbakedmodel, () -> modelbakery$modelgroupkey);
                try {
                    for (Pair pair1 : this.blockStateResources.getOrDefault(resourcelocation1, List.of()).stream().map(p_247956_ -> {
                        try {
                            return Pair.of((Object)p_247956_.source, (Object)BlockModelDefinition.fromJsonElement((BlockModelDefinition.Context)this.context, (JsonElement)p_247956_.data));
                        }
                        catch (Exception exception1) {
                            throw new BlockStateDefinitionException(String.format(Locale.ROOT, "Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", resourcelocation1, p_247956_.source, exception1.getMessage()));
                        }
                    }).toList()) {
                        MultiPart multipart;
                        BlockModelDefinition blockmodeldefinition = (BlockModelDefinition)pair1.getSecond();
                        IdentityHashMap map2 = Maps.newIdentityHashMap();
                        if (blockmodeldefinition.isMultiPart()) {
                            multipart = blockmodeldefinition.getMultiPart();
                            immutablelist.forEach(arg_0 -> ModelBakery.lambda$loadModel$16(map2, multipart, (List)list, arg_0));
                        } else {
                            multipart = null;
                        }
                        blockmodeldefinition.getVariants().forEach((arg_0, arg_1) -> ModelBakery.lambda$loadModel$20(immutablelist, statedefinition, map2, (List)list, multipart, pair, blockmodeldefinition, resourcelocation1, pair1, arg_0, arg_1));
                        map1.putAll(map2);
                    }
                }
                catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                    throw modelbakery$blockstatedefinitionexception;
                }
                catch (Exception exception) {
                    throw new BlockStateDefinitionException(String.format(Locale.ROOT, "Exception loading blockstate definition: '%s': %s", resourcelocation1, exception));
                }
                finally {
                    HashMap map3 = Maps.newHashMap();
                    map.forEach((p_119336_, p_119337_) -> {
                        Pair pair2 = (Pair)map1.get(p_119337_);
                        if (pair2 == null) {
                            LOGGER.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)resourcelocation1, p_119336_);
                            pair2 = pair;
                        }
                        this.cacheAndQueueDependencies((ResourceLocation)p_119336_, (UnbakedModel)pair2.getFirst());
                        try {
                            ModelGroupKey modelbakery$modelgroupkey1 = (ModelGroupKey)((Supplier)pair2.getSecond()).get();
                            map3.computeIfAbsent(modelbakery$modelgroupkey1, p_174894_ -> Sets.newIdentityHashSet()).add(p_119337_);
                        }
                        catch (Exception exception1) {
                            LOGGER.warn("Exception evaluating model definition: '{}'", p_119336_, (Object)exception1);
                        }
                    });
                    map3.forEach((p_284640_, p_284641_) -> {
                        Iterator iterator = p_284641_.iterator();
                        while (iterator.hasNext()) {
                            BlockState blockstate = (BlockState)iterator.next();
                            if (blockstate.getRenderShape() == RenderShape.MODEL) continue;
                            iterator.remove();
                            this.modelGroups.put((Object)blockstate, 0);
                        }
                        if (p_284641_.size() > 1) {
                            this.registerModelGroup((Iterable<BlockState>)p_284641_);
                        }
                    });
                }
            }
        }
    }

    private void cacheAndQueueDependencies(ResourceLocation p_119353_, UnbakedModel p_119354_) {
        this.unbakedCache.put(p_119353_, p_119354_);
        this.loadingStack.addAll(p_119354_.getDependencies());
    }

    private void loadTopLevel(ModelResourceLocation p_119307_) {
        UnbakedModel unbakedmodel = this.getModel((ResourceLocation)p_119307_);
        this.unbakedCache.put((ResourceLocation)p_119307_, unbakedmodel);
        this.topLevelModels.put((ResourceLocation)p_119307_, unbakedmodel);
    }

    private void registerModelGroup(Iterable<BlockState> p_119311_) {
        int i = this.nextModelGroup++;
        p_119311_.forEach(p_119256_ -> this.modelGroups.put(p_119256_, i));
    }

    protected BlockModel loadBlockModel(ResourceLocation p_119365_) throws IOException {
        String s = p_119365_.getPath();
        if (BUILTIN_SLASH_GENERATED.equals(s)) {
            return GENERATION_MARKER;
        }
        if (BUILTIN_BLOCK_ENTITY.equals(s)) {
            return BLOCK_ENTITY_MARKER;
        }
        if (s.startsWith(BUILTIN_SLASH)) {
            String s1 = s.substring(BUILTIN_SLASH.length());
            String s2 = BUILTIN_MODELS.get(s1);
            if (s2 == null) {
                throw new FileNotFoundException(p_119365_.toString());
            }
            StringReader reader = new StringReader(s2);
            BlockModel blockmodel1 = BlockModel.fromStream(reader);
            blockmodel1.name = p_119365_.toString();
            return blockmodel1;
        }
        ResourceLocation resourcelocation = MODEL_LISTER.idToFile(p_119365_);
        BlockModel blockmodel = this.modelResources.get(resourcelocation);
        if (blockmodel == null) {
            throw new FileNotFoundException(resourcelocation.toString());
        }
        blockmodel.name = p_119365_.toString();
        return blockmodel;
    }

    public Map<ResourceLocation, BakedModel> getBakedTopLevelModels() {
        return this.bakedTopLevelModels;
    }

    public Object2IntMap<BlockState> getModelGroups() {
        return this.modelGroups;
    }

    private static /* synthetic */ void lambda$loadModel$20(ImmutableList immutablelist, StateDefinition statedefinition, Map map2, List list, MultiPart multipart, Pair pair, BlockModelDefinition blockmodeldefinition, ResourceLocation resourcelocation1, Pair pair1, String p_119289_, MultiVariant p_119290_) {
        try {
            immutablelist.stream().filter(ModelBakery.predicate(statedefinition, p_119289_)).forEach(p_174902_ -> {
                Pair pair2 = map2.put(p_174902_, Pair.of((Object)p_119290_, () -> ModelGroupKey.create(p_174902_, p_119290_, list)));
                if (pair2 != null && pair2.getFirst() != multipart) {
                    map2.put(p_174902_, pair);
                    throw new RuntimeException("Overlapping definition with: " + (String)blockmodeldefinition.getVariants().entrySet().stream().filter(p_174892_ -> p_174892_.getValue() == pair2.getFirst()).findFirst().get().getKey());
                }
            });
        }
        catch (Exception exception1) {
            LOGGER.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", new Object[]{resourcelocation1, pair1.getFirst(), p_119289_, exception1.getMessage()});
        }
    }

    private static /* synthetic */ void lambda$loadModel$16(Map map2, MultiPart multipart, List list, BlockState p_119326_) {
        map2.put(p_119326_, Pair.of((Object)multipart, () -> ModelGroupKey.create(p_119326_, multipart, list)));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BlockStateDefinitionException
    extends RuntimeException {
        public BlockStateDefinitionException(String p_119373_) {
            super(p_119373_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ModelGroupKey {
        private final List<UnbakedModel> models;
        private final List<Object> coloringValues;

        public ModelGroupKey(List<UnbakedModel> p_119377_, List<Object> p_119378_) {
            this.models = p_119377_;
            this.coloringValues = p_119378_;
        }

        public boolean equals(Object p_119395_) {
            boolean bl;
            if (this == p_119395_) {
                return true;
            }
            if (!(p_119395_ instanceof ModelGroupKey)) {
                bl = false;
            } else {
                ModelGroupKey modelbakery$modelgroupkey = (ModelGroupKey)p_119395_;
                bl = Objects.equals(this.models, modelbakery$modelgroupkey.models) && Objects.equals(this.coloringValues, modelbakery$modelgroupkey.coloringValues);
            }
            return bl;
        }

        public int hashCode() {
            return 31 * this.models.hashCode() + this.coloringValues.hashCode();
        }

        public static ModelGroupKey create(BlockState p_119380_, MultiPart p_119381_, Collection<Property<?>> p_119382_) {
            StateDefinition<Block, BlockState> statedefinition = p_119380_.getBlock().getStateDefinition();
            List list = (List)p_119381_.getSelectors().stream().filter(p_119393_ -> p_119393_.getPredicate(statedefinition).test(p_119380_)).map(Selector::getVariant).collect(ImmutableList.toImmutableList());
            List<Object> list1 = ModelGroupKey.getColoringValues(p_119380_, p_119382_);
            return new ModelGroupKey(list, list1);
        }

        public static ModelGroupKey create(BlockState p_119384_, UnbakedModel p_119385_, Collection<Property<?>> p_119386_) {
            List<Object> list = ModelGroupKey.getColoringValues(p_119384_, p_119386_);
            return new ModelGroupKey((List<UnbakedModel>)ImmutableList.of((Object)p_119385_), list);
        }

        private static List<Object> getColoringValues(BlockState p_119388_, Collection<Property<?>> p_119389_) {
            return (List)p_119389_.stream().map(p_119388_::getValue).collect(ImmutableList.toImmutableList());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record LoadedJson(String source, JsonElement data) {
    }

    @OnlyIn(value=Dist.CLIENT)
    class ModelBakerImpl
    implements ModelBaker {
        private final Function<Material, TextureAtlasSprite> modelTextureGetter = p_250859_ -> (TextureAtlasSprite)p_249651_.apply(p_251408_, (Material)p_250859_);

        ModelBakerImpl(BiFunction<ResourceLocation, Material, TextureAtlasSprite> p_249651_, ResourceLocation p_251408_) {
        }

        @Override
        public UnbakedModel getModel(ResourceLocation p_248568_) {
            return ModelBakery.this.getModel(p_248568_);
        }

        public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
            return this.modelTextureGetter;
        }

        @Override
        public BakedModel bake(ResourceLocation p_252176_, ModelState p_249765_) {
            return this.bake(p_252176_, p_249765_, this.modelTextureGetter);
        }

        public BakedModel bake(ResourceLocation p_252176_, ModelState p_249765_, Function<Material, TextureAtlasSprite> sprites) {
            BlockModel blockmodel;
            BakedCacheKey modelbakery$bakedcachekey = new BakedCacheKey(p_252176_, p_249765_.getRotation(), p_249765_.isUvLocked());
            BakedModel bakedmodel = ModelBakery.this.bakedCache.get(modelbakery$bakedcachekey);
            if (bakedmodel != null) {
                return bakedmodel;
            }
            UnbakedModel unbakedmodel = this.getModel(p_252176_);
            if (unbakedmodel instanceof BlockModel && (blockmodel = (BlockModel)unbakedmodel).getRootModel() == GENERATION_MARKER) {
                return ITEM_MODEL_GENERATOR.generateBlockModel(sprites, blockmodel).bake(this, blockmodel, sprites, p_249765_, p_252176_, false);
            }
            BakedModel bakedmodel1 = unbakedmodel.bake((ModelBaker)this, sprites, p_249765_, p_252176_);
            ModelBakery.this.bakedCache.put(modelbakery$bakedcachekey, bakedmodel1);
            return bakedmodel1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record BakedCacheKey(ResourceLocation id, Transformation transformation, boolean isUvLocked) {
    }
}

