/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ItemListReport
implements DataProvider {
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public ItemListReport(PackOutput $$0, CompletableFuture<HolderLookup.Provider> $$1) {
        this.output = $$0;
        this.registries = $$1;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput $$0) {
        Path $$1 = this.output.getOutputFolder(PackOutput.Target.REPORTS).resolve("items.json");
        return this.registries.thenCompose($$2 -> {
            JsonObject $$3 = new JsonObject();
            RegistryOps $$4 = $$2.createSerializationContext(JsonOps.INSTANCE);
            $$2.lookupOrThrow(Registries.ITEM).listElements().forEach($$22 -> {
                JsonObject $$3 = new JsonObject();
                JsonArray $$4 = new JsonArray();
                ((Item)$$22.value()).components().forEach($$2 -> $$4.add(ItemListReport.dumpComponent($$2, $$4)));
                $$3.add("components", (JsonElement)$$4);
                $$3.add($$22.getRegisteredName(), (JsonElement)$$3);
            });
            return DataProvider.saveStable($$0, (JsonElement)$$3, $$1);
        });
    }

    private static <T> JsonElement dumpComponent(TypedDataComponent<T> $$0, DynamicOps<JsonElement> $$12) {
        ResourceLocation $$2 = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey($$0.type());
        JsonElement $$3 = (JsonElement)$$0.encodeValue($$12).getOrThrow($$1 -> new IllegalStateException("Failed to serialize component " + String.valueOf($$2) + ": " + $$1));
        JsonObject $$4 = new JsonObject();
        $$4.addProperty("type", $$2.toString());
        $$4.add("value", $$3);
        return $$4;
    }

    @Override
    public final String getName() {
        return "Item List";
    }
}

