/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput.PathProvider pathProvider;
    private final Set<ResourceKey<LootTable>> requiredTables;
    private final List<SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootTableProvider(PackOutput p_254123_, Set<ResourceKey<LootTable>> p_254481_, List<SubProviderEntry> p_253798_, CompletableFuture<HolderLookup.Provider> p_330862_) {
        this.pathProvider = p_254123_.createPathProvider(PackOutput.Target.DATA_PACK, "loot_tables");
        this.subProviders = p_253798_;
        this.requiredTables = p_254481_;
        this.registries = p_330862_;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput p_254060_) {
        return this.registries.thenCompose(p_325860_ -> this.run(p_254060_, (HolderLookup.Provider)p_325860_));
    }

    private CompletableFuture<?> run(CachedOutput p_327970_, HolderLookup.Provider p_331092_) {
        MappedRegistry<LootTable> writableregistry = new MappedRegistry<LootTable>(Registries.LOOT_TABLE, Lifecycle.experimental());
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        this.getTables().forEach(arg_0 -> LootTableProvider.lambda$run$2(p_331092_, (Map)map, writableregistry, arg_0));
        writableregistry.freeze();
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        HolderGetter.Provider holdergetter$provider = new RegistryAccess.ImmutableRegistryAccess(List.of(writableregistry)).freeze().asGetterLookup();
        ValidationContext validationcontext = new ValidationContext(problemreporter$collector, LootContextParamSets.ALL_PARAMS, holdergetter$provider);
        this.validate(writableregistry, validationcontext, problemreporter$collector);
        Multimap<String, String> multimap = problemreporter$collector.get();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> LOGGER.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])writableregistry.entrySet().stream().map(p_325852_ -> {
            ResourceKey resourcekey1 = (ResourceKey)p_325852_.getKey();
            LootTable loottable = (LootTable)p_325852_.getValue();
            Path path = this.pathProvider.json(resourcekey1.location());
            return DataProvider.saveStable(p_327970_, p_331092_, LootTable.DIRECT_CODEC, loottable, path);
        }).toArray(CompletableFuture[]::new));
    }

    private static ResourceLocation sequenceIdForLootTable(ResourceKey<LootTable> p_331928_) {
        return p_331928_.location();
    }

    @Override
    public final String getName() {
        return "Loot Tables";
    }

    public List<SubProviderEntry> getTables() {
        return this.subProviders;
    }

    protected void validate(Registry<LootTable> map, ValidationContext validationcontext, ProblemReporter report) {
        for (ResourceKey resourcekey : Sets.difference(this.requiredTables, map.registryKeySet())) {
            report.report("Missing built-in table: " + String.valueOf(resourcekey.location()));
        }
        map.holders().forEach(table -> ((LootTable)table.value()).validate(validationcontext.setParams(((LootTable)table.value()).getParamSet()).enterElement("{" + String.valueOf(table.key().location()) + "}", table.key())));
    }

    private static /* synthetic */ void lambda$run$2(HolderLookup.Provider p_331092_, Map map, WritableRegistry writableregistry, SubProviderEntry p_325858_) {
        p_325858_.provider().get().generate(p_331092_, (p_325864_, p_325865_) -> {
            ResourceLocation resourcelocation = LootTableProvider.sequenceIdForLootTable(p_325864_);
            ResourceLocation resourcelocation1 = map.put(RandomSequence.seedForKey(resourcelocation), resourcelocation);
            if (resourcelocation1 != null) {
                Util.logAndPauseIfInIde("Loot table random sequence seed collision on " + String.valueOf(resourcelocation1) + " and " + String.valueOf(p_325864_.location()));
            }
            p_325865_.setRandomSequence(resourcelocation);
            LootTable loottable = p_325865_.setParamSet(p_325858_.paramSet).build();
            writableregistry.register(p_325864_, loottable, RegistrationInfo.BUILT_IN);
        });
    }

    public record SubProviderEntry(Supplier<LootTableSubProvider> provider, LootContextParamSet paramSet) {
    }
}

