/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTicks;
import org.slf4j.Logger;

public class StructureUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int DEFAULT_Y_SEARCH_RADIUS = 10;
    public static final String DEFAULT_TEST_STRUCTURES_DIR = "gameteststructures";
    public static String testStructuresDir = "gameteststructures";

    public static Rotation getRotationForRotationSteps(int $$0) {
        switch ($$0) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + $$0);
    }

    public static int getRotationStepsForRotation(Rotation $$0) {
        switch ($$0) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + String.valueOf($$0));
    }

    public static AABB getStructureBounds(StructureBlockEntity $$0) {
        return AABB.of(StructureUtils.getStructureBoundingBox($$0));
    }

    public static BoundingBox getStructureBoundingBox(StructureBlockEntity $$0) {
        BlockPos $$1 = StructureUtils.getStructureOrigin($$0);
        BlockPos $$2 = StructureUtils.getTransformedFarCorner($$1, $$0.getStructureSize(), $$0.getRotation());
        return BoundingBox.fromCorners($$1, $$2);
    }

    public static BlockPos getStructureOrigin(StructureBlockEntity $$0) {
        return $$0.getBlockPos().offset($$0.getStructurePos());
    }

    public static void addCommandBlockAndButtonToStartTest(BlockPos $$0, BlockPos $$1, Rotation $$2, ServerLevel $$3) {
        BlockPos $$4 = StructureTemplate.transform($$0.offset($$1), Mirror.NONE, $$2, $$0);
        $$3.setBlockAndUpdate($$4, Blocks.COMMAND_BLOCK.defaultBlockState());
        CommandBlockEntity $$5 = (CommandBlockEntity)$$3.getBlockEntity($$4);
        $$5.getCommandBlock().setCommand("test runclosest");
        BlockPos $$6 = StructureTemplate.transform($$4.offset(0, 0, -1), Mirror.NONE, $$2, $$4);
        $$3.setBlockAndUpdate($$6, Blocks.STONE_BUTTON.defaultBlockState().rotate($$2));
    }

    public static void createNewEmptyStructureBlock(String $$0, BlockPos $$1, Vec3i $$2, Rotation $$3, ServerLevel $$4) {
        BoundingBox $$5 = StructureUtils.getStructureBoundingBox($$1.above(), $$2, $$3);
        StructureUtils.clearSpaceForStructure($$5, $$4);
        $$4.setBlockAndUpdate($$1, Blocks.STRUCTURE_BLOCK.defaultBlockState());
        StructureBlockEntity $$6 = (StructureBlockEntity)$$4.getBlockEntity($$1);
        $$6.setIgnoreEntities(false);
        $$6.setStructureName(new ResourceLocation($$0));
        $$6.setStructureSize($$2);
        $$6.setMode(StructureMode.SAVE);
        $$6.setShowBoundingBox(true);
    }

    /*
     * WARNING - void declaration
     */
    public static StructureBlockEntity prepareTestStructure(GameTestInfo $$0, BlockPos $$1, Rotation $$2, ServerLevel $$3) {
        void $$10;
        Vec3i $$4 = $$3.getStructureManager().get(new ResourceLocation($$0.getStructureName())).orElseThrow(() -> new IllegalStateException("Missing test structure: " + $$0.getStructureName())).getSize();
        BoundingBox $$5 = StructureUtils.getStructureBoundingBox($$1, $$4, $$2);
        if ($$2 == Rotation.NONE) {
            BlockPos $$6 = $$1;
        } else if ($$2 == Rotation.CLOCKWISE_90) {
            BlockPos $$7 = $$1.offset($$4.getZ() - 1, 0, 0);
        } else if ($$2 == Rotation.CLOCKWISE_180) {
            BlockPos $$8 = $$1.offset($$4.getX() - 1, 0, $$4.getZ() - 1);
        } else if ($$2 == Rotation.COUNTERCLOCKWISE_90) {
            BlockPos $$9 = $$1.offset(0, 0, $$4.getX() - 1);
        } else {
            throw new IllegalArgumentException("Invalid rotation: " + String.valueOf($$2));
        }
        StructureUtils.forceLoadChunks($$5, $$3);
        StructureUtils.clearSpaceForStructure($$5, $$3);
        return StructureUtils.createStructureBlock($$0, $$10.below(), $$2, $$3);
    }

    public static void encaseStructure(AABB $$0, ServerLevel $$1, boolean $$2) {
        BlockPos $$3 = BlockPos.containing($$0.minX, $$0.minY, $$0.minZ).offset(-1, 0, -1);
        BlockPos $$42 = BlockPos.containing($$0.maxX, $$0.maxY, $$0.maxZ);
        BlockPos.betweenClosedStream($$3, $$42).forEach($$4 -> {
            boolean $$6;
            boolean $$5 = $$4.getX() == $$3.getX() || $$4.getX() == $$42.getX() || $$4.getZ() == $$3.getZ() || $$4.getZ() == $$42.getZ();
            boolean bl = $$6 = $$4.getY() == $$42.getY();
            if ($$5 || $$6 && $$2) {
                $$1.setBlockAndUpdate((BlockPos)$$4, Blocks.BARRIER.defaultBlockState());
            }
        });
    }

    public static void removeBarriers(AABB $$0, ServerLevel $$1) {
        BlockPos $$2 = BlockPos.containing($$0.minX, $$0.minY, $$0.minZ).offset(-1, 0, -1);
        BlockPos $$32 = BlockPos.containing($$0.maxX, $$0.maxY, $$0.maxZ);
        BlockPos.betweenClosedStream($$2, $$32).forEach($$3 -> {
            boolean $$5;
            boolean $$4 = $$3.getX() == $$2.getX() || $$3.getX() == $$32.getX() || $$3.getZ() == $$2.getZ() || $$3.getZ() == $$32.getZ();
            boolean bl = $$5 = $$3.getY() == $$32.getY();
            if ($$1.getBlockState((BlockPos)$$3).is(Blocks.BARRIER) && ($$4 || $$5)) {
                $$1.setBlockAndUpdate((BlockPos)$$3, Blocks.AIR.defaultBlockState());
            }
        });
    }

    private static void forceLoadChunks(BoundingBox $$0, ServerLevel $$12) {
        $$0.intersectingChunks().forEach($$1 -> $$12.setChunkForced($$1.x, $$1.z, true));
    }

    public static void clearSpaceForStructure(BoundingBox $$02, ServerLevel $$1) {
        int $$22 = $$02.minY() - 1;
        BoundingBox $$3 = new BoundingBox($$02.minX() - 2, $$02.minY() - 3, $$02.minZ() - 3, $$02.maxX() + 3, $$02.maxY() + 20, $$02.maxZ() + 3);
        BlockPos.betweenClosedStream($$3).forEach($$2 -> StructureUtils.clearBlock($$22, $$2, $$1));
        ((LevelTicks)$$1.getBlockTicks()).clearArea($$3);
        $$1.clearBlockEvents($$3);
        AABB $$4 = new AABB($$3.minX(), $$3.minY(), $$3.minZ(), $$3.maxX(), $$3.maxY(), $$3.maxZ());
        List $$5 = $$1.getEntitiesOfClass(Entity.class, $$4, $$0 -> !($$0 instanceof Player));
        $$5.forEach(Entity::discard);
    }

    public static BlockPos getTransformedFarCorner(BlockPos $$0, Vec3i $$1, Rotation $$2) {
        BlockPos $$3 = $$0.offset($$1).offset(-1, -1, -1);
        return StructureTemplate.transform($$3, Mirror.NONE, $$2, $$0);
    }

    public static BoundingBox getStructureBoundingBox(BlockPos $$0, Vec3i $$1, Rotation $$2) {
        BlockPos $$3 = StructureUtils.getTransformedFarCorner($$0, $$1, $$2);
        BoundingBox $$4 = BoundingBox.fromCorners($$0, $$3);
        int $$5 = Math.min($$4.minX(), $$4.maxX());
        int $$6 = Math.min($$4.minZ(), $$4.maxZ());
        return $$4.move($$0.getX() - $$5, 0, $$0.getZ() - $$6);
    }

    public static Optional<BlockPos> findStructureBlockContainingPos(BlockPos $$0, int $$1, ServerLevel $$22) {
        return StructureUtils.findStructureBlocks($$0, $$1, $$22).filter($$2 -> StructureUtils.doesStructureContain($$2, $$0, $$22)).findFirst();
    }

    public static Optional<BlockPos> findNearestStructureBlock(BlockPos $$0, int $$12, ServerLevel $$2) {
        Comparator<BlockPos> $$3 = Comparator.comparingInt($$1 -> $$1.distManhattan($$0));
        return StructureUtils.findStructureBlocks($$0, $$12, $$2).min($$3);
    }

    public static Stream<BlockPos> findStructureByTestFunction(BlockPos $$0, int $$12, ServerLevel $$2, String $$3) {
        return StructureUtils.findStructureBlocks($$0, $$12, $$2).map($$1 -> (StructureBlockEntity)$$2.getBlockEntity((BlockPos)$$1)).filter(Objects::nonNull).filter($$1 -> Objects.equals($$1.getStructureName(), $$3)).map(BlockEntity::getBlockPos).map(BlockPos::immutable);
    }

    public static Stream<BlockPos> findStructureBlocks(BlockPos $$0, int $$12, ServerLevel $$2) {
        BoundingBox $$3 = StructureUtils.getBoundingBoxAtGround($$0, $$12, $$2);
        return BlockPos.betweenClosedStream($$3).filter($$1 -> $$2.getBlockState((BlockPos)$$1).is(Blocks.STRUCTURE_BLOCK)).map(BlockPos::immutable);
    }

    private static StructureBlockEntity createStructureBlock(GameTestInfo $$0, BlockPos $$1, Rotation $$2, ServerLevel $$3) {
        $$3.setBlockAndUpdate($$1, Blocks.STRUCTURE_BLOCK.defaultBlockState());
        StructureBlockEntity $$4 = (StructureBlockEntity)$$3.getBlockEntity($$1);
        $$4.setMode(StructureMode.LOAD);
        $$4.setRotation($$2);
        $$4.setIgnoreEntities(false);
        $$4.setStructureName(new ResourceLocation($$0.getStructureName()));
        $$4.setMetaData($$0.getTestName());
        if (!$$4.loadStructureInfo($$3)) {
            throw new RuntimeException("Failed to load structure info for test: " + $$0.getTestName() + ". Structure name: " + $$0.getStructureName());
        }
        return $$4;
    }

    private static BoundingBox getBoundingBoxAtGround(BlockPos $$0, int $$1, ServerLevel $$2) {
        BlockPos $$3 = BlockPos.containing($$0.getX(), $$2.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, $$0).getY(), $$0.getZ());
        return new BoundingBox($$3).inflatedBy($$1, 10, $$1);
    }

    public static Stream<BlockPos> lookedAtStructureBlockPos(BlockPos $$0, Entity $$12, ServerLevel $$22) {
        int $$3 = 200;
        Vec3 $$4 = $$12.getEyePosition();
        Vec3 $$5 = $$4.add($$12.getLookAngle().scale(200.0));
        return StructureUtils.findStructureBlocks($$0, 200, $$22).map($$1 -> $$22.getBlockEntity((BlockPos)$$1, BlockEntityType.STRUCTURE_BLOCK)).flatMap(Optional::stream).filter($$2 -> StructureUtils.getStructureBounds($$2).clip($$4, $$5).isPresent()).map(BlockEntity::getBlockPos).sorted(Comparator.comparing($$0::distSqr)).limit(1L);
    }

    private static void clearBlock(int $$0, BlockPos $$1, ServerLevel $$2) {
        BlockState $$4;
        if ($$1.getY() < $$0) {
            BlockState $$3 = Blocks.STONE.defaultBlockState();
        } else {
            $$4 = Blocks.AIR.defaultBlockState();
        }
        BlockInput $$5 = new BlockInput($$4, Collections.emptySet(), null);
        $$5.place($$2, $$1, 2);
        $$2.blockUpdated($$1, $$4.getBlock());
    }

    private static boolean doesStructureContain(BlockPos $$0, BlockPos $$1, ServerLevel $$2) {
        StructureBlockEntity $$3 = (StructureBlockEntity)$$2.getBlockEntity($$0);
        return StructureUtils.getStructureBoundingBox($$3).isInside($$1);
    }
}

