/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private Map<ResourceLocation, AdvancementHolder> advancements = Map.of();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.Provider registries;
    private final ICondition.IContext context;

    @Deprecated
    public ServerAdvancementManager(HolderLookup.Provider p_336198_) {
        this(p_336198_, ICondition.IContext.EMPTY);
    }

    public ServerAdvancementManager(HolderLookup.Provider p_336198_, ICondition.IContext context) {
        super(GSON, "advancements");
        this.registries = p_336198_;
        this.context = context;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> p_136034_, ResourceManager p_136035_, ProfilerFiller p_136036_) {
        RegistryOps registryops = this.registries.createSerializationContext(JsonOps.INSTANCE);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        p_136034_.forEach((p_326203_, p_326204_) -> {
            try {
                JsonObject json = ForgeHooks.readConditionalAdvancement((RegistryOps)registryops, (JsonObject)((JsonObject)p_326204_));
                if (json == null) {
                    LOGGER.debug("Skipping loading advancement {} as its conditions were not met", p_326204_);
                    return;
                }
                Advancement advancement = (Advancement)Advancement.CODEC.parse((DynamicOps)registryops, (Object)json).getOrThrow(JsonParseException::new);
                this.validate((ResourceLocation)p_326203_, advancement);
                builder.put(p_326203_, (Object)new AdvancementHolder((ResourceLocation)p_326203_, advancement));
            }
            catch (Exception exception) {
                LOGGER.error("Parsing error loading custom advancement {}: {}", p_326203_, (Object)exception.getMessage());
            }
        });
        this.advancements = builder.buildOrThrow();
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.addAll(this.advancements.values());
        for (AdvancementNode advancementnode : advancementtree.roots()) {
            if (!advancementnode.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(advancementnode);
        }
        this.tree = advancementtree;
    }

    private void validate(ResourceLocation p_309906_, Advancement p_310937_) {
        ProblemReporter.Collector problemreporter$collector = new ProblemReporter.Collector();
        p_310937_.validate(problemreporter$collector, this.registries.asGetterLookup());
        Multimap<String, String> multimap = problemreporter$collector.get();
        if (!multimap.isEmpty()) {
            String s = multimap.asMap().entrySet().stream().map(p_308593_ -> "  at " + (String)p_308593_.getKey() + ": " + String.join((CharSequence)"; ", (Iterable)p_308593_.getValue())).collect(Collectors.joining("\n"));
            LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)p_309906_, (Object)s);
        }
    }

    @Nullable
    public AdvancementHolder get(ResourceLocation p_299615_) {
        return this.advancements.get(p_299615_);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

