/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerPlayer;

public class CustomBossEvents {
    private final Map<ResourceLocation, CustomBossEvent> events = Maps.newHashMap();

    @Nullable
    public CustomBossEvent get(ResourceLocation $$0) {
        return this.events.get($$0);
    }

    public CustomBossEvent create(ResourceLocation $$0, Component $$1) {
        CustomBossEvent $$2 = new CustomBossEvent($$0, $$1);
        this.events.put($$0, $$2);
        return $$2;
    }

    public void remove(CustomBossEvent $$0) {
        this.events.remove($$0.getTextId());
    }

    public Collection<ResourceLocation> getIds() {
        return this.events.keySet();
    }

    public Collection<CustomBossEvent> getEvents() {
        return this.events.values();
    }

    public CompoundTag save(HolderLookup.Provider $$0) {
        CompoundTag $$1 = new CompoundTag();
        for (CustomBossEvent $$2 : this.events.values()) {
            $$1.put($$2.getTextId().toString(), $$2.save($$0));
        }
        return $$1;
    }

    public void load(CompoundTag $$0, HolderLookup.Provider $$1) {
        for (String $$2 : $$0.getAllKeys()) {
            ResourceLocation $$3 = new ResourceLocation($$2);
            this.events.put($$3, CustomBossEvent.load($$0.getCompound($$2), $$3, $$1));
        }
    }

    public void onPlayerConnect(ServerPlayer $$0) {
        for (CustomBossEvent $$1 : this.events.values()) {
            $$1.onPlayerConnect($$0);
        }
    }

    public void onPlayerDisconnect(ServerPlayer $$0) {
        for (CustomBossEvent $$1 : this.events.values()) {
            $$1.onPlayerDisconnect($$0);
        }
    }
}

