/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.StringRepresentable;

public enum EquipmentSlot implements StringRepresentable
{
    MAINHAND(Type.HAND, 0, 0, "mainhand"),
    OFFHAND(Type.HAND, 1, 5, "offhand"),
    FEET(Type.ARMOR, 0, 1, "feet"),
    LEGS(Type.ARMOR, 1, 2, "legs"),
    CHEST(Type.ARMOR, 2, 3, "chest"),
    HEAD(Type.ARMOR, 3, 4, "head"),
    BODY(Type.BODY, 0, 6, "body");

    public static final StringRepresentable.EnumCodec<EquipmentSlot> CODEC;
    private final Type type;
    private final int index;
    private final int filterFlag;
    private final String name;

    private EquipmentSlot(Type $$0, int $$1, int $$2, String $$3) {
        this.type = $$0;
        this.index = $$1;
        this.filterFlag = $$2;
        this.name = $$3;
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getIndex(int $$0) {
        return $$0 + this.index;
    }

    public int getFilterFlag() {
        return this.filterFlag;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArmor() {
        return this.type == Type.ARMOR;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public static EquipmentSlot byName(String $$0) {
        EquipmentSlot $$1 = CODEC.byName($$0);
        if ($$1 != null) {
            return $$1;
        }
        throw new IllegalArgumentException("Invalid slot '" + $$0 + "'");
    }

    public static EquipmentSlot byTypeAndIndex(Type $$0, int $$1) {
        for (EquipmentSlot $$2 : EquipmentSlot.values()) {
            if ($$2.getType() != $$0 || $$2.getIndex() != $$1) continue;
            return $$2;
        }
        throw new IllegalArgumentException("Invalid slot '" + String.valueOf((Object)$$0) + "': " + $$1);
    }

    static {
        CODEC = StringRepresentable.fromEnum(EquipmentSlot::values);
    }

    public static enum Type {
        HAND,
        ARMOR,
        BODY;

    }
}

