/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import org.slf4j.Logger;

public record AttributeModifier(UUID id, String name, double amount, Operation operation) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<AttributeModifier> MAP_CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)UUIDUtil.CODEC.fieldOf("uuid").forGetter(AttributeModifier::id), (App)Codec.STRING.fieldOf("name").forGetter($$0 -> $$0.name), (App)Codec.DOUBLE.fieldOf("amount").forGetter(AttributeModifier::amount), (App)Operation.CODEC.fieldOf("operation").forGetter(AttributeModifier::operation)).apply((Applicative)$$02, AttributeModifier::new));
    public static final Codec<AttributeModifier> CODEC = MAP_CODEC.codec();
    public static final StreamCodec<ByteBuf, AttributeModifier> STREAM_CODEC = StreamCodec.composite(UUIDUtil.STREAM_CODEC, AttributeModifier::id, ByteBufCodecs.STRING_UTF8, $$0 -> $$0.name, ByteBufCodecs.DOUBLE, AttributeModifier::amount, Operation.STREAM_CODEC, AttributeModifier::operation, AttributeModifier::new);

    public AttributeModifier(String $$0, double $$1, Operation $$2) {
        this(Mth.createInsecureUUID(RandomSource.createNewThreadLocalInstance()), $$0, $$1, $$2);
    }

    public CompoundTag save() {
        CompoundTag $$0 = new CompoundTag();
        $$0.putString("Name", this.name);
        $$0.putDouble("Amount", this.amount);
        $$0.putInt("Operation", this.operation.id());
        $$0.putUUID("UUID", this.id);
        return $$0;
    }

    @Nullable
    public static AttributeModifier load(CompoundTag $$0) {
        try {
            UUID $$1 = $$0.getUUID("UUID");
            Operation $$2 = Operation.BY_ID.apply($$0.getInt("Operation"));
            return new AttributeModifier($$1, $$0.getString("Name"), $$0.getDouble("Amount"), $$2);
        }
        catch (Exception $$3) {
            LOGGER.warn("Unable to create attribute: {}", (Object)$$3.getMessage());
            return null;
        }
    }

    public static enum Operation implements StringRepresentable
    {
        ADD_VALUE("add_value", 0),
        ADD_MULTIPLIED_BASE("add_multiplied_base", 1),
        ADD_MULTIPLIED_TOTAL("add_multiplied_total", 2);

        public static final IntFunction<Operation> BY_ID;
        public static final StreamCodec<ByteBuf, Operation> STREAM_CODEC;
        public static final Codec<Operation> CODEC;
        private final String name;
        private final int id;

        private Operation(String $$0, int $$1) {
            this.name = $$0;
            this.id = $$1;
        }

        public int id() {
            return this.id;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(Operation::id, Operation.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Operation::id);
            CODEC = StringRepresentable.fromEnum(Operation::values);
        }
    }
}

