/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.windcharge;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public abstract class AbstractWindCharge
extends AbstractHurtingProjectile
implements ItemSupplier {
    public static final WindChargeDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new WindChargeDamageCalculator();

    public AbstractWindCharge(EntityType<? extends AbstractWindCharge> $$0, Level $$1) {
        super((EntityType<? extends AbstractHurtingProjectile>)$$0, $$1);
    }

    public AbstractWindCharge(EntityType<? extends AbstractWindCharge> $$0, Level $$1, Entity $$2, double $$3, double $$4, double $$5) {
        super($$0, $$3, $$4, $$5, $$1);
        this.setOwner($$2);
    }

    AbstractWindCharge(EntityType<? extends AbstractWindCharge> $$0, double $$1, double $$2, double $$3, double $$4, double $$5, double $$6, Level $$7) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    @Override
    protected AABB makeBoundingBox() {
        float $$0 = this.getType().getDimensions().width() / 2.0f;
        float $$1 = this.getType().getDimensions().height();
        float $$2 = 0.15f;
        return new AABB(this.position().x - (double)$$0, this.position().y - (double)0.15f, this.position().z - (double)$$0, this.position().x + (double)$$0, this.position().y - (double)0.15f + (double)$$1, this.position().z + (double)$$0);
    }

    @Override
    public boolean canCollideWith(Entity $$0) {
        if ($$0 instanceof AbstractWindCharge) {
            return false;
        }
        return super.canCollideWith($$0);
    }

    @Override
    protected boolean canHitEntity(Entity $$0) {
        if ($$0 instanceof AbstractWindCharge) {
            return false;
        }
        if ($$0.getType() == EntityType.END_CRYSTAL) {
            return false;
        }
        return super.canHitEntity($$0);
    }

    @Override
    protected void onHitEntity(EntityHitResult $$0) {
        LivingEntity $$1;
        super.onHitEntity($$0);
        if (this.level().isClientSide) {
            return;
        }
        Entity entity = this.getOwner();
        LivingEntity $$2 = entity instanceof LivingEntity ? ($$1 = (LivingEntity)entity) : null;
        Entity $$3 = $$0.getEntity().getPassengerClosestTo($$0.getLocation()).orElse($$0.getEntity());
        if ($$2 != null) {
            $$2.setLastHurtMob($$3);
        }
        $$3.hurt(this.damageSources().windCharge(this, $$2), 1.0f);
        this.explode();
    }

    @Override
    public void push(double $$0, double $$1, double $$2) {
    }

    protected abstract void explode();

    @Override
    protected void onHitBlock(BlockHitResult $$0) {
        super.onHitBlock($$0);
        if (!this.level().isClientSide) {
            this.explode();
            this.discard();
        }
    }

    @Override
    protected void onHit(HitResult $$0) {
        super.onHit($$0);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    @Override
    protected float getLiquidInertia() {
        return this.getInertia();
    }

    @Override
    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide && this.getBlockY() > this.level().getMaxBuildHeight() + 30) {
            this.explode();
            this.discard();
        } else {
            super.tick();
        }
    }

    public static class WindChargeDamageCalculator
    extends ExplosionDamageCalculator {
        @Override
        public boolean shouldDamageEntity(Explosion $$0, Entity $$1) {
            return false;
        }

        @Override
        public Optional<Float> getBlockExplosionResistance(Explosion $$0, BlockGetter $$1, BlockPos $$2, BlockState $$3, FluidState $$4) {
            if ($$3.is(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS)) {
                return Optional.of(Float.valueOf(3600000.0f));
            }
            return Optional.empty();
        }
    }
}

