/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.Vec3;

public class WindChargeItem
extends Item
implements ProjectileItem {
    private static final int COOLDOWN = 10;

    public WindChargeItem(Item.Properties $$0) {
        super($$0);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level $$0, Player $$1, InteractionHand $$2) {
        if (!$$0.isClientSide()) {
            Vec3 $$3 = $$1.getEyePosition().add($$1.getForward().scale(0.8f));
            if (!$$0.getBlockState(BlockPos.containing($$3)).canBeReplaced()) {
                $$3 = $$1.getEyePosition().add($$1.getForward().scale(0.05f));
            }
            WindCharge $$4 = new WindCharge($$1, $$0, $$3.x(), $$3.y(), $$3.z());
            $$4.shootFromRotation($$1, $$1.getXRot(), $$1.getYRot(), 0.0f, 1.5f, 1.0f);
            $$0.addFreshEntity($$4);
        }
        $$0.playSound(null, $$1.getX(), $$1.getY(), $$1.getZ(), SoundEvents.WIND_CHARGE_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / ($$0.getRandom().nextFloat() * 0.4f + 0.8f));
        ItemStack $$5 = $$1.getItemInHand($$2);
        $$1.getCooldowns().addCooldown(this, 10);
        $$1.awardStat(Stats.ITEM_USED.get(this));
        $$5.consume(1, $$1);
        return InteractionResultHolder.sidedSuccess($$5, $$0.isClientSide());
    }

    @Override
    public Projectile asProjectile(Level $$0, Position $$1, ItemStack $$2, Direction $$3) {
        RandomSource $$4 = $$0.getRandom();
        double $$5 = $$4.triangle($$3.getStepX(), 0.11485000000000001);
        double $$6 = $$4.triangle($$3.getStepY(), 0.11485000000000001);
        double $$7 = $$4.triangle($$3.getStepZ(), 0.11485000000000001);
        return new WindCharge($$0, $$1.x(), $$1.y(), $$1.z(), $$5, $$6, $$7);
    }

    @Override
    public void shoot(Projectile $$0, double $$1, double $$2, double $$3, float $$4, float $$5) {
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction(($$0, $$1) -> DispenserBlock.getDispensePosition($$0, 1.0, Vec3.ZERO)).uncertainty(6.6666665f).power(1.0f).build();
    }
}

