/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

public record ShapedRecipePattern(int width, int height, NonNullList<Ingredient> ingredients, Optional<Data> data) {
    private static final int MAX_SIZE = 3;
    public static final MapCodec<ShapedRecipePattern> MAP_CODEC = Data.MAP_CODEC.flatXmap(ShapedRecipePattern::unpack, p_310854_ -> p_310854_.data().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipePattern> STREAM_CODEC = StreamCodec.ofMember(ShapedRecipePattern::toNetwork, ShapedRecipePattern::fromNetwork);

    public static ShapedRecipePattern of(Map<Character, Ingredient> p_310983_, String ... p_310430_) {
        return ShapedRecipePattern.of(p_310983_, List.of(p_310430_));
    }

    public static ShapedRecipePattern of(Map<Character, Ingredient> p_313226_, List<String> p_310089_) {
        Data shapedrecipepattern$data = new Data(p_313226_, p_310089_);
        return (ShapedRecipePattern)ShapedRecipePattern.unpack(shapedrecipepattern$data).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> unpack(Data p_312333_) {
        String[] astring = ShapedRecipePattern.shrink(p_312333_.pattern);
        int i = astring[0].length();
        int j = astring.length;
        NonNullList<Ingredient> nonnulllist = NonNullList.withSize(i * j, Ingredient.EMPTY);
        CharArraySet charset = new CharArraySet(p_312333_.key.keySet());
        for (int k = 0; k < astring.length; ++k) {
            String s = astring[k];
            for (int l = 0; l < s.length(); ++l) {
                Ingredient ingredient;
                char c0 = s.charAt(l);
                Ingredient ingredient2 = ingredient = c0 == ' ' ? Ingredient.EMPTY : p_312333_.key.get(Character.valueOf(c0));
                if (ingredient == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + c0 + "' but it's not defined in the key");
                }
                charset.remove(c0);
                nonnulllist.set(l + i * k, ingredient);
            }
        }
        return !charset.isEmpty() ? DataResult.error(() -> ShapedRecipePattern.lambda$unpack$4((CharSet)charset)) : DataResult.success((Object)new ShapedRecipePattern(i, j, nonnulllist, Optional.of(p_312333_)));
    }

    @VisibleForTesting
    static String[] shrink(List<String> p_311492_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_311492_.size(); ++i1) {
            String s = p_311492_.get(i1);
            i = Math.min(i, ShapedRecipePattern.firstNonSpace(s));
            int j1 = ShapedRecipePattern.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_311492_.size() == l) {
            return new String[0];
        }
        String[] astring = new String[p_311492_.size() - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_311492_.get(k1 + k).substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String p_309836_) {
        int i;
        for (i = 0; i < p_309836_.length() && p_309836_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String p_312853_) {
        int i;
        for (i = p_312853_.length() - 1; i >= 0 && p_312853_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    public boolean matches(CraftingContainer p_310690_) {
        for (int i = 0; i <= p_310690_.getWidth() - this.width; ++i) {
            for (int j = 0; j <= p_310690_.getHeight() - this.height; ++j) {
                if (this.matches(p_310690_, i, j, true)) {
                    return true;
                }
                if (!this.matches(p_310690_, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer p_313091_, int p_311269_, int p_310676_, boolean p_313153_) {
        for (int i = 0; i < p_313091_.getWidth(); ++i) {
            for (int j = 0; j < p_313091_.getHeight(); ++j) {
                int k = i - p_311269_;
                int l = j - p_310676_;
                Ingredient ingredient = Ingredient.EMPTY;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = p_313153_ ? this.ingredients.get(this.width - k - 1 + l * this.width) : this.ingredients.get(k + l * this.width);
                }
                if (ingredient.test(p_313091_.getItem(i + j * p_313091_.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    private void toNetwork(RegistryFriendlyByteBuf p_335258_) {
        p_335258_.writeVarInt(this.width);
        p_335258_.writeVarInt(this.height);
        for (Ingredient ingredient : this.ingredients) {
            Ingredient.CONTENTS_STREAM_CODEC.encode(p_335258_, ingredient);
        }
    }

    private static ShapedRecipePattern fromNetwork(RegistryFriendlyByteBuf p_332293_) {
        int i = p_332293_.readVarInt();
        int j = p_332293_.readVarInt();
        NonNullList<Ingredient> nonnulllist = NonNullList.withSize(i * j, Ingredient.EMPTY);
        nonnulllist.replaceAll(p_327210_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(p_332293_));
        return new ShapedRecipePattern(i, j, nonnulllist, Optional.empty());
    }

    private static /* synthetic */ String lambda$unpack$4(CharSet charset) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf(charset);
    }

    public record Data(Map<Character, Ingredient> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap(p_311191_ -> {
            if (p_311191_.size() > ShapedRecipe.MAX_HEIGHT) {
                return DataResult.error(() -> "Invalid pattern: too many rows, " + ShapedRecipe.MAX_HEIGHT + " is maximum");
            }
            if (p_311191_.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int i = ((String)p_311191_.get(0)).length();
            for (String s : p_311191_) {
                if (s.length() > ShapedRecipe.MAX_HEIGHT) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, " + ShapedRecipe.MAX_HEIGHT + " is maximum");
                }
                if (i == s.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)p_311191_);
        }, Function.identity());
        private static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap(p_313217_ -> {
            if (p_313217_.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + p_313217_ + "' is an invalid symbol (must be 1 character only).");
            }
            return " ".equals(p_313217_) ? DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.") : DataResult.success((Object)Character.valueOf(p_313217_.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> MAP_CODEC = RecordCodecBuilder.mapCodec(p_310577_ -> p_310577_.group((App)ExtraCodecs.strictUnboundedMap(SYMBOL_CODEC, Ingredient.CODEC_NONEMPTY).fieldOf("key").forGetter(p_311797_ -> p_311797_.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter(p_309770_ -> p_309770_.pattern)).apply((Applicative)p_310577_, Data::new));
    }
}

