/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShulkerBoxBlock
extends BaseEntityBlock {
    public static final MapCodec<ShulkerBoxBlock> CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter($$0 -> Optional.ofNullable($$0.color)), ShulkerBoxBlock.propertiesCodec()).apply((Applicative)$$02, ($$0, $$1) -> new ShulkerBoxBlock($$0.orElse(null), (BlockBehaviour.Properties)$$1)));
    private static final Component UNKNOWN_CONTENTS = Component.translatable("container.shulkerBox.unknownContents");
    private static final float OPEN_AABB_SIZE = 1.0f;
    private static final VoxelShape UP_OPEN_AABB = Block.box(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape DOWN_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape WES_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape EAST_OPEN_AABB = Block.box(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape NORTH_OPEN_AABB = Block.box(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape SOUTH_OPEN_AABB = Block.box(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<Direction, VoxelShape> OPEN_SHAPE_BY_DIRECTION = Util.make(Maps.newEnumMap(Direction.class), $$0 -> {
        $$0.put(Direction.NORTH, NORTH_OPEN_AABB);
        $$0.put(Direction.EAST, EAST_OPEN_AABB);
        $$0.put(Direction.SOUTH, SOUTH_OPEN_AABB);
        $$0.put(Direction.WEST, WES_OPEN_AABB);
        $$0.put(Direction.UP, UP_OPEN_AABB);
        $$0.put(Direction.DOWN, DOWN_OPEN_AABB);
    });
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");
    @Nullable
    private final DyeColor color;

    public MapCodec<ShulkerBoxBlock> codec() {
        return CODEC;
    }

    public ShulkerBoxBlock(@Nullable DyeColor $$0, BlockBehaviour.Properties $$1) {
        super($$1);
        this.color = $$0;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.UP));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos $$0, BlockState $$1) {
        return new ShulkerBoxBlockEntity(this.color, $$0, $$1);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level $$0, BlockState $$1, BlockEntityType<T> $$2) {
        return ShulkerBoxBlock.createTickerHelper($$2, BlockEntityType.SHULKER_BOX, ShulkerBoxBlockEntity::tick);
    }

    @Override
    protected RenderShape getRenderShape(BlockState $$0) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState $$0, Level $$1, BlockPos $$2, Player $$3, BlockHitResult $$4) {
        if ($$1.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if ($$3.isSpectator()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity $$5 = $$1.getBlockEntity($$2);
        if ($$5 instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity $$6 = (ShulkerBoxBlockEntity)$$5;
            if (ShulkerBoxBlock.canOpen($$0, $$1, $$2, $$6)) {
                $$3.openMenu($$6);
                $$3.awardStat(Stats.OPEN_SHULKER_BOX);
                PiglinAi.angerNearbyPiglins($$3, true);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private static boolean canOpen(BlockState $$0, Level $$1, BlockPos $$2, ShulkerBoxBlockEntity $$3) {
        if ($$3.getAnimationStatus() != ShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB $$4 = Shulker.getProgressDeltaAabb(1.0f, $$0.getValue(FACING), 0.0f, 0.5f).move($$2).deflate(1.0E-6);
        return $$1.noCollision($$4);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext $$0) {
        return (BlockState)this.defaultBlockState().setValue(FACING, $$0.getClickedFace());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.add(FACING);
    }

    @Override
    public BlockState playerWillDestroy(Level $$0, BlockPos $$1, BlockState $$2, Player $$3) {
        BlockEntity $$4 = $$0.getBlockEntity($$1);
        if ($$4 instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity $$5 = (ShulkerBoxBlockEntity)$$4;
            if (!$$0.isClientSide && $$3.isCreative() && !$$5.isEmpty()) {
                ItemStack $$6 = ShulkerBoxBlock.getColoredItemStack(this.getColor());
                $$6.applyComponents($$4.collectComponents());
                ItemEntity $$7 = new ItemEntity($$0, (double)$$1.getX() + 0.5, (double)$$1.getY() + 0.5, (double)$$1.getZ() + 0.5, $$6);
                $$7.setDefaultPickUpDelay();
                $$0.addFreshEntity($$7);
            } else {
                $$5.unpackLootTable($$3);
            }
        }
        return super.playerWillDestroy($$0, $$1, $$2, $$3);
    }

    @Override
    protected List<ItemStack> getDrops(BlockState $$0, LootParams.Builder $$12) {
        BlockEntity $$2 = $$12.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if ($$2 instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity $$3 = (ShulkerBoxBlockEntity)$$2;
            $$12 = $$12.withDynamicDrop(CONTENTS, $$1 -> {
                for (int $$2 = 0; $$2 < $$3.getContainerSize(); ++$$2) {
                    $$1.accept($$3.getItem($$2));
                }
            });
        }
        return super.getDrops($$0, $$12);
    }

    @Override
    protected void onRemove(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        if ($$0.is($$3.getBlock())) {
            return;
        }
        BlockEntity $$5 = $$1.getBlockEntity($$2);
        if ($$5 instanceof ShulkerBoxBlockEntity) {
            $$1.updateNeighbourForOutputSignal($$2, $$0.getBlock());
        }
        super.onRemove($$0, $$1, $$2, $$3, $$4);
    }

    @Override
    public void appendHoverText(ItemStack $$0, Item.TooltipContext $$1, List<Component> $$2, TooltipFlag $$3) {
        super.appendHoverText($$0, $$1, $$2, $$3);
        if ($$0.has(DataComponents.CONTAINER_LOOT)) {
            $$2.add(UNKNOWN_CONTENTS);
        }
        int $$4 = 0;
        int $$5 = 0;
        for (ItemStack $$6 : $$0.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).nonEmptyItems()) {
            ++$$5;
            if ($$4 > 4) continue;
            ++$$4;
            $$2.add(Component.translatable("container.shulkerBox.itemCount", $$6.getHoverName(), $$6.getCount()));
        }
        if ($$5 - $$4 > 0) {
            $$2.add(Component.translatable("container.shulkerBox.more", $$5 - $$4).withStyle(ChatFormatting.ITALIC));
        }
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState $$0, BlockGetter $$1, BlockPos $$2) {
        ShulkerBoxBlockEntity $$4;
        BlockEntity $$3 = $$1.getBlockEntity($$2);
        if ($$3 instanceof ShulkerBoxBlockEntity && !($$4 = (ShulkerBoxBlockEntity)$$3).isClosed()) {
            return OPEN_SHAPE_BY_DIRECTION.get($$0.getValue(FACING).getOpposite());
        }
        return Shapes.block();
    }

    @Override
    protected VoxelShape getShape(BlockState $$0, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        BlockEntity $$4 = $$1.getBlockEntity($$2);
        if ($$4 instanceof ShulkerBoxBlockEntity) {
            return Shapes.create(((ShulkerBoxBlockEntity)$$4).getBoundingBox($$0));
        }
        return Shapes.block();
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState $$0, BlockGetter $$1, BlockPos $$2) {
        return false;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState $$0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState $$0, Level $$1, BlockPos $$2) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity($$1.getBlockEntity($$2));
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader $$0, BlockPos $$1, BlockState $$22) {
        ItemStack $$3 = super.getCloneItemStack($$0, $$1, $$22);
        $$0.getBlockEntity($$1, BlockEntityType.SHULKER_BOX).ifPresent($$2 -> $$2.saveToItem($$3, $$0.registryAccess()));
        return $$3;
    }

    @Nullable
    public static DyeColor getColorFromItem(Item $$0) {
        return ShulkerBoxBlock.getColorFromBlock(Block.byItem($$0));
    }

    @Nullable
    public static DyeColor getColorFromBlock(Block $$0) {
        if ($$0 instanceof ShulkerBoxBlock) {
            return ((ShulkerBoxBlock)$$0).getColor();
        }
        return null;
    }

    public static Block getBlockByColor(@Nullable DyeColor $$0) {
        if ($$0 == null) {
            return Blocks.SHULKER_BOX;
        }
        return switch ($$0) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_SHULKER_BOX;
            case DyeColor.ORANGE -> Blocks.ORANGE_SHULKER_BOX;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_SHULKER_BOX;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_SHULKER_BOX;
            case DyeColor.YELLOW -> Blocks.YELLOW_SHULKER_BOX;
            case DyeColor.LIME -> Blocks.LIME_SHULKER_BOX;
            case DyeColor.PINK -> Blocks.PINK_SHULKER_BOX;
            case DyeColor.GRAY -> Blocks.GRAY_SHULKER_BOX;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_SHULKER_BOX;
            case DyeColor.CYAN -> Blocks.CYAN_SHULKER_BOX;
            case DyeColor.BLUE -> Blocks.BLUE_SHULKER_BOX;
            case DyeColor.BROWN -> Blocks.BROWN_SHULKER_BOX;
            case DyeColor.GREEN -> Blocks.GREEN_SHULKER_BOX;
            case DyeColor.RED -> Blocks.RED_SHULKER_BOX;
            case DyeColor.BLACK -> Blocks.BLACK_SHULKER_BOX;
            case DyeColor.PURPLE -> Blocks.PURPLE_SHULKER_BOX;
        };
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public static ItemStack getColoredItemStack(@Nullable DyeColor $$0) {
        return new ItemStack(ShulkerBoxBlock.getBlockByColor($$0));
    }

    @Override
    protected BlockState rotate(BlockState $$0, Rotation $$1) {
        return (BlockState)$$0.setValue(FACING, $$1.rotate($$0.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState $$0, Mirror $$1) {
        return $$0.rotate($$1.getRotation($$0.getValue(FACING)));
    }
}

