/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public record LootDataType<T>(ResourceKey<Registry<T>> registryKey, Codec<T> codec, String directory, Validator<T> validator) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LootDataType<LootItemCondition> PREDICATE = new LootDataType<LootItemCondition>(Registries.PREDICATE, LootItemConditions.DIRECT_CODEC, "predicates", LootDataType.createSimpleValidator());
    public static final LootDataType<LootItemFunction> MODIFIER = new LootDataType<LootItemFunction>(Registries.ITEM_MODIFIER, LootItemFunctions.ROOT_CODEC, "item_modifiers", LootDataType.createSimpleValidator());
    public static final LootDataType<LootTable> TABLE = new LootDataType<LootTable>(Registries.LOOT_TABLE, LootTable.DIRECT_CODEC, "loot_tables", LootDataType.createLootTableValidator());

    public void runValidation(ValidationContext p_279366_, ResourceKey<T> p_329223_, T p_279124_) {
        this.validator.run(p_279366_, p_329223_, p_279124_);
    }

    public <V> Optional<T> deserialize(ResourceLocation p_279253_, DynamicOps<V> p_335939_, V p_327740_) {
        DataResult dataresult = this.codec.parse(p_335939_, p_327740_);
        dataresult.error().ifPresent(p_327555_ -> LOGGER.error("Couldn't parse element {}:{} - {}", new Object[]{this.directory, p_279253_, p_327555_.message()}));
        Optional<LootTable> ret = dataresult.result();
        Object var7_6 = ret.orElse(null);
        if (var7_6 instanceof LootTable) {
            LootTable table = var7_6;
            table.setLootTableId(p_279253_);
            ret = Optional.ofNullable(ForgeEventFactory.onLoadLootTable((ResourceLocation)p_279253_, (LootTable)table));
        }
        return ret;
    }

    public static Stream<LootDataType<?>> values() {
        return Stream.of(PREDICATE, MODIFIER, TABLE);
    }

    private static <T extends LootContextUser> Validator<T> createSimpleValidator() {
        return (p_327548_, p_327549_, p_327550_) -> p_327550_.validate(p_327548_.enterElement("{" + String.valueOf(p_327549_.registry()) + "/" + String.valueOf(p_327549_.location()) + "}", p_327549_));
    }

    private static Validator<LootTable> createLootTableValidator() {
        return (p_327551_, p_327552_, p_327553_) -> p_327553_.validate(p_327551_.setParams(p_327553_.getParamSet()).enterElement("{" + String.valueOf(p_327552_.registry()) + "/" + String.valueOf(p_327552_.location()) + "}", p_327552_));
    }

    @FunctionalInterface
    public static interface Validator<T> {
        public void run(ValidationContext var1, ResourceKey<T> var2, T var3);
    }
}

