/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootingEnchantFunction
extends LootItemConditionalFunction {
    public static final int NO_LIMIT = 0;
    public static final MapCodec<LootingEnchantFunction> CODEC = RecordCodecBuilder.mapCodec(p_327577_ -> LootingEnchantFunction.commonFields(p_327577_).and(p_327577_.group((App)NumberProviders.CODEC.fieldOf("count").forGetter(p_300767_ -> p_300767_.value), (App)Codec.INT.optionalFieldOf("limit", (Object)0).forGetter(p_301305_ -> p_301305_.limit))).apply((Applicative)p_327577_, LootingEnchantFunction::new));
    private final NumberProvider value;
    private final int limit;

    LootingEnchantFunction(List<LootItemCondition> p_299292_, NumberProvider p_165227_, int p_165228_) {
        super(p_299292_);
        this.value = p_165227_;
        this.limit = p_165228_;
    }

    public LootItemFunctionType<LootingEnchantFunction> getType() {
        return LootItemFunctions.LOOTING_ENCHANT;
    }

    @Override
    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union((Set)ImmutableSet.of(LootContextParams.KILLER_ENTITY), this.value.getReferencedContextParams());
    }

    private boolean hasLimit() {
        return this.limit > 0;
    }

    @Override
    public ItemStack run(ItemStack p_80789_, LootContext p_80790_) {
        Entity entity = p_80790_.getParamOrNull(LootContextParams.KILLER_ENTITY);
        if (entity instanceof LivingEntity) {
            int i = p_80790_.getLootingModifier();
            if (i == 0) {
                return p_80789_;
            }
            float f = (float)i * this.value.getFloat(p_80790_);
            p_80789_.grow(Math.round(f));
            if (this.hasLimit()) {
                p_80789_.limitSize(this.limit);
            }
        }
        return p_80789_;
    }

    public static Builder lootingMultiplier(NumberProvider p_165230_) {
        return new Builder(p_165230_);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NumberProvider count;
        private int limit = 0;

        public Builder(NumberProvider p_165232_) {
            this.count = p_165232_;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setLimit(int p_80807_) {
            this.limit = p_80807_;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootingEnchantFunction(this.getConditions(), this.count, this.limit);
        }
    }
}

