/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class ResourceOrIdArgument<T>
implements ArgumentType<Holder<T>> {
    private static final Collection<String> EXAMPLES = List.of("foo", "foo:bar", "012", "{}", "true");
    public static final DynamicCommandExceptionType ERROR_FAILED_TO_PARSE = new DynamicCommandExceptionType($$0 -> Component.translatableEscape("argument.resource_or_id.failed_to_parse", $$0));
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("argument.resource_or_id.invalid"));
    private final HolderLookup.Provider registryLookup;
    private final boolean hasRegistry;
    private final Codec<Holder<T>> codec;

    protected ResourceOrIdArgument(CommandBuildContext $$0, ResourceKey<Registry<T>> $$1, Codec<Holder<T>> $$2) {
        this.registryLookup = $$0;
        this.hasRegistry = $$0.lookup($$1).isPresent();
        this.codec = $$2;
    }

    public static LootTableArgument lootTable(CommandBuildContext $$0) {
        return new LootTableArgument($$0);
    }

    public static Holder<LootTable> getLootTable(CommandContext<CommandSourceStack> $$0, String $$1) throws CommandSyntaxException {
        return ResourceOrIdArgument.getResource($$0, $$1);
    }

    public static LootModifierArgument lootModifier(CommandBuildContext $$0) {
        return new LootModifierArgument($$0);
    }

    public static Holder<LootItemFunction> getLootModifier(CommandContext<CommandSourceStack> $$0, String $$1) {
        return ResourceOrIdArgument.getResource($$0, $$1);
    }

    public static LootPredicateArgument lootPredicate(CommandBuildContext $$0) {
        return new LootPredicateArgument($$0);
    }

    public static Holder<LootItemCondition> getLootPredicate(CommandContext<CommandSourceStack> $$0, String $$1) {
        return ResourceOrIdArgument.getResource($$0, $$1);
    }

    private static <T> Holder<T> getResource(CommandContext<CommandSourceStack> $$0, String $$1) {
        return (Holder)$$0.getArgument($$1, Holder.class);
    }

    @Nullable
    public Holder<T> parse(StringReader $$0) throws CommandSyntaxException {
        Tag $$12 = ResourceOrIdArgument.parseInlineOrId($$0);
        if (!this.hasRegistry) {
            return null;
        }
        RegistryOps<Tag> $$2 = this.registryLookup.createSerializationContext(NbtOps.INSTANCE);
        return (Holder)this.codec.parse($$2, (Object)$$12).getOrThrow($$1 -> ERROR_FAILED_TO_PARSE.createWithContext((ImmutableStringReader)$$0, $$1));
    }

    @VisibleForTesting
    static Tag parseInlineOrId(StringReader $$0) throws CommandSyntaxException {
        int $$1 = $$0.getCursor();
        Tag $$2 = new TagParser($$0).readValue();
        if (ResourceOrIdArgument.hasConsumedWholeArg($$0)) {
            return $$2;
        }
        $$0.setCursor($$1);
        ResourceLocation $$3 = ResourceLocation.read($$0);
        if (ResourceOrIdArgument.hasConsumedWholeArg($$0)) {
            return StringTag.valueOf($$3.toString());
        }
        $$0.setCursor($$1);
        throw ERROR_INVALID.createWithContext((ImmutableStringReader)$$0);
    }

    private static boolean hasConsumedWholeArg(StringReader $$0) {
        return !$$0.canRead() || $$0.peek() == ' ';
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Nullable
    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class LootTableArgument
    extends ResourceOrIdArgument<LootTable> {
        protected LootTableArgument(CommandBuildContext $$0) {
            super($$0, Registries.LOOT_TABLE, LootTable.CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class LootModifierArgument
    extends ResourceOrIdArgument<LootItemFunction> {
        protected LootModifierArgument(CommandBuildContext $$0) {
            super($$0, Registries.ITEM_MODIFIER, LootItemFunctions.CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class LootPredicateArgument
    extends ResourceOrIdArgument<LootItemCondition> {
        protected LootPredicateArgument(CommandBuildContext $$0) {
            super($$0, Registries.PREDICATE, LootItemConditions.CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }
}

