/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.item.ComponentPredicateParser;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemPredicateArgument
implements ArgumentType<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick", "minecraft:stick", "#stick", "#stick{foo:'bar'}");
    static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType($$0 -> Component.translatableEscape("argument.item.id.invalid", $$0));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType($$0 -> Component.translatableEscape("arguments.item.tag.unknown", $$0));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType($$0 -> Component.translatableEscape("arguments.item.component.unknown", $$0));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType(($$0, $$1) -> Component.translatableEscape("arguments.item.component.malformed", $$0, $$1));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_PREDICATE = new DynamicCommandExceptionType($$0 -> Component.translatableEscape("arguments.item.predicate.unknown", $$0));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_PREDICATE = new Dynamic2CommandExceptionType(($$0, $$1) -> Component.translatableEscape("arguments.item.predicate.malformed", $$0, $$1));
    private static final ResourceLocation COUNT_ID = new ResourceLocation("count");
    static final Map<ResourceLocation, ComponentWrapper> PSEUDO_COMPONENTS = Stream.of(new ComponentWrapper(COUNT_ID, $$0 -> true, (Decoder<? extends Predicate<ItemStack>>)MinMaxBounds.Ints.CODEC.map($$0 -> $$1 -> $$0.matches($$1.getCount())))).collect(Collectors.toUnmodifiableMap(ComponentWrapper::id, $$0 -> $$0));
    static final Map<ResourceLocation, PredicateWrapper> PSEUDO_PREDICATES = Stream.of(new PredicateWrapper(COUNT_ID, (Decoder<? extends Predicate<ItemStack>>)MinMaxBounds.Ints.CODEC.map($$0 -> $$1 -> $$0.matches($$1.getCount())))).collect(Collectors.toUnmodifiableMap(PredicateWrapper::id, $$0 -> $$0));
    private final Grammar<List<Predicate<ItemStack>>> grammarWithContext;

    public ItemPredicateArgument(CommandBuildContext $$0) {
        Context $$1 = new Context($$0);
        this.grammarWithContext = ComponentPredicateParser.createGrammar($$1);
    }

    public static ItemPredicateArgument itemPredicate(CommandBuildContext $$0) {
        return new ItemPredicateArgument($$0);
    }

    public Result parse(StringReader $$0) throws CommandSyntaxException {
        return Util.allOf(this.grammarWithContext.parseForCommands($$0))::test;
    }

    public static Result getItemPredicate(CommandContext<CommandSourceStack> $$0, String $$1) {
        return (Result)$$0.getArgument($$1, Result.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> $$0, SuggestionsBuilder $$1) {
        return this.grammarWithContext.parseForSuggestions($$1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class Context
    implements ComponentPredicateParser.Context<Predicate<ItemStack>, ComponentWrapper, PredicateWrapper> {
        private final HolderLookup.RegistryLookup<Item> items;
        private final HolderLookup.RegistryLookup<DataComponentType<?>> components;
        private final HolderLookup.RegistryLookup<ItemSubPredicate.Type<?>> predicates;
        private final RegistryOps<Tag> registryOps;

        Context(HolderLookup.Provider $$0) {
            this.items = $$0.lookupOrThrow(Registries.ITEM);
            this.components = $$0.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
            this.predicates = $$0.lookupOrThrow(Registries.ITEM_SUB_PREDICATE_TYPE);
            this.registryOps = $$0.createSerializationContext(NbtOps.INSTANCE);
        }

        @Override
        public Predicate<ItemStack> forElementType(ImmutableStringReader $$0, ResourceLocation $$12) throws CommandSyntaxException {
            Holder.Reference<Item> $$2 = this.items.get(ResourceKey.create(Registries.ITEM, $$12)).orElseThrow(() -> ERROR_UNKNOWN_ITEM.createWithContext($$0, (Object)$$12));
            return $$1 -> $$1.is($$2);
        }

        @Override
        public Predicate<ItemStack> forTagType(ImmutableStringReader $$0, ResourceLocation $$12) throws CommandSyntaxException {
            HolderSet $$2 = this.items.get(TagKey.create(Registries.ITEM, $$12)).orElseThrow(() -> ERROR_UNKNOWN_TAG.createWithContext($$0, (Object)$$12));
            return $$1 -> $$1.is($$2);
        }

        @Override
        public ComponentWrapper lookupComponentType(ImmutableStringReader $$0, ResourceLocation $$1) throws CommandSyntaxException {
            ComponentWrapper $$2 = PSEUDO_COMPONENTS.get($$1);
            if ($$2 != null) {
                return $$2;
            }
            DataComponentType $$3 = this.components.get(ResourceKey.create(Registries.DATA_COMPONENT_TYPE, $$1)).map(Holder::value).orElseThrow(() -> ERROR_UNKNOWN_COMPONENT.createWithContext($$0, (Object)$$1));
            return ComponentWrapper.create($$0, $$1, $$3);
        }

        @Override
        public Predicate<ItemStack> createComponentTest(ImmutableStringReader $$0, ComponentWrapper $$1, Tag $$2) throws CommandSyntaxException {
            return $$1.decode($$0, this.registryOps, $$2);
        }

        @Override
        public Predicate<ItemStack> createComponentTest(ImmutableStringReader $$0, ComponentWrapper $$1) {
            return $$1.presenceChecker;
        }

        @Override
        public PredicateWrapper lookupPredicateType(ImmutableStringReader $$0, ResourceLocation $$1) throws CommandSyntaxException {
            PredicateWrapper $$2 = PSEUDO_PREDICATES.get($$1);
            if ($$2 != null) {
                return $$2;
            }
            return this.predicates.get(ResourceKey.create(Registries.ITEM_SUB_PREDICATE_TYPE, $$1)).map(PredicateWrapper::new).orElseThrow(() -> ERROR_UNKNOWN_PREDICATE.createWithContext($$0, (Object)$$1));
        }

        @Override
        public Predicate<ItemStack> createPredicateTest(ImmutableStringReader $$0, PredicateWrapper $$1, Tag $$2) throws CommandSyntaxException {
            return $$1.decode($$0, this.registryOps, $$2);
        }

        @Override
        public Stream<ResourceLocation> listElementTypes() {
            return this.items.listElementIds().map(ResourceKey::location);
        }

        @Override
        public Stream<ResourceLocation> listTagTypes() {
            return this.items.listTagIds().map(TagKey::location);
        }

        @Override
        public Stream<ResourceLocation> listComponentTypes() {
            return Stream.concat(PSEUDO_COMPONENTS.keySet().stream(), this.components.listElements().filter($$0 -> !((DataComponentType)$$0.value()).isTransient()).map($$0 -> $$0.key().location()));
        }

        @Override
        public Stream<ResourceLocation> listPredicateTypes() {
            return Stream.concat(PSEUDO_PREDICATES.keySet().stream(), this.predicates.listElementIds().map(ResourceKey::location));
        }

        @Override
        public Predicate<ItemStack> negate(Predicate<ItemStack> $$0) {
            return $$0.negate();
        }

        @Override
        public Predicate<ItemStack> anyOf(List<Predicate<ItemStack>> $$0) {
            return Util.anyOf($$0);
        }

        @Override
        public /* synthetic */ Object anyOf(List list) {
            return this.anyOf(list);
        }

        @Override
        public /* synthetic */ Object createPredicateTest(ImmutableStringReader immutableStringReader, Object object, Tag tag) throws CommandSyntaxException {
            return this.createPredicateTest(immutableStringReader, (PredicateWrapper)object, tag);
        }

        @Override
        public /* synthetic */ Object lookupPredicateType(ImmutableStringReader immutableStringReader, ResourceLocation resourceLocation) throws CommandSyntaxException {
            return this.lookupPredicateType(immutableStringReader, resourceLocation);
        }

        @Override
        public /* synthetic */ Object lookupComponentType(ImmutableStringReader immutableStringReader, ResourceLocation resourceLocation) throws CommandSyntaxException {
            return this.lookupComponentType(immutableStringReader, resourceLocation);
        }

        @Override
        public /* synthetic */ Object forTagType(ImmutableStringReader immutableStringReader, ResourceLocation resourceLocation) throws CommandSyntaxException {
            return this.forTagType(immutableStringReader, resourceLocation);
        }

        @Override
        public /* synthetic */ Object forElementType(ImmutableStringReader immutableStringReader, ResourceLocation resourceLocation) throws CommandSyntaxException {
            return this.forElementType(immutableStringReader, resourceLocation);
        }
    }

    public static interface Result
    extends Predicate<ItemStack> {
    }

    record ComponentWrapper(ResourceLocation id, Predicate<ItemStack> presenceChecker, Decoder<? extends Predicate<ItemStack>> valueChecker) {
        public static <T> ComponentWrapper create(ImmutableStringReader $$0, ResourceLocation $$12, DataComponentType<T> $$2) throws CommandSyntaxException {
            Codec<T> $$3 = $$2.codec();
            if ($$3 == null) {
                throw ERROR_UNKNOWN_COMPONENT.createWithContext($$0, (Object)$$12);
            }
            return new ComponentWrapper($$12, $$1 -> $$1.has($$2), (Decoder<? extends Predicate<ItemStack>>)$$3.map($$1 -> $$2 -> {
                Object $$3 = $$2.get($$2);
                return Objects.equals($$1, $$3);
            }));
        }

        public Predicate<ItemStack> decode(ImmutableStringReader $$0, RegistryOps<Tag> $$12, Tag $$2) throws CommandSyntaxException {
            DataResult $$3 = this.valueChecker.parse($$12, (Object)$$2);
            return (Predicate)$$3.getOrThrow($$1 -> ERROR_MALFORMED_COMPONENT.createWithContext($$0, (Object)this.id.toString(), $$1));
        }
    }

    record PredicateWrapper(ResourceLocation id, Decoder<? extends Predicate<ItemStack>> type) {
        public PredicateWrapper(Holder.Reference<ItemSubPredicate.Type<?>> $$02) {
            this($$02.key().location(), (Decoder<? extends Predicate<ItemStack>>)$$02.value().codec().map($$0 -> $$0::matches));
        }

        public Predicate<ItemStack> decode(ImmutableStringReader $$0, RegistryOps<Tag> $$12, Tag $$2) throws CommandSyntaxException {
            DataResult $$3 = this.type.parse($$12, (Object)$$2);
            return (Predicate)$$3.getOrThrow($$1 -> ERROR_MALFORMED_PREDICATE.createWithContext($$0, (Object)this.id.toString(), $$1));
        }
    }
}

