/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public interface DispenseItemBehavior {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DispenseItemBehavior NOOP = ($$0, $$1) -> $$1;

    public ItemStack dispense(BlockSource var1, ItemStack var2);

    public static void bootStrap() {
        DispenserBlock.registerProjectileBehavior(Items.ARROW);
        DispenserBlock.registerProjectileBehavior(Items.TIPPED_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.SPECTRAL_ARROW);
        DispenserBlock.registerProjectileBehavior(Items.EGG);
        DispenserBlock.registerProjectileBehavior(Items.SNOWBALL);
        DispenserBlock.registerProjectileBehavior(Items.EXPERIENCE_BOTTLE);
        DispenserBlock.registerProjectileBehavior(Items.SPLASH_POTION);
        DispenserBlock.registerProjectileBehavior(Items.LINGERING_POTION);
        DispenserBlock.registerProjectileBehavior(Items.FIREWORK_ROCKET);
        DispenserBlock.registerProjectileBehavior(Items.FIRE_CHARGE);
        DispenserBlock.registerProjectileBehavior(Items.WIND_CHARGE);
        DefaultDispenseItemBehavior $$0 = new DefaultDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource $$0, ItemStack $$1) {
                Direction $$2 = $$0.state().getValue(DispenserBlock.FACING);
                EntityType<?> $$3 = ((SpawnEggItem)$$1.getItem()).getType($$1);
                try {
                    $$3.spawn($$0.level(), $$1, null, $$0.pos().relative($$2), MobSpawnType.DISPENSER, $$2 != Direction.UP, false);
                }
                catch (Exception $$4) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)$$0.pos(), (Object)$$4);
                    return ItemStack.EMPTY;
                }
                $$1.shrink(1);
                $$0.level().gameEvent(null, GameEvent.ENTITY_PLACE, $$0.pos());
                return $$1;
            }
        };
        for (SpawnEggItem $$1 : SpawnEggItem.eggs()) {
            DispenserBlock.registerBehavior($$1, $$0);
        }
        DispenserBlock.registerBehavior(Items.ARMOR_STAND, new DefaultDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource $$0, ItemStack $$12) {
                Consumer<ArmorStand> $$5;
                Direction $$2 = $$0.state().getValue(DispenserBlock.FACING);
                BlockPos $$3 = $$0.pos().relative($$2);
                ServerLevel $$4 = $$0.level();
                ArmorStand $$6 = EntityType.ARMOR_STAND.spawn($$4, $$5 = EntityType.appendDefaultStackConfig($$1 -> $$1.setYRot($$2.toYRot()), $$4, $$12, null), $$3, MobSpawnType.DISPENSER, false, false);
                if ($$6 != null) {
                    $$12.shrink(1);
                }
                return $$12;
            }
        });
        DispenserBlock.registerBehavior(Items.SADDLE, new OptionalDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource $$02, ItemStack $$1) {
                BlockPos $$2 = $$02.pos().relative($$02.state().getValue(DispenserBlock.FACING));
                List<LivingEntity> $$3 = $$02.level().getEntitiesOfClass(LivingEntity.class, new AABB($$2), $$0 -> {
                    if ($$0 instanceof Saddleable) {
                        Saddleable $$1 = (Saddleable)((Object)$$0);
                        return !$$1.isSaddled() && $$1.isSaddleable();
                    }
                    return false;
                });
                if (!$$3.isEmpty()) {
                    ((Saddleable)((Object)$$3.get(0))).equipSaddle(SoundSource.BLOCKS);
                    $$1.shrink(1);
                    this.setSuccess(true);
                    return $$1;
                }
                return super.execute($$02, $$1);
            }
        });
        OptionalDispenseItemBehavior $$2 = new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource $$02, ItemStack $$1) {
                BlockPos $$2 = $$02.pos().relative($$02.state().getValue(DispenserBlock.FACING));
                List<AbstractHorse> $$3 = $$02.level().getEntitiesOfClass(AbstractHorse.class, new AABB($$2), $$0 -> $$0.isAlive() && $$0.canWearBodyArmor());
                for (AbstractHorse $$4 : $$3) {
                    if (!$$4.isBodyArmorItem($$1) || $$4.isWearingBodyArmor() || !$$4.isTamed()) continue;
                    $$4.setBodyArmorItem($$1.split(1));
                    this.setSuccess(true);
                    return $$1;
                }
                return super.execute($$02, $$1);
            }
        };
        DispenserBlock.registerBehavior(Items.LEATHER_HORSE_ARMOR, $$2);
        DispenserBlock.registerBehavior(Items.IRON_HORSE_ARMOR, $$2);
        DispenserBlock.registerBehavior(Items.GOLDEN_HORSE_ARMOR, $$2);
        DispenserBlock.registerBehavior(Items.DIAMOND_HORSE_ARMOR, $$2);
        DispenserBlock.registerBehavior(Items.WHITE_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.ORANGE_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.CYAN_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.BLUE_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.BROWN_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.BLACK_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.GRAY_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.GREEN_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.LIGHT_BLUE_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.LIGHT_GRAY_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.LIME_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.MAGENTA_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.PINK_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.PURPLE_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.RED_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.YELLOW_CARPET, $$2);
        DispenserBlock.registerBehavior(Items.CHEST, new OptionalDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource $$02, ItemStack $$1) {
                BlockPos $$2 = $$02.pos().relative($$02.state().getValue(DispenserBlock.FACING));
                List<AbstractChestedHorse> $$3 = $$02.level().getEntitiesOfClass(AbstractChestedHorse.class, new AABB($$2), $$0 -> $$0.isAlive() && !$$0.hasChest());
                for (AbstractChestedHorse $$4 : $$3) {
                    if (!$$4.isTamed() || !$$4.getSlot(499).set($$1)) continue;
                    $$1.shrink(1);
                    this.setSuccess(true);
                    return $$1;
                }
                return super.execute($$02, $$1);
            }
        });
        DispenserBlock.registerBehavior(Items.OAK_BOAT, new BoatDispenseItemBehavior(Boat.Type.OAK));
        DispenserBlock.registerBehavior(Items.SPRUCE_BOAT, new BoatDispenseItemBehavior(Boat.Type.SPRUCE));
        DispenserBlock.registerBehavior(Items.BIRCH_BOAT, new BoatDispenseItemBehavior(Boat.Type.BIRCH));
        DispenserBlock.registerBehavior(Items.JUNGLE_BOAT, new BoatDispenseItemBehavior(Boat.Type.JUNGLE));
        DispenserBlock.registerBehavior(Items.DARK_OAK_BOAT, new BoatDispenseItemBehavior(Boat.Type.DARK_OAK));
        DispenserBlock.registerBehavior(Items.ACACIA_BOAT, new BoatDispenseItemBehavior(Boat.Type.ACACIA));
        DispenserBlock.registerBehavior(Items.CHERRY_BOAT, new BoatDispenseItemBehavior(Boat.Type.CHERRY));
        DispenserBlock.registerBehavior(Items.MANGROVE_BOAT, new BoatDispenseItemBehavior(Boat.Type.MANGROVE));
        DispenserBlock.registerBehavior(Items.BAMBOO_RAFT, new BoatDispenseItemBehavior(Boat.Type.BAMBOO));
        DispenserBlock.registerBehavior(Items.OAK_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.OAK, true));
        DispenserBlock.registerBehavior(Items.SPRUCE_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.SPRUCE, true));
        DispenserBlock.registerBehavior(Items.BIRCH_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.BIRCH, true));
        DispenserBlock.registerBehavior(Items.JUNGLE_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.JUNGLE, true));
        DispenserBlock.registerBehavior(Items.DARK_OAK_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.DARK_OAK, true));
        DispenserBlock.registerBehavior(Items.ACACIA_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.ACACIA, true));
        DispenserBlock.registerBehavior(Items.CHERRY_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.CHERRY, true));
        DispenserBlock.registerBehavior(Items.MANGROVE_CHEST_BOAT, new BoatDispenseItemBehavior(Boat.Type.MANGROVE, true));
        DispenserBlock.registerBehavior(Items.BAMBOO_CHEST_RAFT, new BoatDispenseItemBehavior(Boat.Type.BAMBOO, true));
        DefaultDispenseItemBehavior $$3 = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Override
            public ItemStack execute(BlockSource $$0, ItemStack $$1) {
                DispensibleContainerItem $$2 = (DispensibleContainerItem)((Object)$$1.getItem());
                BlockPos $$3 = $$0.pos().relative($$0.state().getValue(DispenserBlock.FACING));
                ServerLevel $$4 = $$0.level();
                if ($$2.emptyContents(null, $$4, $$3, null)) {
                    $$2.checkExtraContent(null, $$4, $$1, $$3);
                    return new ItemStack(Items.BUCKET);
                }
                return this.defaultDispenseItemBehavior.dispense($$0, $$1);
            }
        };
        DispenserBlock.registerBehavior(Items.LAVA_BUCKET, $$3);
        DispenserBlock.registerBehavior(Items.WATER_BUCKET, $$3);
        DispenserBlock.registerBehavior(Items.POWDER_SNOW_BUCKET, $$3);
        DispenserBlock.registerBehavior(Items.SALMON_BUCKET, $$3);
        DispenserBlock.registerBehavior(Items.COD_BUCKET, $$3);
        DispenserBlock.registerBehavior(Items.PUFFERFISH_BUCKET, $$3);
        DispenserBlock.registerBehavior(Items.TROPICAL_FISH_BUCKET, $$3);
        DispenserBlock.registerBehavior(Items.AXOLOTL_BUCKET, $$3);
        DispenserBlock.registerBehavior(Items.TADPOLE_BUCKET, $$3);
        DispenserBlock.registerBehavior(Items.BUCKET, new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            /*
             * WARNING - void declaration
             */
            @Override
            public ItemStack execute(BlockSource $$0, ItemStack $$1) {
                void $$9;
                ItemStack $$7;
                BlockPos $$3;
                ServerLevel $$2 = $$0.level();
                BlockState $$4 = $$2.getBlockState($$3 = $$0.pos().relative($$0.state().getValue(DispenserBlock.FACING)));
                Block $$5 = $$4.getBlock();
                if ($$5 instanceof BucketPickup) {
                    BucketPickup $$6 = (BucketPickup)((Object)$$5);
                    $$7 = $$6.pickupBlock(null, $$2, $$3, $$4);
                    if ($$7.isEmpty()) {
                        return super.execute($$0, $$1);
                    }
                } else {
                    return super.execute($$0, $$1);
                }
                $$2.gameEvent(null, GameEvent.FLUID_PICKUP, $$3);
                Item $$8 = $$7.getItem();
                $$1.shrink(1);
                if ($$1.isEmpty()) {
                    return new ItemStack((ItemLike)$$9);
                }
                if ($$0.blockEntity().addItem(new ItemStack((ItemLike)$$9)) < 0) {
                    this.defaultDispenseItemBehavior.dispense($$0, new ItemStack((ItemLike)$$9));
                }
                return $$1;
            }
        });
        DispenserBlock.registerBehavior(Items.FLINT_AND_STEEL, new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource $$0, ItemStack $$1) {
                ServerLevel $$2 = $$0.level();
                this.setSuccess(true);
                Direction $$3 = $$0.state().getValue(DispenserBlock.FACING);
                BlockPos $$4 = $$0.pos().relative($$3);
                BlockState $$5 = $$2.getBlockState($$4);
                if (BaseFireBlock.canBePlacedAt($$2, $$4, $$3)) {
                    $$2.setBlockAndUpdate($$4, BaseFireBlock.getState($$2, $$4));
                    $$2.gameEvent(null, GameEvent.BLOCK_PLACE, $$4);
                } else if (CampfireBlock.canLight($$5) || CandleBlock.canLight($$5) || CandleCakeBlock.canLight($$5)) {
                    $$2.setBlockAndUpdate($$4, (BlockState)$$5.setValue(BlockStateProperties.LIT, true));
                    $$2.gameEvent(null, GameEvent.BLOCK_CHANGE, $$4);
                } else if ($$5.getBlock() instanceof TntBlock) {
                    TntBlock.explode($$2, $$4);
                    $$2.removeBlock($$4, false);
                } else {
                    this.setSuccess(false);
                }
                if (this.isSuccess()) {
                    $$1.hurtAndBreak(1, $$2.getRandom(), null, () -> $$1.setCount(0));
                }
                return $$1;
            }
        });
        DispenserBlock.registerBehavior(Items.BONE_MEAL, new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource $$0, ItemStack $$1) {
                this.setSuccess(true);
                ServerLevel $$2 = $$0.level();
                BlockPos $$3 = $$0.pos().relative($$0.state().getValue(DispenserBlock.FACING));
                if (BoneMealItem.growCrop($$1, $$2, $$3) || BoneMealItem.growWaterPlant($$1, $$2, $$3, null)) {
                    if (!$$2.isClientSide) {
                        $$2.levelEvent(1505, $$3, 15);
                    }
                } else {
                    this.setSuccess(false);
                }
                return $$1;
            }
        });
        DispenserBlock.registerBehavior(Blocks.TNT, new DefaultDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource $$0, ItemStack $$1) {
                ServerLevel $$2 = $$0.level();
                BlockPos $$3 = $$0.pos().relative($$0.state().getValue(DispenserBlock.FACING));
                PrimedTnt $$4 = new PrimedTnt($$2, (double)$$3.getX() + 0.5, $$3.getY(), (double)$$3.getZ() + 0.5, null);
                $$2.addFreshEntity($$4);
                $$2.playSound(null, $$4.getX(), $$4.getY(), $$4.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                $$2.gameEvent(null, GameEvent.ENTITY_PLACE, $$3);
                $$1.shrink(1);
                return $$1;
            }
        });
        OptionalDispenseItemBehavior $$4 = new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource $$0, ItemStack $$1) {
                this.setSuccess(ArmorItem.dispenseArmor($$0, $$1));
                return $$1;
            }
        };
        DispenserBlock.registerBehavior(Items.CREEPER_HEAD, $$4);
        DispenserBlock.registerBehavior(Items.ZOMBIE_HEAD, $$4);
        DispenserBlock.registerBehavior(Items.DRAGON_HEAD, $$4);
        DispenserBlock.registerBehavior(Items.SKELETON_SKULL, $$4);
        DispenserBlock.registerBehavior(Items.PIGLIN_HEAD, $$4);
        DispenserBlock.registerBehavior(Items.PLAYER_HEAD, $$4);
        DispenserBlock.registerBehavior(Items.WITHER_SKELETON_SKULL, new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource $$0, ItemStack $$1) {
                ServerLevel $$2 = $$0.level();
                Direction $$3 = $$0.state().getValue(DispenserBlock.FACING);
                BlockPos $$4 = $$0.pos().relative($$3);
                if ($$2.isEmptyBlock($$4) && WitherSkullBlock.canSpawnMob($$2, $$4, $$1)) {
                    $$2.setBlock($$4, (BlockState)Blocks.WITHER_SKELETON_SKULL.defaultBlockState().setValue(SkullBlock.ROTATION, RotationSegment.convertToSegment($$3)), 3);
                    $$2.gameEvent(null, GameEvent.BLOCK_PLACE, $$4);
                    BlockEntity $$5 = $$2.getBlockEntity($$4);
                    if ($$5 instanceof SkullBlockEntity) {
                        WitherSkullBlock.checkSpawn($$2, $$4, (SkullBlockEntity)$$5);
                    }
                    $$1.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ArmorItem.dispenseArmor($$0, $$1));
                }
                return $$1;
            }
        });
        DispenserBlock.registerBehavior(Blocks.CARVED_PUMPKIN, new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource $$0, ItemStack $$1) {
                ServerLevel $$2 = $$0.level();
                BlockPos $$3 = $$0.pos().relative($$0.state().getValue(DispenserBlock.FACING));
                CarvedPumpkinBlock $$4 = (CarvedPumpkinBlock)Blocks.CARVED_PUMPKIN;
                if ($$2.isEmptyBlock($$3) && $$4.canSpawnGolem($$2, $$3)) {
                    if (!$$2.isClientSide) {
                        $$2.setBlock($$3, $$4.defaultBlockState(), 3);
                        $$2.gameEvent(null, GameEvent.BLOCK_PLACE, $$3);
                    }
                    $$1.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ArmorItem.dispenseArmor($$0, $$1));
                }
                return $$1;
            }
        });
        DispenserBlock.registerBehavior(Blocks.SHULKER_BOX.asItem(), new ShulkerBoxDispenseBehavior());
        for (DyeColor $$5 : DyeColor.values()) {
            DispenserBlock.registerBehavior(ShulkerBoxBlock.getBlockByColor($$5).asItem(), new ShulkerBoxDispenseBehavior());
        }
        DispenserBlock.registerBehavior(Items.GLASS_BOTTLE.asItem(), new OptionalDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            private ItemStack takeLiquid(BlockSource $$0, ItemStack $$1, ItemStack $$2) {
                $$1.shrink(1);
                if ($$1.isEmpty()) {
                    $$0.level().gameEvent(null, GameEvent.FLUID_PICKUP, $$0.pos());
                    return $$2.copy();
                }
                if ($$0.blockEntity().addItem($$2.copy()) < 0) {
                    this.defaultDispenseItemBehavior.dispense($$0, $$2.copy());
                }
                return $$1;
            }

            @Override
            public ItemStack execute(BlockSource $$02, ItemStack $$1) {
                this.setSuccess(false);
                ServerLevel $$2 = $$02.level();
                BlockPos $$3 = $$02.pos().relative($$02.state().getValue(DispenserBlock.FACING));
                BlockState $$4 = $$2.getBlockState($$3);
                if ($$4.is(BlockTags.BEEHIVES, $$0 -> $$0.hasProperty(BeehiveBlock.HONEY_LEVEL) && $$0.getBlock() instanceof BeehiveBlock) && $$4.getValue(BeehiveBlock.HONEY_LEVEL) >= 5) {
                    ((BeehiveBlock)$$4.getBlock()).releaseBeesAndResetHoneyLevel($$2, $$4, $$3, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                    this.setSuccess(true);
                    return this.takeLiquid($$02, $$1, new ItemStack(Items.HONEY_BOTTLE));
                }
                if ($$2.getFluidState($$3).is(FluidTags.WATER)) {
                    this.setSuccess(true);
                    return this.takeLiquid($$02, $$1, PotionContents.createItemStack(Items.POTION, Potions.WATER));
                }
                return super.execute($$02, $$1);
            }
        });
        DispenserBlock.registerBehavior(Items.GLOWSTONE, new OptionalDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource $$0, ItemStack $$1) {
                Direction $$2 = $$0.state().getValue(DispenserBlock.FACING);
                BlockPos $$3 = $$0.pos().relative($$2);
                ServerLevel $$4 = $$0.level();
                BlockState $$5 = $$4.getBlockState($$3);
                this.setSuccess(true);
                if ($$5.is(Blocks.RESPAWN_ANCHOR)) {
                    if ($$5.getValue(RespawnAnchorBlock.CHARGE) != 4) {
                        RespawnAnchorBlock.charge(null, $$4, $$3, $$5);
                        $$1.shrink(1);
                    } else {
                        this.setSuccess(false);
                    }
                    return $$1;
                }
                return super.execute($$0, $$1);
            }
        });
        DispenserBlock.registerBehavior(Items.SHEARS.asItem(), new ShearsDispenseItemBehavior());
        DispenserBlock.registerBehavior(Items.BRUSH.asItem(), new OptionalDispenseItemBehavior(){

            @Override
            protected ItemStack execute(BlockSource $$0, ItemStack $$1) {
                BlockPos $$3;
                ServerLevel $$2 = $$0.level();
                List<Entity> $$4 = $$2.getEntitiesOfClass(Armadillo.class, new AABB($$3 = $$0.pos().relative($$0.state().getValue(DispenserBlock.FACING))), EntitySelector.NO_SPECTATORS);
                if ($$4.isEmpty()) {
                    this.setSuccess(false);
                    return $$1;
                }
                for (Armadillo armadillo : $$4) {
                    if (!armadillo.brushOffScute()) continue;
                    $$1.hurtAndBreak(16, $$2.getRandom(), null, () -> {
                        $$1.shrink(1);
                        $$1.setDamageValue(0);
                    });
                    return $$1;
                }
                this.setSuccess(false);
                return $$1;
            }
        });
        DispenserBlock.registerBehavior(Items.HONEYCOMB, new OptionalDispenseItemBehavior(){

            @Override
            public ItemStack execute(BlockSource $$0, ItemStack $$1) {
                BlockPos $$2 = $$0.pos().relative($$0.state().getValue(DispenserBlock.FACING));
                ServerLevel $$3 = $$0.level();
                BlockState $$4 = $$3.getBlockState($$2);
                Optional<BlockState> $$5 = HoneycombItem.getWaxed($$4);
                if ($$5.isPresent()) {
                    $$3.setBlockAndUpdate($$2, $$5.get());
                    $$3.levelEvent(3003, $$2, 0);
                    $$1.shrink(1);
                    this.setSuccess(true);
                    return $$1;
                }
                return super.execute($$0, $$1);
            }
        });
        DispenserBlock.registerBehavior(Items.POTION, new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Override
            public ItemStack execute(BlockSource $$0, ItemStack $$1) {
                PotionContents $$2 = $$1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
                if (!$$2.is(Potions.WATER)) {
                    return this.defaultDispenseItemBehavior.dispense($$0, $$1);
                }
                ServerLevel $$3 = $$0.level();
                BlockPos $$4 = $$0.pos();
                BlockPos $$5 = $$0.pos().relative($$0.state().getValue(DispenserBlock.FACING));
                if ($$3.getBlockState($$5).is(BlockTags.CONVERTABLE_TO_MUD)) {
                    if (!$$3.isClientSide) {
                        for (int $$6 = 0; $$6 < 5; ++$$6) {
                            $$3.sendParticles(ParticleTypes.SPLASH, (double)$$4.getX() + $$3.random.nextDouble(), $$4.getY() + 1, (double)$$4.getZ() + $$3.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                    $$3.playSound(null, $$4, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    $$3.gameEvent(null, GameEvent.FLUID_PLACE, $$4);
                    $$3.setBlockAndUpdate($$5, Blocks.MUD.defaultBlockState());
                    return new ItemStack(Items.GLASS_BOTTLE);
                }
                return this.defaultDispenseItemBehavior.dispense($$0, $$1);
            }
        });
    }
}

