/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.enchantment.Enchantment;

public abstract class EnchantmentTagsProvider
extends IntrinsicHolderTagsProvider<Enchantment> {
    private final FeatureFlagSet enabledFeatures;

    public EnchantmentTagsProvider(PackOutput $$02, CompletableFuture<HolderLookup.Provider> $$1, FeatureFlagSet $$2) {
        super($$02, Registries.ENCHANTMENT, $$1, (T $$0) -> $$0.builtInRegistryHolder().key());
        this.enabledFeatures = $$2;
    }

    protected void tooltipOrder(HolderLookup.Provider $$02, Enchantment ... $$12) {
        ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.tag((TagKey)EnchantmentTags.TOOLTIP_ORDER)).add((T[])$$12);
        Set<Enchantment> $$2 = Set.of($$12);
        List $$3 = $$02.lookupOrThrow(Registries.ENCHANTMENT).listElements().filter($$0 -> ((Enchantment)$$0.value()).requiredFeatures().isSubsetOf(this.enabledFeatures)).filter($$1 -> !$$2.contains($$1.value())).map(Holder::getRegisteredName).collect(Collectors.toList());
        if (!$$3.isEmpty()) {
            throw new IllegalStateException("Not all enchantments were registered for tooltip ordering. Missing: " + String.join((CharSequence)", ", $$3));
        }
    }
}

