/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.DebugBuffer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ChunkHolder {
    public static final ChunkResult<ChunkAccess> UNLOADED_CHUNK = ChunkResult.error("Unloaded chunk");
    public static final CompletableFuture<ChunkResult<ChunkAccess>> UNLOADED_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK);
    public static final ChunkResult<LevelChunk> UNLOADED_LEVEL_CHUNK = ChunkResult.error("Unloaded level chunk");
    public static final ChunkResult<ChunkAccess> NOT_DONE_YET = ChunkResult.error("Not done yet");
    private static final CompletableFuture<ChunkResult<LevelChunk>> UNLOADED_LEVEL_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_LEVEL_CHUNK);
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private final AtomicReferenceArray<CompletableFuture<ChunkResult<ChunkAccess>>> futures = new AtomicReferenceArray(CHUNK_STATUSES.size());
    private final LevelHeightAccessor levelHeightAccessor;
    private volatile CompletableFuture<ChunkResult<LevelChunk>> fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<ChunkResult<LevelChunk>> tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private volatile CompletableFuture<ChunkResult<LevelChunk>> entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
    private CompletableFuture<ChunkAccess> chunkToSave = CompletableFuture.completedFuture(null);
    @Nullable
    private final DebugBuffer<ChunkSaveDebug> chunkToSaveHistory = null;
    private int oldTicketLevel;
    private int ticketLevel;
    private int queueLevel;
    private final ChunkPos pos;
    private boolean hasChangedSections;
    private final ShortSet[] changedBlocksPerSection;
    private final BitSet blockChangedLightSectionFilter = new BitSet();
    private final BitSet skyChangedLightSectionFilter = new BitSet();
    private final LevelLightEngine lightEngine;
    private final LevelChangeListener onLevelChange;
    private final PlayerProvider playerProvider;
    private boolean wasAccessibleSinceLastSave;
    private CompletableFuture<Void> pendingFullStateConfirmation = CompletableFuture.completedFuture(null);
    private CompletableFuture<?> sendSync = CompletableFuture.completedFuture(null);

    public ChunkHolder(ChunkPos $$0, int $$1, LevelHeightAccessor $$2, LevelLightEngine $$3, LevelChangeListener $$4, PlayerProvider $$5) {
        this.pos = $$0;
        this.levelHeightAccessor = $$2;
        this.lightEngine = $$3;
        this.onLevelChange = $$4;
        this.playerProvider = $$5;
        this.ticketLevel = this.oldTicketLevel = ChunkLevel.MAX_LEVEL + 1;
        this.queueLevel = this.oldTicketLevel;
        this.setTicketLevel($$1);
        this.changedBlocksPerSection = new ShortSet[$$2.getSectionsCount()];
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getFutureIfPresentUnchecked(ChunkStatus $$0) {
        CompletableFuture<ChunkResult<ChunkAccess>> $$1 = this.futures.get($$0.getIndex());
        return $$1 == null ? UNLOADED_CHUNK_FUTURE : $$1;
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getFutureIfPresent(ChunkStatus $$0) {
        if (ChunkLevel.generationStatus(this.ticketLevel).isOrAfter($$0)) {
            return this.getFutureIfPresentUnchecked($$0);
        }
        return UNLOADED_CHUNK_FUTURE;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getTickingChunkFuture() {
        return this.tickingChunkFuture;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getEntityTickingChunkFuture() {
        return this.entityTickingChunkFuture;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> getFullChunkFuture() {
        return this.fullChunkFuture;
    }

    @Nullable
    public LevelChunk getTickingChunk() {
        return this.getTickingChunkFuture().getNow(UNLOADED_LEVEL_CHUNK).orElse(null);
    }

    public CompletableFuture<?> getChunkSendSyncFuture() {
        return this.sendSync;
    }

    @Nullable
    public LevelChunk getChunkToSend() {
        if (!this.sendSync.isDone()) {
            return null;
        }
        return this.getTickingChunk();
    }

    @Nullable
    public ChunkStatus getLastAvailableStatus() {
        for (int $$0 = CHUNK_STATUSES.size() - 1; $$0 >= 0; --$$0) {
            ChunkStatus $$1 = CHUNK_STATUSES.get($$0);
            CompletableFuture<ChunkResult<ChunkAccess>> $$2 = this.getFutureIfPresentUnchecked($$1);
            if (!$$2.getNow(UNLOADED_CHUNK).isSuccess()) continue;
            return $$1;
        }
        return null;
    }

    @Nullable
    public ChunkAccess getLastAvailable() {
        for (int $$0 = CHUNK_STATUSES.size() - 1; $$0 >= 0; --$$0) {
            ChunkAccess $$3;
            ChunkStatus $$1 = CHUNK_STATUSES.get($$0);
            CompletableFuture<ChunkResult<ChunkAccess>> $$2 = this.getFutureIfPresentUnchecked($$1);
            if ($$2.isCompletedExceptionally() || ($$3 = (ChunkAccess)$$2.getNow(UNLOADED_CHUNK).orElse(null)) == null) continue;
            return $$3;
        }
        return null;
    }

    public CompletableFuture<ChunkAccess> getChunkToSave() {
        return this.chunkToSave;
    }

    public void blockChanged(BlockPos $$0) {
        LevelChunk $$1 = this.getTickingChunk();
        if ($$1 == null) {
            return;
        }
        int $$2 = this.levelHeightAccessor.getSectionIndex($$0.getY());
        if (this.changedBlocksPerSection[$$2] == null) {
            this.hasChangedSections = true;
            this.changedBlocksPerSection[$$2] = new ShortOpenHashSet();
        }
        this.changedBlocksPerSection[$$2].add(SectionPos.sectionRelativePos($$0));
    }

    public void sectionLightChanged(LightLayer $$0, int $$1) {
        ChunkAccess $$2 = this.getFutureIfPresent(ChunkStatus.INITIALIZE_LIGHT).getNow(UNLOADED_CHUNK).orElse(null);
        if ($$2 == null) {
            return;
        }
        $$2.setUnsaved(true);
        LevelChunk $$3 = this.getTickingChunk();
        if ($$3 == null) {
            return;
        }
        int $$4 = this.lightEngine.getMinLightSection();
        int $$5 = this.lightEngine.getMaxLightSection();
        if ($$1 < $$4 || $$1 > $$5) {
            return;
        }
        int $$6 = $$1 - $$4;
        if ($$0 == LightLayer.SKY) {
            this.skyChangedLightSectionFilter.set($$6);
        } else {
            this.blockChangedLightSectionFilter.set($$6);
        }
    }

    public void broadcastChanges(LevelChunk $$0) {
        if (!this.hasChangedSections && this.skyChangedLightSectionFilter.isEmpty() && this.blockChangedLightSectionFilter.isEmpty()) {
            return;
        }
        Level $$1 = $$0.getLevel();
        if (!this.skyChangedLightSectionFilter.isEmpty() || !this.blockChangedLightSectionFilter.isEmpty()) {
            List<ServerPlayer> $$22 = this.playerProvider.getPlayers(this.pos, true);
            if (!$$22.isEmpty()) {
                ClientboundLightUpdatePacket $$32 = new ClientboundLightUpdatePacket($$0.getPos(), this.lightEngine, this.skyChangedLightSectionFilter, this.blockChangedLightSectionFilter);
                this.broadcast($$22, $$32);
            }
            this.skyChangedLightSectionFilter.clear();
            this.blockChangedLightSectionFilter.clear();
        }
        if (!this.hasChangedSections) {
            return;
        }
        List<ServerPlayer> $$4 = this.playerProvider.getPlayers(this.pos, false);
        for (int $$5 = 0; $$5 < this.changedBlocksPerSection.length; ++$$5) {
            ShortSet $$6 = this.changedBlocksPerSection[$$5];
            if ($$6 == null) continue;
            this.changedBlocksPerSection[$$5] = null;
            if ($$4.isEmpty()) continue;
            int $$7 = this.levelHeightAccessor.getSectionYFromSectionIndex($$5);
            SectionPos $$8 = SectionPos.of($$0.getPos(), $$7);
            if ($$6.size() == 1) {
                BlockPos $$9 = $$8.relativeToBlockPos($$6.iterator().nextShort());
                BlockState $$10 = $$1.getBlockState($$9);
                this.broadcast($$4, new ClientboundBlockUpdatePacket($$9, $$10));
                this.broadcastBlockEntityIfNeeded($$4, $$1, $$9, $$10);
                continue;
            }
            LevelChunkSection $$11 = $$0.getSection($$5);
            ClientboundSectionBlocksUpdatePacket $$12 = new ClientboundSectionBlocksUpdatePacket($$8, $$6, $$11);
            this.broadcast($$4, $$12);
            $$12.runUpdates(($$2, $$3) -> this.broadcastBlockEntityIfNeeded($$4, $$1, (BlockPos)$$2, (BlockState)$$3));
        }
        this.hasChangedSections = false;
    }

    private void broadcastBlockEntityIfNeeded(List<ServerPlayer> $$0, Level $$1, BlockPos $$2, BlockState $$3) {
        if ($$3.hasBlockEntity()) {
            this.broadcastBlockEntity($$0, $$1, $$2);
        }
    }

    private void broadcastBlockEntity(List<ServerPlayer> $$0, Level $$1, BlockPos $$2) {
        Packet<ClientGamePacketListener> $$4;
        BlockEntity $$3 = $$1.getBlockEntity($$2);
        if ($$3 != null && ($$4 = $$3.getUpdatePacket()) != null) {
            this.broadcast($$0, $$4);
        }
    }

    private void broadcast(List<ServerPlayer> $$0, Packet<?> $$12) {
        $$0.forEach($$1 -> $$1.connection.send($$12));
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getOrScheduleFuture(ChunkStatus $$0, ChunkMap $$1) {
        int $$2 = $$0.getIndex();
        CompletableFuture<ChunkResult<ChunkAccess>> $$3 = this.futures.get($$2);
        if ($$3 != null) {
            ChunkResult<ChunkAccess> $$4 = $$3.getNow(NOT_DONE_YET);
            if ($$4 == null) {
                String $$5 = "value in future for status: " + String.valueOf($$0) + " was incorrectly set to null at chunk: " + String.valueOf(this.pos);
                throw $$1.debugFuturesAndCreateReportedException(new IllegalStateException("null value previously set for chunk status"), $$5);
            }
            if ($$4 == NOT_DONE_YET || $$4.isSuccess()) {
                return $$3;
            }
        }
        if (ChunkLevel.generationStatus(this.ticketLevel).isOrAfter($$0)) {
            CompletableFuture<ChunkResult<ChunkAccess>> $$6 = $$1.schedule(this, $$0);
            this.updateChunkToSave($$6, "schedule " + String.valueOf($$0));
            this.futures.set($$2, $$6);
            return $$6;
        }
        return $$3 == null ? UNLOADED_CHUNK_FUTURE : $$3;
    }

    protected void addSaveDependency(String $$02, CompletableFuture<?> $$12) {
        if (this.chunkToSaveHistory != null) {
            this.chunkToSaveHistory.push(new ChunkSaveDebug(Thread.currentThread(), $$12, $$02));
        }
        this.chunkToSave = this.chunkToSave.thenCombine($$12, ($$0, $$1) -> $$0);
    }

    private void updateChunkToSave(CompletableFuture<? extends ChunkResult<? extends ChunkAccess>> $$02, String $$12) {
        if (this.chunkToSaveHistory != null) {
            this.chunkToSaveHistory.push(new ChunkSaveDebug(Thread.currentThread(), $$02, $$12));
        }
        this.chunkToSave = this.chunkToSave.thenCombine($$02, ($$0, $$1) -> ChunkResult.orElse($$1, $$0));
    }

    public void addSendDependency(CompletableFuture<?> $$02) {
        this.sendSync = this.sendSync.isDone() ? $$02 : this.sendSync.thenCombine($$02, ($$0, $$1) -> null);
    }

    public FullChunkStatus getFullStatus() {
        return ChunkLevel.fullStatus(this.ticketLevel);
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public int getTicketLevel() {
        return this.ticketLevel;
    }

    public int getQueueLevel() {
        return this.queueLevel;
    }

    private void setQueueLevel(int $$0) {
        this.queueLevel = $$0;
    }

    public void setTicketLevel(int $$0) {
        this.ticketLevel = $$0;
    }

    private void scheduleFullChunkPromotion(ChunkMap $$0, CompletableFuture<ChunkResult<LevelChunk>> $$1, Executor $$2, FullChunkStatus $$3) {
        this.pendingFullStateConfirmation.cancel(false);
        CompletableFuture $$4 = new CompletableFuture();
        $$4.thenRunAsync(() -> $$0.onFullChunkStatusChange(this.pos, $$3), $$2);
        this.pendingFullStateConfirmation = $$4;
        $$1.thenAccept($$12 -> $$12.ifSuccess($$1 -> $$4.complete(null)));
    }

    private void demoteFullChunk(ChunkMap $$0, FullChunkStatus $$1) {
        this.pendingFullStateConfirmation.cancel(false);
        $$0.onFullChunkStatusChange(this.pos, $$1);
    }

    protected void updateFutures(ChunkMap $$0, Executor $$1) {
        ChunkStatus $$2 = ChunkLevel.generationStatus(this.oldTicketLevel);
        ChunkStatus $$3 = ChunkLevel.generationStatus(this.ticketLevel);
        boolean $$4 = ChunkLevel.isLoaded(this.oldTicketLevel);
        boolean $$5 = ChunkLevel.isLoaded(this.ticketLevel);
        FullChunkStatus $$6 = ChunkLevel.fullStatus(this.oldTicketLevel);
        FullChunkStatus $$7 = ChunkLevel.fullStatus(this.ticketLevel);
        if ($$4) {
            int $$9;
            ChunkResult $$8 = ChunkResult.error(() -> "Unloaded ticket level " + String.valueOf(this.pos));
            int n = $$9 = $$5 ? $$3.getIndex() + 1 : 0;
            while ($$9 <= $$2.getIndex()) {
                CompletableFuture<ChunkResult<ChunkAccess>> $$10 = this.futures.get($$9);
                if ($$10 == null) {
                    this.futures.set($$9, CompletableFuture.completedFuture($$8));
                }
                ++$$9;
            }
        }
        boolean $$11 = $$6.isOrAfter(FullChunkStatus.FULL);
        boolean $$12 = $$7.isOrAfter(FullChunkStatus.FULL);
        this.wasAccessibleSinceLastSave |= $$12;
        if (!$$11 && $$12) {
            this.fullChunkFuture = $$0.prepareAccessibleChunk(this);
            this.scheduleFullChunkPromotion($$0, this.fullChunkFuture, $$1, FullChunkStatus.FULL);
            this.updateChunkToSave(this.fullChunkFuture, "full");
        }
        if ($$11 && !$$12) {
            this.fullChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.fullChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean $$13 = $$6.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        boolean $$14 = $$7.isOrAfter(FullChunkStatus.BLOCK_TICKING);
        if (!$$13 && $$14) {
            this.tickingChunkFuture = $$0.prepareTickingChunk(this);
            this.scheduleFullChunkPromotion($$0, this.tickingChunkFuture, $$1, FullChunkStatus.BLOCK_TICKING);
            this.updateChunkToSave(this.tickingChunkFuture, "ticking");
        }
        if ($$13 && !$$14) {
            this.tickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.tickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        boolean $$15 = $$6.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        boolean $$16 = $$7.isOrAfter(FullChunkStatus.ENTITY_TICKING);
        if (!$$15 && $$16) {
            if (this.entityTickingChunkFuture != UNLOADED_LEVEL_CHUNK_FUTURE) {
                throw Util.pauseInIde(new IllegalStateException());
            }
            this.entityTickingChunkFuture = $$0.prepareEntityTickingChunk(this);
            this.scheduleFullChunkPromotion($$0, this.entityTickingChunkFuture, $$1, FullChunkStatus.ENTITY_TICKING);
            this.updateChunkToSave(this.entityTickingChunkFuture, "entity ticking");
        }
        if ($$15 && !$$16) {
            this.entityTickingChunkFuture.complete(UNLOADED_LEVEL_CHUNK);
            this.entityTickingChunkFuture = UNLOADED_LEVEL_CHUNK_FUTURE;
        }
        if (!$$7.isOrAfter($$6)) {
            this.demoteFullChunk($$0, $$7);
        }
        this.onLevelChange.onLevelChange(this.pos, this::getQueueLevel, this.ticketLevel, this::setQueueLevel);
        this.oldTicketLevel = this.ticketLevel;
    }

    public boolean wasAccessibleSinceLastSave() {
        return this.wasAccessibleSinceLastSave;
    }

    public void refreshAccessibility() {
        this.wasAccessibleSinceLastSave = ChunkLevel.fullStatus(this.ticketLevel).isOrAfter(FullChunkStatus.FULL);
    }

    public void replaceProtoChunk(ImposterProtoChunk $$0) {
        for (int $$1 = 0; $$1 < this.futures.length(); ++$$1) {
            ChunkAccess $$3;
            CompletableFuture<ChunkResult<ChunkAccess>> $$2 = this.futures.get($$1);
            if ($$2 == null || !(($$3 = (ChunkAccess)$$2.getNow(UNLOADED_CHUNK).orElse(null)) instanceof ProtoChunk)) continue;
            this.futures.set($$1, CompletableFuture.completedFuture(ChunkResult.of($$0)));
        }
        this.updateChunkToSave(CompletableFuture.completedFuture(ChunkResult.of($$0.getWrapped())), "replaceProto");
    }

    public List<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>> getAllFutures() {
        ArrayList<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>> $$0 = new ArrayList<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>>();
        for (int $$1 = 0; $$1 < CHUNK_STATUSES.size(); ++$$1) {
            $$0.add((Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>)Pair.of((Object)CHUNK_STATUSES.get($$1), this.futures.get($$1)));
        }
        return $$0;
    }

    @FunctionalInterface
    public static interface LevelChangeListener {
        public void onLevelChange(ChunkPos var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface PlayerProvider {
        public List<ServerPlayer> getPlayers(ChunkPos var1, boolean var2);
    }

    record ChunkSaveDebug(Thread thread, CompletableFuture<?> future, String source) {
    }
}

