/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class ChunkMap
extends ChunkStorage
implements ChunkHolder.PlayerProvider {
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int FORCED_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> updatingChunkMap = new Long2ObjectLinkedOpenHashMap();
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> visibleChunkMap = this.updatingChunkMap.clone();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> pendingUnloads = new Long2ObjectLinkedOpenHashMap();
    private final LongSet entitiesInLevel = new LongOpenHashSet();
    final ServerLevel level;
    private final ThreadedLevelLightEngine lightEngine;
    private final BlockableEventLoop<Runnable> mainThreadExecutor;
    private ChunkGenerator generator;
    private final RandomState randomState;
    private final ChunkGeneratorStructureState chunkGeneratorState;
    private final Supplier<DimensionDataStorage> overworldDataStorage;
    private final PoiManager poiManager;
    final LongSet toDrop = new LongOpenHashSet();
    private boolean modified;
    private final ChunkTaskPriorityQueueSorter queueSorter;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> worldgenMailbox;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> mainThreadMailbox;
    private final ChunkProgressListener progressListener;
    private final ChunkStatusUpdateListener chunkStatusListener;
    private final DistanceManager distanceManager;
    private final AtomicInteger tickingGenerated = new AtomicInteger();
    private final String storageName;
    private final PlayerMap playerMap = new PlayerMap();
    private final Int2ObjectMap<TrackedEntity> entityMap = new Int2ObjectOpenHashMap();
    private final Long2ByteMap chunkTypeCache = new Long2ByteOpenHashMap();
    private final Long2LongMap chunkSaveCooldowns = new Long2LongOpenHashMap();
    private final Queue<Runnable> unloadQueue = Queues.newConcurrentLinkedQueue();
    private int serverViewDistance;
    private WorldGenContext worldGenContext;

    public ChunkMap(ServerLevel $$0, LevelStorageSource.LevelStorageAccess $$1, DataFixer $$2, StructureTemplateManager $$3, Executor $$4, BlockableEventLoop<Runnable> $$5, LightChunkGetter $$6, ChunkGenerator $$7, ChunkProgressListener $$8, ChunkStatusUpdateListener $$9, Supplier<DimensionDataStorage> $$10, int $$11, boolean $$12) {
        super(new RegionStorageInfo($$1.getLevelId(), $$0.dimension(), "chunk"), $$1.getDimensionPath($$0.dimension()).resolve("region"), $$2, $$12);
        Path $$13 = $$1.getDimensionPath($$0.dimension());
        this.storageName = $$13.getFileName().toString();
        this.level = $$0;
        this.generator = $$7;
        RegistryAccess $$14 = $$0.registryAccess();
        long $$15 = $$0.getSeed();
        if ($$7 instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator $$16 = (NoiseBasedChunkGenerator)$$7;
            this.randomState = RandomState.create($$16.generatorSettings().value(), $$14.lookupOrThrow(Registries.NOISE), $$15);
        } else {
            this.randomState = RandomState.create(NoiseGeneratorSettings.dummy(), $$14.lookupOrThrow(Registries.NOISE), $$15);
        }
        this.chunkGeneratorState = $$7.createState($$14.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, $$15);
        this.mainThreadExecutor = $$5;
        ProcessorMailbox<Runnable> $$17 = ProcessorMailbox.create($$4, "worldgen");
        ProcessorHandle<Runnable> $$18 = ProcessorHandle.of("main", $$5::tell);
        this.progressListener = $$8;
        this.chunkStatusListener = $$9;
        ProcessorMailbox<Runnable> $$19 = ProcessorMailbox.create($$4, "light");
        this.queueSorter = new ChunkTaskPriorityQueueSorter((List<ProcessorHandle<?>>)ImmutableList.of($$17, $$18, $$19), $$4, Integer.MAX_VALUE);
        this.worldgenMailbox = this.queueSorter.getProcessor($$17, false);
        this.mainThreadMailbox = this.queueSorter.getProcessor($$18, false);
        this.lightEngine = new ThreadedLevelLightEngine($$6, this, this.level.dimensionType().hasSkyLight(), $$19, this.queueSorter.getProcessor($$19, false));
        this.distanceManager = new DistanceManager($$4, $$5);
        this.overworldDataStorage = $$10;
        this.poiManager = new PoiManager(new RegionStorageInfo($$1.getLevelId(), $$0.dimension(), "poi"), $$13.resolve("poi"), $$2, $$12, $$14, $$0);
        this.setServerViewDistance($$11);
        this.worldGenContext = new WorldGenContext($$0, $$7, $$3, this.lightEngine);
    }

    protected ChunkGenerator generator() {
        return this.generator;
    }

    protected ChunkGeneratorStructureState generatorState() {
        return this.chunkGeneratorState;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    public void debugReloadGenerator() {
        DataResult $$02 = ChunkGenerator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.generator);
        DataResult $$1 = $$02.flatMap($$0 -> ChunkGenerator.CODEC.parse((DynamicOps)JsonOps.INSTANCE, $$0));
        $$1.ifSuccess($$0 -> {
            this.generator = $$0;
            this.worldGenContext = new WorldGenContext(this.worldGenContext.level(), (ChunkGenerator)$$0, this.worldGenContext.structureManager(), this.worldGenContext.lightEngine());
        });
    }

    private static double euclideanDistanceSquared(ChunkPos $$0, Entity $$1) {
        double $$2 = SectionPos.sectionToBlockCoord($$0.x, 8);
        double $$3 = SectionPos.sectionToBlockCoord($$0.z, 8);
        double $$4 = $$2 - $$1.getX();
        double $$5 = $$3 - $$1.getZ();
        return $$4 * $$4 + $$5 * $$5;
    }

    boolean isChunkTracked(ServerPlayer $$0, int $$1, int $$2) {
        return $$0.getChunkTrackingView().contains($$1, $$2) && !$$0.connection.chunkSender.isPending(ChunkPos.asLong($$1, $$2));
    }

    private boolean isChunkOnTrackedBorder(ServerPlayer $$0, int $$1, int $$2) {
        if (!this.isChunkTracked($$0, $$1, $$2)) {
            return false;
        }
        for (int $$3 = -1; $$3 <= 1; ++$$3) {
            for (int $$4 = -1; $$4 <= 1; ++$$4) {
                if ($$3 == 0 && $$4 == 0 || this.isChunkTracked($$0, $$1 + $$3, $$2 + $$4)) continue;
                return true;
            }
        }
        return false;
    }

    protected ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    protected ChunkHolder getUpdatingChunkIfPresent(long $$0) {
        return (ChunkHolder)this.updatingChunkMap.get($$0);
    }

    @Nullable
    protected ChunkHolder getVisibleChunkIfPresent(long $$0) {
        return (ChunkHolder)this.visibleChunkMap.get($$0);
    }

    protected IntSupplier getChunkQueueLevel(long $$0) {
        return () -> {
            ChunkHolder $$1 = this.getVisibleChunkIfPresent($$0);
            if ($$1 == null) {
                return ChunkTaskPriorityQueue.PRIORITY_LEVEL_COUNT - 1;
            }
            return Math.min($$1.getQueueLevel(), ChunkTaskPriorityQueue.PRIORITY_LEVEL_COUNT - 1);
        };
    }

    public String getChunkDebugData(ChunkPos $$0) {
        ChunkHolder $$1 = this.getVisibleChunkIfPresent($$0.toLong());
        if ($$1 == null) {
            return "null";
        }
        String $$2 = $$1.getTicketLevel() + "\n";
        ChunkStatus $$3 = $$1.getLastAvailableStatus();
        ChunkAccess $$4 = $$1.getLastAvailable();
        if ($$3 != null) {
            $$2 = $$2 + "St: \u00a7" + $$3.getIndex() + String.valueOf($$3) + "\u00a7r\n";
        }
        if ($$4 != null) {
            $$2 = $$2 + "Ch: \u00a7" + $$4.getStatus().getIndex() + String.valueOf($$4.getStatus()) + "\u00a7r\n";
        }
        FullChunkStatus $$5 = $$1.getFullStatus();
        $$2 = $$2 + String.valueOf('\u00a7') + $$5.ordinal() + String.valueOf((Object)$$5);
        return $$2 + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<ChunkAccess>>> getChunkRangeFuture(ChunkHolder $$02, int $$1, IntFunction<ChunkStatus> $$2) {
        if ($$1 == 0) {
            ChunkStatus $$32 = $$2.apply(0);
            return $$02.getOrScheduleFuture($$32, this).thenApply($$0 -> $$0.map(List::of));
        }
        ArrayList<CompletableFuture<ChunkResult<ChunkAccess>>> $$4 = new ArrayList<CompletableFuture<ChunkResult<ChunkAccess>>>();
        ArrayList<ChunkHolder> $$5 = new ArrayList<ChunkHolder>();
        ChunkPos $$6 = $$02.getPos();
        int $$7 = $$6.x;
        int $$8 = $$6.z;
        for (int $$9 = -$$1; $$9 <= $$1; ++$$9) {
            for (int $$10 = -$$1; $$10 <= $$1; ++$$10) {
                int $$11 = Math.max(Math.abs($$10), Math.abs($$9));
                ChunkPos $$12 = new ChunkPos($$7 + $$10, $$8 + $$9);
                long $$13 = $$12.toLong();
                ChunkHolder $$14 = this.getUpdatingChunkIfPresent($$13);
                if ($$14 == null) {
                    return CompletableFuture.completedFuture(ChunkResult.error(() -> "Unloaded " + String.valueOf($$12)));
                }
                ChunkStatus $$15 = $$2.apply($$11);
                CompletableFuture<ChunkResult<ChunkAccess>> $$16 = $$14.getOrScheduleFuture($$15, this);
                $$5.add($$14);
                $$4.add($$16);
            }
        }
        CompletableFuture $$17 = Util.sequence($$4);
        CompletionStage $$18 = $$17.thenApply($$3 -> {
            ArrayList $$4 = Lists.newArrayList();
            int $$5 = 0;
            for (ChunkResult $$6 : $$3) {
                if ($$6 == null) {
                    throw this.debugFuturesAndCreateReportedException(new IllegalStateException("At least one of the chunk futures were null"), "n/a");
                }
                ChunkAccess $$7 = $$6.orElse(null);
                if ($$7 == null) {
                    int $$8 = $$5;
                    return ChunkResult.error(() -> "Unloaded " + String.valueOf(new ChunkPos($$7 + $$8 % ($$1 * 2 + 1), $$8 + $$8 / ($$1 * 2 + 1))) + " " + $$6.getError());
                }
                $$4.add($$7);
                ++$$5;
            }
            return ChunkResult.of($$4);
        });
        for (ChunkHolder $$19 : $$5) {
            $$19.addSaveDependency("getChunkRangeFuture " + String.valueOf($$6) + " " + $$1, (CompletableFuture<?>)$$18);
        }
        return $$18;
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException $$0, String $$12) {
        StringBuilder $$2 = new StringBuilder();
        Consumer<ChunkHolder> $$3 = $$1 -> $$1.getAllFutures().forEach($$2 -> {
            ChunkStatus $$3 = (ChunkStatus)$$2.getFirst();
            CompletableFuture $$4 = (CompletableFuture)$$2.getSecond();
            if ($$4 != null && $$4.isDone() && $$4.join() == null) {
                $$2.append($$1.getPos()).append(" - status: ").append($$3).append(" future: ").append($$4).append(System.lineSeparator());
            }
        });
        $$2.append("Updating:").append(System.lineSeparator());
        this.updatingChunkMap.values().forEach($$3);
        $$2.append("Visible:").append(System.lineSeparator());
        this.visibleChunkMap.values().forEach($$3);
        CrashReport $$4 = CrashReport.forThrowable($$0, "Chunk loading");
        CrashReportCategory $$5 = $$4.addCategory("Chunk loading");
        $$5.setDetail("Details", $$12);
        $$5.setDetail("Futures", $$2);
        return new ReportedException($$4);
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareEntityTickingChunk(ChunkHolder $$03) {
        return this.getChunkRangeFuture($$03, 2, $$0 -> ChunkStatus.FULL).thenApplyAsync($$02 -> $$02.map($$0 -> (LevelChunk)$$0.get($$0.size() / 2)), (Executor)this.mainThreadExecutor);
    }

    @Nullable
    ChunkHolder updateChunkScheduling(long $$0, int $$1, @Nullable ChunkHolder $$2, int $$3) {
        if (!ChunkLevel.isLoaded($$3) && !ChunkLevel.isLoaded($$1)) {
            return $$2;
        }
        if ($$2 != null) {
            $$2.setTicketLevel($$1);
        }
        if ($$2 != null) {
            if (!ChunkLevel.isLoaded($$1)) {
                this.toDrop.add($$0);
            } else {
                this.toDrop.remove($$0);
            }
        }
        if (ChunkLevel.isLoaded($$1) && $$2 == null) {
            $$2 = (ChunkHolder)this.pendingUnloads.remove($$0);
            if ($$2 != null) {
                $$2.setTicketLevel($$1);
            } else {
                $$2 = new ChunkHolder(new ChunkPos($$0), $$1, this.level, this.lightEngine, this.queueSorter, this);
            }
            this.updatingChunkMap.put($$0, (Object)$$2);
            this.modified = true;
        }
        return $$2;
    }

    @Override
    public void close() throws IOException {
        try {
            this.queueSorter.close();
            this.poiManager.close();
        }
        finally {
            super.close();
        }
    }

    protected void saveAllChunks(boolean $$02) {
        if ($$02) {
            List<ChunkHolder> $$12 = this.visibleChunkMap.values().stream().filter(ChunkHolder::wasAccessibleSinceLastSave).peek(ChunkHolder::refreshAccessibility).toList();
            MutableBoolean $$2 = new MutableBoolean();
            do {
                $$2.setFalse();
                $$12.stream().map($$0 -> {
                    CompletableFuture<ChunkAccess> $$1;
                    do {
                        $$1 = $$0.getChunkToSave();
                        this.mainThreadExecutor.managedBlock($$1::isDone);
                    } while ($$1 != $$0.getChunkToSave());
                    return $$1.join();
                }).filter($$0 -> $$0 instanceof ImposterProtoChunk || $$0 instanceof LevelChunk).filter(this::save).forEach($$1 -> $$2.setTrue());
            } while ($$2.isTrue());
            this.processUnloads(() -> true);
            this.flushWorker();
        } else {
            this.visibleChunkMap.values().forEach(this::saveChunkIfNeeded);
        }
    }

    protected void tick(BooleanSupplier $$0) {
        ProfilerFiller $$1 = this.level.getProfiler();
        $$1.push("poi");
        this.poiManager.tick($$0);
        $$1.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads($$0);
        }
        $$1.pop();
    }

    public boolean hasWork() {
        return this.lightEngine.hasLightWork() || !this.pendingUnloads.isEmpty() || !this.updatingChunkMap.isEmpty() || this.poiManager.hasWork() || !this.toDrop.isEmpty() || !this.unloadQueue.isEmpty() || this.queueSorter.hasWork() || this.distanceManager.hasTickets();
    }

    private void processUnloads(BooleanSupplier $$0) {
        Runnable $$6;
        LongIterator $$1 = this.toDrop.iterator();
        int $$2 = 0;
        while ($$1.hasNext() && ($$0.getAsBoolean() || $$2 < 200 || this.toDrop.size() > 2000)) {
            long $$3 = $$1.nextLong();
            ChunkHolder $$4 = (ChunkHolder)this.updatingChunkMap.remove($$3);
            if ($$4 != null) {
                this.pendingUnloads.put($$3, (Object)$$4);
                this.modified = true;
                ++$$2;
                this.scheduleUnload($$3, $$4);
            }
            $$1.remove();
        }
        for (int $$5 = Math.max(0, this.unloadQueue.size() - 2000); ($$0.getAsBoolean() || $$5 > 0) && ($$6 = this.unloadQueue.poll()) != null; --$$5) {
            $$6.run();
        }
        int $$7 = 0;
        ObjectIterator $$8 = this.visibleChunkMap.values().iterator();
        while ($$7 < 20 && $$0.getAsBoolean() && $$8.hasNext()) {
            if (!this.saveChunkIfNeeded((ChunkHolder)$$8.next())) continue;
            ++$$7;
        }
    }

    private void scheduleUnload(long $$0, ChunkHolder $$12) {
        CompletableFuture<ChunkAccess> $$22 = $$12.getChunkToSave();
        ((CompletableFuture)$$22.thenAcceptAsync($$3 -> {
            CompletableFuture<ChunkAccess> $$4 = $$12.getChunkToSave();
            if ($$4 != $$22) {
                this.scheduleUnload($$0, $$12);
                return;
            }
            if (this.pendingUnloads.remove($$0, (Object)$$12) && $$3 != null) {
                if ($$3 instanceof LevelChunk) {
                    ((LevelChunk)$$3).setLoaded(false);
                }
                this.save((ChunkAccess)$$3);
                if (this.entitiesInLevel.remove($$0) && $$3 instanceof LevelChunk) {
                    LevelChunk $$5 = (LevelChunk)$$3;
                    this.level.unload($$5);
                }
                this.lightEngine.updateChunkStatus($$3.getPos());
                this.lightEngine.tryScheduleUpdate();
                this.progressListener.onStatusChange($$3.getPos(), null);
                this.chunkSaveCooldowns.remove($$3.getPos().toLong());
            }
        }, this.unloadQueue::add)).whenComplete(($$1, $$2) -> {
            if ($$2 != null) {
                LOGGER.error("Failed to save chunk {}", (Object)$$12.getPos(), $$2);
            }
        });
    }

    protected boolean promoteChunkMap() {
        if (!this.modified) {
            return false;
        }
        this.visibleChunkMap = this.updatingChunkMap.clone();
        this.modified = false;
        return true;
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> schedule(ChunkHolder $$0, ChunkStatus $$12) {
        ChunkAccess $$3;
        ChunkPos $$2 = $$0.getPos();
        if ($$12 == ChunkStatus.EMPTY) {
            return this.scheduleChunkLoad($$2).thenApply(ChunkResult::of);
        }
        if ($$12 == ChunkStatus.LIGHT) {
            this.distanceManager.addTicket(TicketType.LIGHT, $$2, ChunkLevel.byStatus(ChunkStatus.LIGHT), $$2);
        }
        if (!$$12.hasLoadDependencies() && ($$3 = (ChunkAccess)$$0.getOrScheduleFuture($$12.getParent(), this).getNow(ChunkHolder.UNLOADED_CHUNK).orElse(null)) != null && $$3.getStatus().isOrAfter($$12)) {
            CompletableFuture<ChunkAccess> $$4 = $$12.load(this.worldGenContext, $$1 -> this.protoChunkToFullChunk($$0, $$1), $$3);
            this.progressListener.onStatusChange($$2, $$12);
            return $$4.thenApply(ChunkResult::of);
        }
        return this.scheduleChunkGeneration($$0, $$12);
    }

    private CompletableFuture<ChunkAccess> scheduleChunkLoad(ChunkPos $$0) {
        return ((CompletableFuture)((CompletableFuture)this.readChunk($$0).thenApply($$12 -> $$12.filter($$1 -> {
            boolean $$2 = ChunkMap.isChunkDataValid($$1);
            if (!$$2) {
                LOGGER.error("Chunk file at {} is missing level data, skipping", (Object)$$0);
            }
            return $$2;
        }))).thenApplyAsync($$1 -> {
            this.level.getProfiler().incrementCounter("chunkLoad");
            if ($$1.isPresent()) {
                ProtoChunk $$2 = ChunkSerializer.read(this.level, this.poiManager, $$0, (CompoundTag)$$1.get());
                this.markPosition($$0, ((ChunkAccess)$$2).getStatus().getChunkType());
                return $$2;
            }
            return this.createEmptyChunk($$0);
        }, (Executor)this.mainThreadExecutor)).exceptionallyAsync($$1 -> this.handleChunkLoadFailure((Throwable)$$1, $$0), (Executor)this.mainThreadExecutor);
    }

    private static boolean isChunkDataValid(CompoundTag $$0) {
        return $$0.contains("Status", 8);
    }

    private ChunkAccess handleChunkLoadFailure(Throwable $$0, ChunkPos $$1) {
        boolean $$7;
        Throwable throwable;
        Throwable $$3;
        if ($$0 instanceof CompletionException) {
            CompletionException $$2 = (CompletionException)$$0;
            v0 = $$2.getCause();
        } else {
            v0 = $$3 = $$0;
        }
        if ($$3 instanceof ReportedException) {
            ReportedException $$4 = (ReportedException)$$3;
            throwable = $$4.getCause();
        } else {
            throwable = $$3;
        }
        Throwable $$5 = throwable;
        boolean $$6 = $$5 instanceof Error;
        boolean bl = $$7 = $$5 instanceof IOException || $$5 instanceof NbtException;
        if (!$$6) {
            if (!$$7) {
                // empty if block
            }
        } else {
            CrashReport $$8 = CrashReport.forThrowable($$0, "Exception loading chunk");
            CrashReportCategory $$9 = $$8.addCategory("Chunk being loaded");
            $$9.setDetail("pos", $$1);
            this.markPositionReplaceable($$1);
            throw new ReportedException($$8);
        }
        LOGGER.error("Couldn't load chunk {}", (Object)$$1, (Object)$$5);
        this.level.getServer().reportChunkLoadFailure($$1);
        return this.createEmptyChunk($$1);
    }

    private ChunkAccess createEmptyChunk(ChunkPos $$0) {
        this.markPositionReplaceable($$0);
        return new ProtoChunk($$0, UpgradeData.EMPTY, this.level, this.level.registryAccess().registryOrThrow(Registries.BIOME), null);
    }

    private void markPositionReplaceable(ChunkPos $$0) {
        this.chunkTypeCache.put($$0.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkPos $$0, ChunkType $$1) {
        return this.chunkTypeCache.put($$0.toLong(), $$1 == ChunkType.PROTOCHUNK ? (byte)-1 : 1);
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> scheduleChunkGeneration(ChunkHolder $$0, ChunkStatus $$12) {
        ChunkPos $$2 = $$0.getPos();
        CompletableFuture<ChunkResult<List<ChunkAccess>>> $$3 = this.getChunkRangeFuture($$0, $$12.getRange(), $$1 -> this.getDependencyStatus($$12, $$1));
        this.level.getProfiler().incrementCounter(() -> "chunkGenerate " + String.valueOf($$12));
        Executor $$42 = $$1 -> this.worldgenMailbox.tell(ChunkTaskPriorityQueueSorter.message($$0, $$1));
        return $$3.thenComposeAsync($$4 -> {
            List $$5 = $$4.orElse(null);
            if ($$5 == null) {
                this.releaseLightTicket($$2);
                return CompletableFuture.completedFuture(ChunkResult.error($$4::getError));
            }
            try {
                CompletableFuture<ChunkAccess> $$8;
                ChunkAccess $$6 = (ChunkAccess)$$5.get($$5.size() / 2);
                if ($$6.getStatus().isOrAfter($$12)) {
                    CompletableFuture<ChunkAccess> $$7 = $$12.load(this.worldGenContext, $$1 -> this.protoChunkToFullChunk($$0, $$1), $$6);
                } else {
                    $$8 = $$12.generate(this.worldGenContext, $$42, $$1 -> this.protoChunkToFullChunk($$0, $$1), $$5);
                }
                this.progressListener.onStatusChange($$2, $$12);
                return $$8.thenApply(ChunkResult::of);
            }
            catch (Exception $$9) {
                $$9.getStackTrace();
                CrashReport $$10 = CrashReport.forThrowable($$9, "Exception generating new chunk");
                CrashReportCategory $$11 = $$10.addCategory("Chunk to be generated");
                $$11.setDetail("Status being generated", () -> BuiltInRegistries.CHUNK_STATUS.getKey($$12).toString());
                $$11.setDetail("Location", String.format(Locale.ROOT, "%d,%d", $$0.x, $$0.z));
                $$11.setDetail("Position hash", ChunkPos.asLong($$0.x, $$0.z));
                $$11.setDetail("Generator", this.generator);
                this.mainThreadExecutor.execute(() -> {
                    throw new ReportedException($$10);
                });
                throw new ReportedException($$10);
            }
        }, $$42);
    }

    protected void releaseLightTicket(ChunkPos $$0) {
        this.mainThreadExecutor.tell(Util.name(() -> this.distanceManager.removeTicket(TicketType.LIGHT, $$0, ChunkLevel.byStatus(ChunkStatus.LIGHT), $$0), () -> "release light ticket " + String.valueOf($$0)));
    }

    private ChunkStatus getDependencyStatus(ChunkStatus $$0, int $$1) {
        ChunkStatus $$3;
        if ($$1 == 0) {
            ChunkStatus $$2 = $$0.getParent();
        } else {
            $$3 = ChunkStatus.getStatusAroundFullChunk(ChunkStatus.getDistance($$0) + $$1);
        }
        return $$3;
    }

    private static void postLoadProtoChunk(ServerLevel $$0, List<CompoundTag> $$1) {
        if (!$$1.isEmpty()) {
            $$0.addWorldGenChunkEntities(EntityType.loadEntitiesRecursive($$1, $$0));
        }
    }

    private CompletableFuture<ChunkAccess> protoChunkToFullChunk(ChunkHolder $$0, ChunkAccess $$12) {
        return CompletableFuture.supplyAsync(() -> {
            LevelChunk $$5;
            ChunkPos $$2 = $$0.getPos();
            ProtoChunk $$3 = (ProtoChunk)$$12;
            if ($$3 instanceof ImposterProtoChunk) {
                LevelChunk $$4 = ((ImposterProtoChunk)$$3).getWrapped();
            } else {
                $$5 = new LevelChunk(this.level, $$3, $$1 -> ChunkMap.postLoadProtoChunk(this.level, $$3.getEntities()));
                $$0.replaceProtoChunk(new ImposterProtoChunk($$5, false));
            }
            $$5.setFullStatus(() -> ChunkLevel.fullStatus($$0.getTicketLevel()));
            $$5.runPostLoad();
            if (this.entitiesInLevel.add($$2.toLong())) {
                $$5.setLoaded(true);
                $$5.registerAllBlockEntitiesAfterLevelLoad();
                $$5.registerTickContainerInLevel(this.level);
            }
            return $$5;
        }, $$1 -> this.mainThreadMailbox.tell(ChunkTaskPriorityQueueSorter.message($$1, $$0.getPos().toLong(), $$0::getTicketLevel)));
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareTickingChunk(ChunkHolder $$03) {
        CompletableFuture<ChunkResult<List<ChunkAccess>>> $$12 = this.getChunkRangeFuture($$03, 1, $$0 -> ChunkStatus.FULL);
        CompletionStage $$2 = ((CompletableFuture)$$12.thenApplyAsync($$02 -> $$02.map($$0 -> (LevelChunk)$$0.get($$0.size() / 2)), $$1 -> this.mainThreadMailbox.tell(ChunkTaskPriorityQueueSorter.message($$03, $$1)))).thenApplyAsync($$1 -> $$1.ifSuccess($$12 -> {
            $$12.postProcessGeneration();
            this.level.startTickingChunk((LevelChunk)$$12);
            CompletableFuture<?> $$2 = $$03.getChunkSendSyncFuture();
            if ($$2.isDone()) {
                this.onChunkReadyToSend((LevelChunk)$$12);
            } else {
                $$2.thenAcceptAsync($$1 -> this.onChunkReadyToSend((LevelChunk)$$12), (Executor)this.mainThreadExecutor);
            }
        }), (Executor)this.mainThreadExecutor);
        ((CompletableFuture)$$2).handle(($$0, $$1) -> {
            this.tickingGenerated.getAndIncrement();
            return null;
        });
        return $$2;
    }

    private void onChunkReadyToSend(LevelChunk $$0) {
        ChunkPos $$1 = $$0.getPos();
        for (ServerPlayer $$2 : this.playerMap.getAllPlayers()) {
            if (!$$2.getChunkTrackingView().contains($$1)) continue;
            ChunkMap.markChunkPendingToSend($$2, $$0);
        }
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareAccessibleChunk(ChunkHolder $$0) {
        return this.getChunkRangeFuture($$0, 1, ChunkStatus::getStatusAroundFullChunk).thenApplyAsync($$02 -> $$02.map($$0 -> (LevelChunk)$$0.get($$0.size() / 2)), $$1 -> this.mainThreadMailbox.tell(ChunkTaskPriorityQueueSorter.message($$0, $$1)));
    }

    public int getTickingGenerated() {
        return this.tickingGenerated.get();
    }

    private boolean saveChunkIfNeeded(ChunkHolder $$0) {
        if (!$$0.wasAccessibleSinceLastSave()) {
            return false;
        }
        ChunkAccess $$1 = $$0.getChunkToSave().getNow(null);
        if ($$1 instanceof ImposterProtoChunk || $$1 instanceof LevelChunk) {
            long $$2 = $$1.getPos().toLong();
            long $$3 = this.chunkSaveCooldowns.getOrDefault($$2, -1L);
            long $$4 = System.currentTimeMillis();
            if ($$4 < $$3) {
                return false;
            }
            boolean $$5 = this.save($$1);
            $$0.refreshAccessibility();
            if ($$5) {
                this.chunkSaveCooldowns.put($$2, $$4 + 10000L);
            }
            return $$5;
        }
        return false;
    }

    private boolean save(ChunkAccess $$0) {
        this.poiManager.flush($$0.getPos());
        if (!$$0.isUnsaved()) {
            return false;
        }
        $$0.setUnsaved(false);
        ChunkPos $$12 = $$0.getPos();
        try {
            ChunkStatus $$2 = $$0.getStatus();
            if ($$2.getChunkType() != ChunkType.LEVELCHUNK) {
                if (this.isExistingChunkFull($$12)) {
                    return false;
                }
                if ($$2 == ChunkStatus.EMPTY && $$0.getAllStarts().values().stream().noneMatch(StructureStart::isValid)) {
                    return false;
                }
            }
            this.level.getProfiler().incrementCounter("chunkSave");
            CompoundTag $$3 = ChunkSerializer.write(this.level, $$0);
            this.write($$12, $$3).exceptionallyAsync($$1 -> {
                this.level.getServer().reportChunkSaveFailure($$12);
                return null;
            }, (Executor)this.mainThreadExecutor);
            this.markPosition($$12, $$2.getChunkType());
            return true;
        }
        catch (Exception $$4) {
            LOGGER.error("Failed to save chunk {},{}", new Object[]{$$12.x, $$12.z, $$4});
            this.level.getServer().reportChunkSaveFailure($$12);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isExistingChunkFull(ChunkPos $$0) {
        void $$4;
        byte $$1 = this.chunkTypeCache.get($$0.toLong());
        if ($$1 != 0) {
            return $$1 == 1;
        }
        try {
            CompoundTag $$2 = this.readChunk($$0).join().orElse(null);
            if ($$2 == null) {
                this.markPositionReplaceable($$0);
                return false;
            }
        }
        catch (Exception $$3) {
            LOGGER.error("Failed to read chunk {}", (Object)$$0, (Object)$$3);
            this.markPositionReplaceable($$0);
            return false;
        }
        ChunkType $$5 = ChunkSerializer.getChunkTypeFromTag((CompoundTag)$$4);
        return this.markPosition($$0, $$5) == 1;
    }

    protected void setServerViewDistance(int $$0) {
        int $$1 = Mth.clamp($$0, 2, 32);
        if ($$1 != this.serverViewDistance) {
            this.serverViewDistance = $$1;
            this.distanceManager.updatePlayerTickets(this.serverViewDistance);
            for (ServerPlayer $$2 : this.playerMap.getAllPlayers()) {
                this.updateChunkTracking($$2);
            }
        }
    }

    int getPlayerViewDistance(ServerPlayer $$0) {
        return Mth.clamp($$0.requestedViewDistance(), 2, this.serverViewDistance);
    }

    private void markChunkPendingToSend(ServerPlayer $$0, ChunkPos $$1) {
        LevelChunk $$2 = this.getChunkToSend($$1.toLong());
        if ($$2 != null) {
            ChunkMap.markChunkPendingToSend($$0, $$2);
        }
    }

    private static void markChunkPendingToSend(ServerPlayer $$0, LevelChunk $$1) {
        $$0.connection.chunkSender.markChunkPendingToSend($$1);
    }

    private static void dropChunk(ServerPlayer $$0, ChunkPos $$1) {
        $$0.connection.chunkSender.dropChunk($$0, $$1);
    }

    @Nullable
    public LevelChunk getChunkToSend(long $$0) {
        ChunkHolder $$1 = this.getVisibleChunkIfPresent($$0);
        if ($$1 == null) {
            return null;
        }
        return $$1.getChunkToSend();
    }

    public int size() {
        return this.visibleChunkMap.size();
    }

    public net.minecraft.server.level.DistanceManager getDistanceManager() {
        return this.distanceManager;
    }

    protected Iterable<ChunkHolder> getChunks() {
        return Iterables.unmodifiableIterable((Iterable)this.visibleChunkMap.values());
    }

    void dumpChunks(Writer $$02) throws IOException {
        CsvOutput $$1 = CsvOutput.builder().addColumn("x").addColumn("z").addColumn("level").addColumn("in_memory").addColumn("status").addColumn("full_status").addColumn("accessible_ready").addColumn("ticking_ready").addColumn("entity_ticking_ready").addColumn("ticket").addColumn("spawning").addColumn("block_entity_count").addColumn("ticking_ticket").addColumn("ticking_level").addColumn("block_ticks").addColumn("fluid_ticks").build($$02);
        TickingTracker $$2 = this.distanceManager.tickingTracker();
        for (Long2ObjectMap.Entry $$3 : this.visibleChunkMap.long2ObjectEntrySet()) {
            long $$4 = $$3.getLongKey();
            ChunkPos $$5 = new ChunkPos($$4);
            ChunkHolder $$6 = (ChunkHolder)$$3.getValue();
            Optional<ChunkAccess> $$7 = Optional.ofNullable($$6.getLastAvailable());
            Optional<Object> $$8 = $$7.flatMap($$0 -> $$0 instanceof LevelChunk ? Optional.of((LevelChunk)$$0) : Optional.empty());
            $$1.writeRow($$5.x, $$5.z, $$6.getTicketLevel(), $$7.isPresent(), $$7.map(ChunkAccess::getStatus).orElse(null), $$8.map(LevelChunk::getFullStatus).orElse(null), ChunkMap.printFuture($$6.getFullChunkFuture()), ChunkMap.printFuture($$6.getTickingChunkFuture()), ChunkMap.printFuture($$6.getEntityTickingChunkFuture()), this.distanceManager.getTicketDebugString($$4), this.anyPlayerCloseEnoughForSpawning($$5), $$8.map($$0 -> $$0.getBlockEntities().size()).orElse(0), $$2.getTicketDebugString($$4), $$2.getLevel($$4), $$8.map($$0 -> $$0.getBlockTicks().count()).orElse(0), $$8.map($$0 -> $$0.getFluidTicks().count()).orElse(0));
        }
    }

    private static String printFuture(CompletableFuture<ChunkResult<LevelChunk>> $$0) {
        try {
            ChunkResult $$1 = $$0.getNow(null);
            if ($$1 != null) {
                return $$1.isSuccess() ? "done" : "unloaded";
            }
            return "not completed";
        }
        catch (CompletionException $$2) {
            return "failed " + $$2.getCause().getMessage();
        }
        catch (CancellationException $$3) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<CompoundTag>> readChunk(ChunkPos $$02) {
        return this.read($$02).thenApplyAsync($$0 -> $$0.map(this::upgradeChunkTag), (Executor)Util.backgroundExecutor());
    }

    private CompoundTag upgradeChunkTag(CompoundTag $$0) {
        return this.upgradeChunkTag(this.level.dimension(), this.overworldDataStorage, $$0, this.generator.getTypeNameForDataFixer());
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkPos $$0) {
        if (!this.distanceManager.hasPlayersNearby($$0.toLong())) {
            return false;
        }
        for (ServerPlayer $$1 : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning($$1, $$0)) continue;
            return true;
        }
        return false;
    }

    public List<ServerPlayer> getPlayersCloseForSpawning(ChunkPos $$0) {
        long $$1 = $$0.toLong();
        if (!this.distanceManager.hasPlayersNearby($$1)) {
            return List.of();
        }
        ImmutableList.Builder $$2 = ImmutableList.builder();
        for (ServerPlayer $$3 : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning($$3, $$0)) continue;
            $$2.add((Object)$$3);
        }
        return $$2.build();
    }

    private boolean playerIsCloseEnoughForSpawning(ServerPlayer $$0, ChunkPos $$1) {
        if ($$0.isSpectator()) {
            return false;
        }
        double $$2 = ChunkMap.euclideanDistanceSquared($$1, $$0);
        return $$2 < 16384.0;
    }

    private boolean skipPlayer(ServerPlayer $$0) {
        return $$0.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
    }

    void updatePlayerStatus(ServerPlayer $$0, boolean $$1) {
        boolean $$2 = this.skipPlayer($$0);
        boolean $$3 = this.playerMap.ignoredOrUnknown($$0);
        if ($$1) {
            this.playerMap.addPlayer($$0, $$2);
            this.updatePlayerPos($$0);
            if (!$$2) {
                this.distanceManager.addPlayer(SectionPos.of($$0), $$0);
            }
            $$0.setChunkTrackingView(ChunkTrackingView.EMPTY);
            this.updateChunkTracking($$0);
        } else {
            SectionPos $$4 = $$0.getLastSectionPos();
            this.playerMap.removePlayer($$0);
            if (!$$3) {
                this.distanceManager.removePlayer($$4, $$0);
            }
            this.applyChunkTrackingView($$0, ChunkTrackingView.EMPTY);
        }
    }

    private void updatePlayerPos(ServerPlayer $$0) {
        SectionPos $$1 = SectionPos.of($$0);
        $$0.setLastSectionPos($$1);
    }

    public void move(ServerPlayer $$0) {
        boolean $$6;
        for (TrackedEntity $$1 : this.entityMap.values()) {
            if ($$1.entity == $$0) {
                $$1.updatePlayers(this.level.players());
                continue;
            }
            $$1.updatePlayer($$0);
        }
        SectionPos $$2 = $$0.getLastSectionPos();
        SectionPos $$3 = SectionPos.of($$0);
        boolean $$4 = this.playerMap.ignored($$0);
        boolean $$5 = this.skipPlayer($$0);
        boolean bl = $$6 = $$2.asLong() != $$3.asLong();
        if ($$6 || $$4 != $$5) {
            this.updatePlayerPos($$0);
            if (!$$4) {
                this.distanceManager.removePlayer($$2, $$0);
            }
            if (!$$5) {
                this.distanceManager.addPlayer($$3, $$0);
            }
            if (!$$4 && $$5) {
                this.playerMap.ignorePlayer($$0);
            }
            if ($$4 && !$$5) {
                this.playerMap.unIgnorePlayer($$0);
            }
            this.updateChunkTracking($$0);
        }
    }

    private void updateChunkTracking(ServerPlayer $$0) {
        ChunkTrackingView.Positioned $$3;
        ChunkPos $$1 = $$0.chunkPosition();
        int $$2 = this.getPlayerViewDistance($$0);
        ChunkTrackingView chunkTrackingView = $$0.getChunkTrackingView();
        if (chunkTrackingView instanceof ChunkTrackingView.Positioned && ($$3 = (ChunkTrackingView.Positioned)chunkTrackingView).center().equals($$1) && $$3.viewDistance() == $$2) {
            return;
        }
        this.applyChunkTrackingView($$0, ChunkTrackingView.of($$1, $$2));
    }

    private void applyChunkTrackingView(ServerPlayer $$0, ChunkTrackingView $$12) {
        if ($$0.level() != this.level) {
            return;
        }
        ChunkTrackingView $$2 = $$0.getChunkTrackingView();
        if ($$12 instanceof ChunkTrackingView.Positioned) {
            ChunkTrackingView.Positioned $$4;
            ChunkTrackingView.Positioned $$3 = (ChunkTrackingView.Positioned)$$12;
            if (!($$2 instanceof ChunkTrackingView.Positioned) || !($$4 = (ChunkTrackingView.Positioned)$$2).center().equals($$3.center())) {
                $$0.connection.send(new ClientboundSetChunkCacheCenterPacket($$3.center().x, $$3.center().z));
            }
        }
        ChunkTrackingView.difference($$2, $$12, $$1 -> this.markChunkPendingToSend($$0, (ChunkPos)$$1), $$1 -> ChunkMap.dropChunk($$0, $$1));
        $$0.setChunkTrackingView($$12);
    }

    @Override
    public List<ServerPlayer> getPlayers(ChunkPos $$0, boolean $$1) {
        Set<ServerPlayer> $$2 = this.playerMap.getAllPlayers();
        ImmutableList.Builder $$3 = ImmutableList.builder();
        for (ServerPlayer $$4 : $$2) {
            if ((!$$1 || !this.isChunkOnTrackedBorder($$4, $$0.x, $$0.z)) && ($$1 || !this.isChunkTracked($$4, $$0.x, $$0.z))) continue;
            $$3.add((Object)$$4);
        }
        return $$3.build();
    }

    protected void addEntity(Entity $$0) {
        if ($$0 instanceof EnderDragonPart) {
            return;
        }
        EntityType<?> $$1 = $$0.getType();
        int $$2 = $$1.clientTrackingRange() * 16;
        if ($$2 == 0) {
            return;
        }
        int $$3 = $$1.updateInterval();
        if (this.entityMap.containsKey($$0.getId())) {
            throw Util.pauseInIde(new IllegalStateException("Entity is already tracked!"));
        }
        TrackedEntity $$4 = new TrackedEntity($$0, $$2, $$3, $$1.trackDeltas());
        this.entityMap.put($$0.getId(), (Object)$$4);
        $$4.updatePlayers(this.level.players());
        if ($$0 instanceof ServerPlayer) {
            ServerPlayer $$5 = (ServerPlayer)$$0;
            this.updatePlayerStatus($$5, true);
            for (TrackedEntity $$6 : this.entityMap.values()) {
                if ($$6.entity == $$5) continue;
                $$6.updatePlayer($$5);
            }
        }
    }

    protected void removeEntity(Entity $$0) {
        TrackedEntity $$3;
        if ($$0 instanceof ServerPlayer) {
            ServerPlayer $$1 = (ServerPlayer)$$0;
            this.updatePlayerStatus($$1, false);
            for (TrackedEntity $$2 : this.entityMap.values()) {
                $$2.removePlayer($$1);
            }
        }
        if (($$3 = (TrackedEntity)this.entityMap.remove($$0.getId())) != null) {
            $$3.broadcastRemoved();
        }
    }

    protected void tick() {
        for (ServerPlayer $$0 : this.playerMap.getAllPlayers()) {
            this.updateChunkTracking($$0);
        }
        ArrayList $$1 = Lists.newArrayList();
        List<ServerPlayer> $$2 = this.level.players();
        for (TrackedEntity $$3 : this.entityMap.values()) {
            boolean $$6;
            SectionPos $$4 = $$3.lastSectionPos;
            SectionPos $$5 = SectionPos.of($$3.entity);
            boolean bl = $$6 = !Objects.equals($$4, $$5);
            if ($$6) {
                $$3.updatePlayers($$2);
                Entity $$7 = $$3.entity;
                if ($$7 instanceof ServerPlayer) {
                    $$1.add((ServerPlayer)$$7);
                }
                $$3.lastSectionPos = $$5;
            }
            if (!$$6 && !this.distanceManager.inEntityTickingRange($$5.chunk().toLong())) continue;
            $$3.serverEntity.sendChanges();
        }
        if (!$$1.isEmpty()) {
            for (TrackedEntity $$8 : this.entityMap.values()) {
                $$8.updatePlayers($$1);
            }
        }
    }

    public void broadcast(Entity $$0, Packet<?> $$1) {
        TrackedEntity $$2 = (TrackedEntity)this.entityMap.get($$0.getId());
        if ($$2 != null) {
            $$2.broadcast($$1);
        }
    }

    protected void broadcastAndSend(Entity $$0, Packet<?> $$1) {
        TrackedEntity $$2 = (TrackedEntity)this.entityMap.get($$0.getId());
        if ($$2 != null) {
            $$2.broadcastAndSend($$1);
        }
    }

    public void resendBiomesForChunks(List<ChunkAccess> $$02) {
        HashMap<ServerPlayer, List> $$12 = new HashMap<ServerPlayer, List>();
        for (ChunkAccess $$2 : $$02) {
            LevelChunk $$6;
            ChunkPos $$3 = $$2.getPos();
            if ($$2 instanceof LevelChunk) {
                LevelChunk $$4;
                LevelChunk $$5 = $$4 = (LevelChunk)$$2;
            } else {
                $$6 = this.level.getChunk($$3.x, $$3.z);
            }
            for (ServerPlayer $$7 : this.getPlayers($$3, false)) {
                $$12.computeIfAbsent($$7, $$0 -> new ArrayList()).add($$6);
            }
        }
        $$12.forEach(($$0, $$1) -> $$0.connection.send(ClientboundChunksBiomesPacket.forChunks($$1)));
    }

    protected PoiManager getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkPos $$0, FullChunkStatus $$1) {
        this.chunkStatusListener.onChunkStatusChange($$0, $$1);
    }

    public void waitForLightBeforeSending(ChunkPos $$02, int $$1) {
        int $$2 = $$1 + 1;
        ChunkPos.rangeClosed($$02, $$2).forEach($$0 -> {
            ChunkHolder $$1 = this.getVisibleChunkIfPresent($$0.toLong());
            if ($$1 != null) {
                $$1.addSendDependency(this.lightEngine.waitForPendingTasks($$0.x, $$0.z));
            }
        });
    }

    class DistanceManager
    extends net.minecraft.server.level.DistanceManager {
        protected DistanceManager(Executor $$0, Executor $$1) {
            super($$0, $$1);
        }

        @Override
        protected boolean isChunkToRemove(long $$0) {
            return ChunkMap.this.toDrop.contains($$0);
        }

        @Override
        @Nullable
        protected ChunkHolder getChunk(long $$0) {
            return ChunkMap.this.getUpdatingChunkIfPresent($$0);
        }

        @Override
        @Nullable
        protected ChunkHolder updateChunkScheduling(long $$0, int $$1, @Nullable ChunkHolder $$2, int $$3) {
            return ChunkMap.this.updateChunkScheduling($$0, $$1, $$2, $$3);
        }
    }

    class TrackedEntity {
        final ServerEntity serverEntity;
        final Entity entity;
        private final int range;
        SectionPos lastSectionPos;
        private final Set<ServerPlayerConnection> seenBy = Sets.newIdentityHashSet();

        public TrackedEntity(Entity $$0, int $$1, int $$2, boolean $$3) {
            this.serverEntity = new ServerEntity(ChunkMap.this.level, $$0, $$2, $$3, this::broadcast);
            this.entity = $$0;
            this.range = $$1;
            this.lastSectionPos = SectionPos.of($$0);
        }

        public boolean equals(Object $$0) {
            if ($$0 instanceof TrackedEntity) {
                return ((TrackedEntity)$$0).entity.getId() == this.entity.getId();
            }
            return false;
        }

        public int hashCode() {
            return this.entity.getId();
        }

        public void broadcast(Packet<?> $$0) {
            for (ServerPlayerConnection $$1 : this.seenBy) {
                $$1.send($$0);
            }
        }

        public void broadcastAndSend(Packet<?> $$0) {
            this.broadcast($$0);
            if (this.entity instanceof ServerPlayer) {
                ((ServerPlayer)this.entity).connection.send($$0);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection $$0 : this.seenBy) {
                this.serverEntity.removePairing($$0.getPlayer());
            }
        }

        public void removePlayer(ServerPlayer $$0) {
            if (this.seenBy.remove($$0.connection)) {
                this.serverEntity.removePairing($$0);
            }
        }

        public void updatePlayer(ServerPlayer $$0) {
            boolean $$6;
            if ($$0 == this.entity) {
                return;
            }
            Vec3 $$1 = $$0.position().subtract(this.entity.position());
            int $$2 = ChunkMap.this.getPlayerViewDistance($$0);
            double $$4 = $$1.x * $$1.x + $$1.z * $$1.z;
            double $$3 = Math.min(this.getEffectiveRange(), $$2 * 16);
            double $$5 = $$3 * $$3;
            boolean bl = $$6 = $$4 <= $$5 && this.entity.broadcastToPlayer($$0) && ChunkMap.this.isChunkTracked($$0, this.entity.chunkPosition().x, this.entity.chunkPosition().z);
            if ($$6) {
                if (this.seenBy.add($$0.connection)) {
                    this.serverEntity.addPairing($$0);
                }
            } else if (this.seenBy.remove($$0.connection)) {
                this.serverEntity.removePairing($$0);
            }
        }

        private int scaledRange(int $$0) {
            return ChunkMap.this.level.getServer().getScaledTrackingDistance($$0);
        }

        private int getEffectiveRange() {
            int $$0 = this.range;
            for (Entity $$1 : this.entity.getIndirectPassengers()) {
                int $$2 = $$1.getType().clientTrackingRange() * 16;
                if ($$2 <= $$0) continue;
                $$0 = $$2;
            }
            return this.scaledRange($$0);
        }

        public void updatePlayers(List<ServerPlayer> $$0) {
            for (ServerPlayer $$1 : $$0) {
                this.updatePlayer($$1);
            }
        }
    }
}

