/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BegGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.WolfVariants;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class Wolf
extends TamableAnimal
implements NeutralMob,
VariantHolder<Holder<WolfVariant>> {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Holder<WolfVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Wolf.class, EntityDataSerializers.WOLF_VARIANT);
    public static final Predicate<LivingEntity> PREY_SELECTOR = $$0 -> {
        EntityType<?> $$1 = $$0.getType();
        return $$1 == EntityType.SHEEP || $$1 == EntityType.RABBIT || $$1 == EntityType.FOX;
    };
    private static final float START_HEALTH = 8.0f;
    private static final float TAME_HEALTH = 40.0f;
    private static final float ARMOR_REPAIR_UNIT = 0.125f;
    private float interestedAngle;
    private float interestedAngleO;
    private boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds(20, 39);
    @Nullable
    private UUID persistentAngerTarget;

    public Wolf(EntityType<? extends Wolf> $$0, Level $$1) {
        super((EntityType<? extends TamableAnimal>)$$0, $$1);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new FloatGoal(this));
        this.goalSelector.addGoal(1, new WolfPanicGoal(this, 1.5));
        this.goalSelector.addGoal(2, new SitWhenOrderedToGoal(this));
        this.goalSelector.addGoal(3, new WolfAvoidEntityGoal<Llama>(this, Llama.class, 24.0f, 1.5, 1.5));
        this.goalSelector.addGoal(4, new LeapAtTargetGoal(this, 0.4f));
        this.goalSelector.addGoal(5, new MeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(6, new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.goalSelector.addGoal(7, new BreedGoal(this, 1.0));
        this.goalSelector.addGoal(8, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(9, new BegGoal(this, 8.0f));
        this.goalSelector.addGoal(10, new LookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, new RandomLookAroundGoal(this));
        this.targetSelector.addGoal(1, new OwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, new OwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(3, new HurtByTargetGoal(this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, new NearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, this::isAngryAt));
        this.targetSelector.addGoal(5, new NonTameRandomTargetGoal<Animal>(this, Animal.class, false, PREY_SELECTOR));
        this.targetSelector.addGoal(6, new NonTameRandomTargetGoal<Turtle>(this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<AbstractSkeleton>((Mob)this, AbstractSkeleton.class, false));
        this.targetSelector.addGoal(8, new ResetUniversalAngerTargetGoal<Wolf>(this, true));
    }

    public ResourceLocation getTexture() {
        WolfVariant $$0 = (WolfVariant)this.getVariant().value();
        if (this.isTame()) {
            return $$0.tameTexture();
        }
        if (this.isAngry()) {
            return $$0.angryTexture();
        }
        return $$0.wildTexture();
    }

    @Override
    public Holder<WolfVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    public void setVariant(Holder<WolfVariant> $$0) {
        this.entityData.set(DATA_VARIANT_ID, $$0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.3f).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder $$0) {
        super.defineSynchedData($$0);
        $$0.define(DATA_VARIANT_ID, this.registryAccess().registryOrThrow(Registries.WOLF_VARIANT).getHolderOrThrow(WolfVariants.PALE));
        $$0.define(DATA_INTERESTED_ID, false);
        $$0.define(DATA_COLLAR_COLOR, DyeColor.RED.getId());
        $$0.define(DATA_REMAINING_ANGER_TIME, 0);
    }

    @Override
    protected void playStepSound(BlockPos $$0, BlockState $$1) {
        this.playSound(SoundEvents.WOLF_STEP, 0.15f, 1.0f);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag $$0) {
        super.addAdditionalSaveData($$0);
        $$0.putByte("CollarColor", (byte)this.getCollarColor().getId());
        $$0.putString("variant", this.getVariant().unwrapKey().orElse(WolfVariants.PALE).location().toString());
        this.addPersistentAngerSaveData($$0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag $$02) {
        super.readAdditionalSaveData($$02);
        Optional.ofNullable(ResourceLocation.tryParse($$02.getString("variant"))).map($$0 -> ResourceKey.create(Registries.WOLF_VARIANT, $$0)).flatMap($$0 -> this.registryAccess().registryOrThrow(Registries.WOLF_VARIANT).getHolder((ResourceKey<WolfVariant>)$$0)).ifPresent(this::setVariant);
        if ($$02.contains("CollarColor", 99)) {
            this.setCollarColor(DyeColor.byId($$02.getInt("CollarColor")));
        }
        this.readPersistentAngerSaveData((Level)this.level(), $$02);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor $$0, DifficultyInstance $$1, MobSpawnType $$2, @Nullable SpawnGroupData $$3) {
        Holder<WolfVariant> $$7;
        Holder<Biome> $$4 = $$0.getBiome(this.blockPosition());
        if ($$3 instanceof WolfPackData) {
            WolfPackData $$5 = (WolfPackData)$$3;
            Holder<WolfVariant> $$6 = $$5.type;
        } else {
            $$7 = WolfVariants.getSpawnVariant(this.registryAccess(), $$4);
            $$3 = new WolfPackData($$7);
        }
        this.setVariant($$7);
        return super.finalizeSpawn($$0, $$1, $$2, $$3);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        if (this.isAngry()) {
            return SoundEvents.WOLF_GROWL;
        }
        if (this.random.nextInt(3) == 0) {
            if (this.isTame() && this.getHealth() < 20.0f) {
                return SoundEvents.WOLF_WHINE;
            }
            return SoundEvents.WOLF_PANT;
        }
        return SoundEvents.WOLF_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource $$0) {
        if (this.canArmorAbsorb($$0)) {
            return SoundEvents.WOLF_ARMOR_DAMAGE;
        }
        return SoundEvents.WOLF_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.WOLF_DEATH;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!((Level)this.level()).isClientSide && this.isWet && !this.isShaking && !this.isPathFinding() && this.onGround()) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            ((Level)this.level()).broadcastEntityEvent(this, (byte)8);
        }
        if (!((Level)this.level()).isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isAlive()) {
            return;
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        if (this.isInWaterRainOrBubble()) {
            this.isWet = true;
            if (this.isShaking && !((Level)this.level()).isClientSide) {
                ((Level)this.level()).broadcastEntityEvent(this, (byte)56);
                this.cancelShake();
            }
        } else if ((this.isWet || this.isShaking) && this.isShaking) {
            if (this.shakeAnim == 0.0f) {
                this.playSound(SoundEvents.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.gameEvent(GameEvent.ENTITY_ACTION);
            }
            this.shakeAnimO = this.shakeAnim;
            this.shakeAnim += 0.05f;
            if (this.shakeAnimO >= 2.0f) {
                this.isWet = false;
                this.isShaking = false;
                this.shakeAnimO = 0.0f;
                this.shakeAnim = 0.0f;
            }
            if (this.shakeAnim > 0.4f) {
                float $$0 = (float)this.getY();
                int $$1 = (int)(Mth.sin((this.shakeAnim - 0.4f) * (float)Math.PI) * 7.0f);
                Vec3 $$2 = this.getDeltaMovement();
                for (int $$3 = 0; $$3 < $$1; ++$$3) {
                    float $$4 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                    float $$5 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getBbWidth() * 0.5f;
                    ((Level)this.level()).addParticle(ParticleTypes.SPLASH, this.getX() + (double)$$4, $$0 + 0.8f, this.getZ() + (double)$$5, $$2.x, $$2.y, $$2.z);
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    @Override
    public void die(DamageSource $$0) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.die($$0);
    }

    public boolean isWet() {
        return this.isWet;
    }

    public float getWetShade(float $$0) {
        return Math.min(0.75f + Mth.lerp($$0, this.shakeAnimO, this.shakeAnim) / 2.0f * 0.25f, 1.0f);
    }

    public float getBodyRollAngle(float $$0, float $$1) {
        float $$2 = (Mth.lerp($$0, this.shakeAnimO, this.shakeAnim) + $$1) / 1.8f;
        if ($$2 < 0.0f) {
            $$2 = 0.0f;
        } else if ($$2 > 1.0f) {
            $$2 = 1.0f;
        }
        return Mth.sin($$2 * (float)Math.PI) * Mth.sin($$2 * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float getHeadRollAngle(float $$0) {
        return Mth.lerp($$0, this.interestedAngleO, this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    @Override
    public int getMaxHeadXRot() {
        if (this.isInSittingPose()) {
            return 20;
        }
        return super.getMaxHeadXRot();
    }

    @Override
    public boolean hurt(DamageSource $$0, float $$1) {
        if (this.isInvulnerableTo($$0)) {
            return false;
        }
        if (!((Level)this.level()).isClientSide) {
            this.setOrderedToSit(false);
        }
        return super.hurt($$0, $$1);
    }

    @Override
    protected void actuallyHurt(DamageSource $$0, float $$1) {
        if (!this.canArmorAbsorb($$0)) {
            super.actuallyHurt($$0, $$1);
            return;
        }
        ItemStack $$2 = this.getBodyArmorItem();
        int $$3 = $$2.getDamageValue();
        int $$4 = $$2.getMaxDamage();
        $$2.hurtAndBreak(Mth.ceil($$1), this, EquipmentSlot.BODY);
        if (Crackiness.WOLF_ARMOR.byDamage($$3, $$4) != Crackiness.WOLF_ARMOR.byDamage(this.getBodyArmorItem())) {
            this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
            EntityGetter entityGetter = this.level();
            if (entityGetter instanceof ServerLevel) {
                ServerLevel $$5 = (ServerLevel)entityGetter;
                $$5.sendParticles(new ItemParticleOption(ParticleTypes.ITEM, Items.ARMADILLO_SCUTE.getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
            }
        }
    }

    private boolean canArmorAbsorb(DamageSource $$0) {
        return this.hasArmor() && !$$0.is(DamageTypeTags.BYPASSES_WOLF_ARMOR);
    }

    @Override
    public boolean doHurtTarget(Entity $$0) {
        boolean $$1 = $$0.hurt(this.damageSources().mobAttack(this), (int)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
        if ($$1) {
            this.doEnchantDamageEffects(this, $$0);
        }
        return $$1;
    }

    @Override
    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40.0);
            this.setHealth(40.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
        }
    }

    @Override
    protected void hurtArmor(DamageSource $$0, float $$1) {
        this.doHurtEquipment($$0, $$1, EquipmentSlot.BODY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InteractionResult mobInteract(Player $$0, InteractionHand $$1) {
        ItemStack $$2 = $$0.getItemInHand($$1);
        Item $$3 = $$2.getItem();
        if (!(!((Level)this.level()).isClientSide || this.isBaby() && this.isFood($$2))) {
            boolean $$4 = this.isOwnedBy($$0) || this.isTame() || $$2.is(Items.BONE) && !this.isTame() && !this.isAngry();
            return $$4 ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isTame()) {
            if (this.isFood($$2) && this.getHealth() < this.getMaxHealth()) {
                $$2.consume(1, $$0);
                FoodProperties $$5 = $$2.get(DataComponents.FOOD);
                float $$6 = $$5 != null ? (float)$$5.nutrition() : 1.0f;
                this.heal(2.0f * $$6);
                return InteractionResult.sidedSuccess(((Level)this.level()).isClientSide());
            }
            if ($$3 instanceof DyeItem) {
                DyeItem $$7 = (DyeItem)$$3;
                if (this.isOwnedBy($$0)) {
                    DyeColor $$8 = $$7.getDyeColor();
                    if ($$8 == this.getCollarColor()) return super.mobInteract($$0, $$1);
                    this.setCollarColor($$8);
                    $$2.consume(1, $$0);
                    return InteractionResult.SUCCESS;
                }
            }
            if ($$2.is(Items.WOLF_ARMOR) && this.isOwnedBy($$0) && !this.hasArmor() && !this.isBaby()) {
                this.setBodyArmorItem($$2.copyWithCount(1));
                $$2.consume(1, $$0);
                return InteractionResult.SUCCESS;
            }
            if ($$2.is(Items.SHEARS) && this.isOwnedBy($$0) && this.hasArmor() && (!EnchantmentHelper.hasBindingCurse(this.getBodyArmorItem()) || $$0.isCreative())) {
                $$2.hurtAndBreak(1, $$0, Wolf.getSlotForHand($$1));
                this.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF);
                ItemStack $$9 = this.getBodyArmorItem();
                this.setBodyArmorItem(ItemStack.EMPTY);
                this.spawnAtLocation($$9);
                return InteractionResult.SUCCESS;
            }
            if (ArmorMaterials.ARMADILLO.value().repairIngredient().get().test($$2) && this.isInSittingPose() && this.hasArmor() && this.isOwnedBy($$0) && this.getBodyArmorItem().isDamaged()) {
                $$2.shrink(1);
                this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
                ItemStack $$10 = this.getBodyArmorItem();
                int $$11 = (int)((float)$$10.getMaxDamage() * 0.125f);
                $$10.setDamageValue(Math.max(0, $$10.getDamageValue() - $$11));
                return InteractionResult.SUCCESS;
            }
            InteractionResult $$12 = super.mobInteract($$0, $$1);
            if ($$12.consumesAction() || !this.isOwnedBy($$0)) return $$12;
            this.setOrderedToSit(!this.isOrderedToSit());
            this.jumping = false;
            this.navigation.stop();
            this.setTarget(null);
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        if (!$$2.is(Items.BONE) || this.isAngry()) return super.mobInteract($$0, $$1);
        $$2.consume(1, $$0);
        this.tryToTame($$0);
        return InteractionResult.SUCCESS;
    }

    private void tryToTame(Player $$0) {
        if (this.random.nextInt(3) == 0) {
            this.tame($$0);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            ((Level)this.level()).broadcastEntityEvent(this, (byte)7);
        } else {
            ((Level)this.level()).broadcastEntityEvent(this, (byte)6);
        }
    }

    @Override
    public void handleEntityEvent(byte $$0) {
        if ($$0 == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if ($$0 == 56) {
            this.cancelShake();
        } else {
            super.handleEntityEvent($$0);
        }
    }

    public float getTailAngle() {
        if (this.isAngry()) {
            return 1.5393804f;
        }
        if (this.isTame()) {
            float $$0 = this.getMaxHealth();
            float $$1 = ($$0 - this.getHealth()) / $$0;
            return (0.55f - $$1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean isFood(ItemStack $$0) {
        return $$0.is(ItemTags.WOLF_FOOD);
    }

    @Override
    public int getMaxSpawnClusterSize() {
        return 8;
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void setRemainingPersistentAngerTime(int $$0) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, $$0);
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID $$0) {
        this.persistentAngerTarget = $$0;
    }

    public DyeColor getCollarColor() {
        return DyeColor.byId(this.entityData.get(DATA_COLLAR_COLOR));
    }

    public boolean hasArmor() {
        return !this.getBodyArmorItem().isEmpty();
    }

    private void setCollarColor(DyeColor $$0) {
        this.entityData.set(DATA_COLLAR_COLOR, $$0.getId());
    }

    @Override
    @Nullable
    public Wolf getBreedOffspring(ServerLevel $$0, AgeableMob $$1) {
        Wolf $$2 = EntityType.WOLF.create($$0);
        if ($$2 != null && $$1 instanceof Wolf) {
            Wolf $$3 = (Wolf)$$1;
            if (this.random.nextBoolean()) {
                $$2.setVariant((Holder<WolfVariant>)this.getVariant());
            } else {
                $$2.setVariant((Holder<WolfVariant>)$$3.getVariant());
            }
            if (this.isTame()) {
                $$2.setOwnerUUID(this.getOwnerUUID());
                $$2.setTame(true, true);
                if (this.random.nextBoolean()) {
                    $$2.setCollarColor(this.getCollarColor());
                } else {
                    $$2.setCollarColor($$3.getCollarColor());
                }
            }
        }
        return $$2;
    }

    public void setIsInterested(boolean $$0) {
        this.entityData.set(DATA_INTERESTED_ID, $$0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean canMate(Animal $$0) {
        void $$2;
        if ($$0 == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!($$0 instanceof Wolf)) {
            return false;
        }
        Wolf $$1 = (Wolf)$$0;
        if (!$$2.isTame()) {
            return false;
        }
        if ($$2.isInSittingPose()) {
            return false;
        }
        return this.isInLove() && $$2.isInLove();
    }

    public boolean isInterested() {
        return this.entityData.get(DATA_INTERESTED_ID);
    }

    @Override
    public boolean wantsToAttack(LivingEntity $$0, LivingEntity $$1) {
        TamableAnimal $$6;
        AbstractHorse $$5;
        if ($$0 instanceof Creeper || $$0 instanceof Ghast || $$0 instanceof ArmorStand) {
            return false;
        }
        if ($$0 instanceof Wolf) {
            Wolf $$2 = (Wolf)$$0;
            return !$$2.isTame() || $$2.getOwner() != $$1;
        }
        if ($$0 instanceof Player) {
            Player $$4;
            Player $$3 = (Player)$$0;
            if ($$1 instanceof Player && !($$4 = (Player)$$1).canHarmPlayer($$3)) {
                return false;
            }
        }
        if ($$0 instanceof AbstractHorse && ($$5 = (AbstractHorse)$$0).isTamed()) {
            return false;
        }
        return !($$0 instanceof TamableAnimal) || !($$6 = (TamableAnimal)$$0).isTame();
    }

    @Override
    public boolean canBeLeashed(Player $$0) {
        return !this.isAngry() && super.canBeLeashed($$0);
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public static boolean checkWolfSpawnRules(EntityType<Wolf> $$0, LevelAccessor $$1, MobSpawnType $$2, BlockPos $$3, RandomSource $$4) {
        return $$1.getBlockState($$3.below()).is(BlockTags.WOLVES_SPAWNABLE_ON) && Wolf.isBrightEnoughToSpawn($$1, $$3);
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    @Override
    public /* synthetic */ void setVariant(Object object) {
        this.setVariant((Holder)object);
    }

    class WolfPanicGoal
    extends PanicGoal {
        public WolfPanicGoal(Wolf wolf, double $$0) {
            super(wolf, $$0);
        }

        @Override
        protected boolean shouldPanic() {
            return this.mob.isFreezing() || this.mob.isOnFire();
        }
    }

    class WolfAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Wolf wolf;

        public WolfAvoidEntityGoal(Wolf $$0, Class<T> $$1, float $$2, double $$3, double $$4) {
            super($$0, $$1, $$2, $$3, $$4);
            this.wolf = $$0;
        }

        @Override
        public boolean canUse() {
            if (super.canUse() && this.toAvoid instanceof Llama) {
                return !this.wolf.isTame() && this.avoidLlama((Llama)this.toAvoid);
            }
            return false;
        }

        private boolean avoidLlama(Llama $$0) {
            return $$0.getStrength() >= Wolf.this.random.nextInt(5);
        }

        @Override
        public void start() {
            Wolf.this.setTarget(null);
            super.start();
        }

        @Override
        public void tick() {
            Wolf.this.setTarget(null);
            super.tick();
        }
    }

    public static class WolfPackData
    extends AgeableMob.AgeableMobGroupData {
        public final Holder<WolfVariant> type;

        public WolfPackData(Holder<WolfVariant> $$0) {
            super(false);
            this.type = $$0;
        }
    }
}

