/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.phys.AABB;

public class ArmorItem
extends Item
implements Equipable {
    private static final EnumMap<Type, UUID> ARMOR_MODIFIER_UUID_PER_TYPE = Util.make(new EnumMap(Type.class), $$0 -> {
        $$0.put(Type.BOOTS, UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"));
        $$0.put(Type.LEGGINGS, UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"));
        $$0.put(Type.CHESTPLATE, UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"));
        $$0.put(Type.HELMET, UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150"));
        $$0.put(Type.BODY, UUID.fromString("C1C72771-8B8E-BA4A-ACE0-81A93C8928B2"));
    });
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DefaultDispenseItemBehavior(){

        @Override
        protected ItemStack execute(BlockSource $$0, ItemStack $$1) {
            return ArmorItem.dispenseArmor($$0, $$1) ? $$1 : super.execute($$0, $$1);
        }
    };
    protected final Type type;
    protected final Holder<ArmorMaterial> material;
    private final Supplier<ItemAttributeModifiers> defaultModifiers;

    public static boolean dispenseArmor(BlockSource $$0, ItemStack $$1) {
        BlockPos $$2 = $$0.pos().relative($$0.state().getValue(DispenserBlock.FACING));
        List<Entity> $$3 = $$0.level().getEntitiesOfClass(LivingEntity.class, new AABB($$2), EntitySelector.NO_SPECTATORS.and(new EntitySelector.MobCanWearArmorEntitySelector($$1)));
        if ($$3.isEmpty()) {
            return false;
        }
        LivingEntity $$4 = (LivingEntity)$$3.get(0);
        EquipmentSlot $$5 = Mob.getEquipmentSlotForItem($$1);
        ItemStack $$6 = $$1.split(1);
        $$4.setItemSlot($$5, $$6);
        if ($$4 instanceof Mob) {
            ((Mob)$$4).setDropChance($$5, 2.0f);
            ((Mob)$$4).setPersistenceRequired();
        }
        return true;
    }

    public ArmorItem(Holder<ArmorMaterial> $$0, Type $$1, Item.Properties $$2) {
        super($$2);
        this.material = $$0;
        this.type = $$1;
        DispenserBlock.registerBehavior(this, DISPENSE_ITEM_BEHAVIOR);
        this.defaultModifiers = Suppliers.memoize(() -> {
            int $$2 = ((ArmorMaterial)$$0.value()).getDefense($$1);
            float $$3 = ((ArmorMaterial)$$0.value()).toughness();
            ItemAttributeModifiers.Builder $$4 = ItemAttributeModifiers.builder();
            EquipmentSlotGroup $$5 = EquipmentSlotGroup.bySlot($$1.getSlot());
            UUID $$6 = ARMOR_MODIFIER_UUID_PER_TYPE.get($$1);
            $$4.add(Attributes.ARMOR, new AttributeModifier($$6, "Armor modifier", $$2, AttributeModifier.Operation.ADD_VALUE), $$5);
            $$4.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier($$6, "Armor toughness", $$3, AttributeModifier.Operation.ADD_VALUE), $$5);
            float $$7 = ((ArmorMaterial)$$0.value()).knockbackResistance();
            if ($$7 > 0.0f) {
                $$4.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier($$6, "Armor knockback resistance", $$7, AttributeModifier.Operation.ADD_VALUE), $$5);
            }
            return $$4.build();
        });
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getEnchantmentValue() {
        return this.material.value().enchantmentValue();
    }

    public Holder<ArmorMaterial> getMaterial() {
        return this.material;
    }

    @Override
    public boolean isValidRepairItem(ItemStack $$0, ItemStack $$1) {
        return this.material.value().repairIngredient().get().test($$1) || super.isValidRepairItem($$0, $$1);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level $$0, Player $$1, InteractionHand $$2) {
        return this.swapWithEquipmentSlot(this, $$0, $$1, $$2);
    }

    @Override
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    public int getDefense() {
        return this.material.value().getDefense(this.type);
    }

    public float getToughness() {
        return this.material.value().toughness();
    }

    @Override
    public EquipmentSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    @Override
    public Holder<SoundEvent> getEquipSound() {
        return this.getMaterial().value().equipSound();
    }

    public static enum Type implements StringRepresentable
    {
        HELMET(EquipmentSlot.HEAD, 11, "helmet"),
        CHESTPLATE(EquipmentSlot.CHEST, 16, "chestplate"),
        LEGGINGS(EquipmentSlot.LEGS, 15, "leggings"),
        BOOTS(EquipmentSlot.FEET, 13, "boots"),
        BODY(EquipmentSlot.BODY, 16, "body");

        public static final Codec<Type> CODEC;
        private final EquipmentSlot slot;
        private final String name;
        private final int durability;

        private Type(EquipmentSlot $$0, int $$1, String $$2) {
            this.slot = $$0;
            this.name = $$2;
            this.durability = $$1;
        }

        public int getDurability(int $$0) {
            return this.durability * $$0;
        }

        public EquipmentSlot getSlot() {
            return this.slot;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasTrims() {
            return this == HELMET || this == CHESTPLATE || this == LEGGINGS || this == BOOTS;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromValues(Type::values);
        }
    }
}

