/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    private static final int BAR_COLOR = Mth.color(0.4f, 0.4f, 1.0f);
    private static final int TOOLTIP_MAX_WEIGHT = 64;

    public BundleItem(Item.Properties $$0) {
        super($$0);
    }

    public static float getFullnessDisplay(ItemStack $$0) {
        BundleContents $$1 = $$0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.weight().floatValue();
    }

    @Override
    public boolean overrideStackedOnOther(ItemStack $$0, Slot $$1, ClickAction $$2, Player $$3) {
        int $$9;
        if ($$2 != ClickAction.SECONDARY) {
            return false;
        }
        BundleContents $$4 = $$0.get(DataComponents.BUNDLE_CONTENTS);
        if ($$4 == null) {
            return false;
        }
        ItemStack $$5 = $$1.getItem();
        BundleContents.Mutable $$6 = new BundleContents.Mutable($$4);
        if ($$5.isEmpty()) {
            this.playRemoveOneSound($$3);
            ItemStack $$7 = $$6.removeOne();
            if ($$7 != null) {
                ItemStack $$8 = $$1.safeInsert($$7);
                $$6.tryInsert($$8);
            }
        } else if ($$5.getItem().canFitInsideContainerItems() && ($$9 = $$6.tryTransfer($$1, $$3)) > 0) {
            this.playInsertSound($$3);
        }
        $$0.set(DataComponents.BUNDLE_CONTENTS, $$6.toImmutable());
        return true;
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack $$0, ItemStack $$1, Slot $$2, ClickAction $$3, Player $$4, SlotAccess $$5) {
        if ($$3 != ClickAction.SECONDARY || !$$2.allowModification($$4)) {
            return false;
        }
        BundleContents $$6 = $$0.get(DataComponents.BUNDLE_CONTENTS);
        if ($$6 == null) {
            return false;
        }
        BundleContents.Mutable $$7 = new BundleContents.Mutable($$6);
        if ($$1.isEmpty()) {
            ItemStack $$8 = $$7.removeOne();
            if ($$8 != null) {
                this.playRemoveOneSound($$4);
                $$5.set($$8);
            }
        } else {
            int $$9 = $$7.tryInsert($$1);
            if ($$9 > 0) {
                this.playInsertSound($$4);
            }
        }
        $$0.set(DataComponents.BUNDLE_CONTENTS, $$7.toImmutable());
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level $$0, Player $$1, InteractionHand $$2) {
        ItemStack $$3 = $$1.getItemInHand($$2);
        if (BundleItem.dropContents($$3, $$1)) {
            this.playDropContentsSound($$1);
            $$1.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResultHolder.sidedSuccess($$3, $$0.isClientSide());
        }
        return InteractionResultHolder.fail($$3);
    }

    @Override
    public boolean isBarVisible(ItemStack $$0) {
        BundleContents $$1 = $$0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return $$1.weight().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    public int getBarWidth(ItemStack $$0) {
        BundleContents $$1 = $$0.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate($$1.weight(), 12), 13);
    }

    @Override
    public int getBarColor(ItemStack $$0) {
        return BAR_COLOR;
    }

    private static boolean dropContents(ItemStack $$0, Player $$12) {
        BundleContents $$2 = $$0.get(DataComponents.BUNDLE_CONTENTS);
        if ($$2 == null || $$2.isEmpty()) {
            return false;
        }
        $$0.set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        if ($$12 instanceof ServerPlayer) {
            $$2.itemsCopy().forEach($$1 -> $$12.drop((ItemStack)$$1, true));
        }
        return true;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack $$0) {
        if ($$0.has(DataComponents.HIDE_TOOLTIP) || $$0.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return Optional.empty();
        }
        return Optional.ofNullable($$0.get(DataComponents.BUNDLE_CONTENTS)).map(BundleTooltip::new);
    }

    @Override
    public void appendHoverText(ItemStack $$0, Item.TooltipContext $$1, List<Component> $$2, TooltipFlag $$3) {
        BundleContents $$4 = $$0.get(DataComponents.BUNDLE_CONTENTS);
        if ($$4 != null) {
            int $$5 = Mth.mulAndTruncate($$4.weight(), 64);
            $$2.add(Component.translatable("item.minecraft.bundle.fullness", $$5, 64).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public void onDestroyed(ItemEntity $$0) {
        BundleContents $$1 = $$0.getItem().get(DataComponents.BUNDLE_CONTENTS);
        if ($$1 == null) {
            return;
        }
        $$0.getItem().set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        ItemUtils.onContainerDestroyed($$0, $$1.itemsCopy());
    }

    private void playRemoveOneSound(Entity $$0) {
        $$0.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + $$0.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity $$0) {
        $$0.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + $$0.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity $$0) {
        $$0.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + $$0.level().getRandom().nextFloat() * 0.4f);
    }
}

