/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CrossbowItem
extends ProjectileWeaponItem {
    private static final int MAX_CHARGE_DURATION = 25;
    public static final int DEFAULT_RANGE = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    private static final float START_SOUND_PERCENT = 0.2f;
    private static final float MID_SOUND_PERCENT = 0.5f;
    private static final float ARROW_POWER = 3.15f;
    private static final float FIREWORK_POWER = 1.6f;
    public static final float MOB_ARROW_POWER = 1.6f;

    public CrossbowItem(Item.Properties $$0) {
        super($$0);
    }

    @Override
    public Predicate<ItemStack> getSupportedHeldProjectiles() {
        return ARROW_OR_FIREWORK;
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level $$0, Player $$1, InteractionHand $$2) {
        ItemStack $$3 = $$1.getItemInHand($$2);
        ChargedProjectiles $$4 = $$3.get(DataComponents.CHARGED_PROJECTILES);
        if ($$4 != null && !$$4.isEmpty()) {
            this.performShooting($$0, $$1, $$2, $$3, CrossbowItem.getShootingPower($$4), 1.0f, null);
            return InteractionResultHolder.consume($$3);
        }
        if (!$$1.getProjectile($$3).isEmpty()) {
            this.startSoundPlayed = false;
            this.midLoadSoundPlayed = false;
            $$1.startUsingItem($$2);
            return InteractionResultHolder.consume($$3);
        }
        return InteractionResultHolder.fail($$3);
    }

    private static float getShootingPower(ChargedProjectiles $$0) {
        if ($$0.contains(Items.FIREWORK_ROCKET)) {
            return 1.6f;
        }
        return 3.15f;
    }

    @Override
    public void releaseUsing(ItemStack $$0, Level $$1, LivingEntity $$2, int $$3) {
        int $$4 = this.getUseDuration($$0) - $$3;
        float $$5 = CrossbowItem.getPowerForTime($$4, $$0);
        if ($$5 >= 1.0f && !CrossbowItem.isCharged($$0) && CrossbowItem.tryLoadProjectiles($$2, $$0)) {
            $$1.playSound(null, $$2.getX(), $$2.getY(), $$2.getZ(), SoundEvents.CROSSBOW_LOADING_END, $$2.getSoundSource(), 1.0f, 1.0f / ($$1.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadProjectiles(LivingEntity $$0, ItemStack $$1) {
        List<ItemStack> $$2 = CrossbowItem.draw($$1, $$0.getProjectile($$1), $$0);
        if (!$$2.isEmpty()) {
            $$1.set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.of($$2));
            return true;
        }
        return false;
    }

    public static boolean isCharged(ItemStack $$0) {
        ChargedProjectiles $$1 = $$0.getOrDefault(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        return !$$1.isEmpty();
    }

    @Override
    protected void shootProjectile(LivingEntity $$0, Projectile $$1, int $$2, float $$3, float $$4, float $$5, @Nullable LivingEntity $$6) {
        Vector3f $$15;
        if ($$6 != null) {
            double $$7 = $$6.getX() - $$0.getX();
            double $$8 = $$6.getZ() - $$0.getZ();
            double $$9 = Math.sqrt($$7 * $$7 + $$8 * $$8);
            double $$10 = $$6.getY(0.3333333333333333) - $$1.getY() + $$9 * (double)0.2f;
            Vector3f $$11 = CrossbowItem.getProjectileShotVector($$0, new Vec3($$7, $$10, $$8), $$5);
        } else {
            Vec3 $$12 = $$0.getUpVector(1.0f);
            Quaternionf $$13 = new Quaternionf().setAngleAxis((double)($$5 * ((float)Math.PI / 180)), $$12.x, $$12.y, $$12.z);
            Vec3 $$14 = $$0.getViewVector(1.0f);
            $$15 = $$14.toVector3f().rotate((Quaternionfc)$$13);
        }
        $$1.shoot($$15.x(), $$15.y(), $$15.z(), $$3, $$4);
        float $$16 = CrossbowItem.getShotPitch($$0.getRandom(), $$2);
        $$0.level().playSound(null, $$0.getX(), $$0.getY(), $$0.getZ(), SoundEvents.CROSSBOW_SHOOT, $$0.getSoundSource(), 1.0f, $$16);
    }

    private static Vector3f getProjectileShotVector(LivingEntity $$0, Vec3 $$1, float $$2) {
        Vector3f $$3 = $$1.toVector3f().normalize();
        Vector3f $$4 = new Vector3f((Vector3fc)$$3).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)$$4.lengthSquared() <= 1.0E-7) {
            Vec3 $$5 = $$0.getUpVector(1.0f);
            $$4 = new Vector3f((Vector3fc)$$3).cross((Vector3fc)$$5.toVector3f());
        }
        Vector3f $$6 = new Vector3f((Vector3fc)$$3).rotateAxis(1.5707964f, $$4.x, $$4.y, $$4.z);
        return new Vector3f((Vector3fc)$$3).rotateAxis($$2 * ((float)Math.PI / 180), $$6.x, $$6.y, $$6.z);
    }

    @Override
    protected Projectile createProjectile(Level $$0, LivingEntity $$1, ItemStack $$2, ItemStack $$3, boolean $$4) {
        if ($$3.is(Items.FIREWORK_ROCKET)) {
            return new FireworkRocketEntity($$0, $$3, $$1, $$1.getX(), $$1.getEyeY() - (double)0.15f, $$1.getZ(), true);
        }
        Projectile $$5 = super.createProjectile($$0, $$1, $$2, $$3, $$4);
        if ($$5 instanceof AbstractArrow) {
            AbstractArrow $$6 = (AbstractArrow)$$5;
            $$6.setShotFromCrossbow(true);
            $$6.setSoundEvent(SoundEvents.CROSSBOW_HIT);
        }
        return $$5;
    }

    @Override
    protected int getDurabilityUse(ItemStack $$0) {
        return $$0.is(Items.FIREWORK_ROCKET) ? 3 : 1;
    }

    public void performShooting(Level $$0, LivingEntity $$1, InteractionHand $$2, ItemStack $$3, float $$4, float $$5, @Nullable LivingEntity $$6) {
        if ($$0.isClientSide()) {
            return;
        }
        ChargedProjectiles $$7 = $$3.set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        if ($$7 == null || $$7.isEmpty()) {
            return;
        }
        this.shoot($$0, $$1, $$2, $$3, $$7.getItems(), $$4, $$5, $$1 instanceof Player, $$6);
        if ($$1 instanceof ServerPlayer) {
            ServerPlayer $$8 = (ServerPlayer)$$1;
            CriteriaTriggers.SHOT_CROSSBOW.trigger($$8, $$3);
            $$8.awardStat(Stats.ITEM_USED.get($$3.getItem()));
        }
    }

    private static float getShotPitch(RandomSource $$0, int $$1) {
        if ($$1 == 0) {
            return 1.0f;
        }
        return CrossbowItem.getRandomShotPitch(($$1 & 1) == 1, $$0);
    }

    private static float getRandomShotPitch(boolean $$0, RandomSource $$1) {
        float $$2 = $$0 ? 0.63f : 0.43f;
        return 1.0f / ($$1.nextFloat() * 0.5f + 1.8f) + $$2;
    }

    @Override
    public void onUseTick(Level $$0, LivingEntity $$1, ItemStack $$2, int $$3) {
        if (!$$0.isClientSide) {
            int $$4 = EnchantmentHelper.getItemEnchantmentLevel(Enchantments.QUICK_CHARGE, $$2);
            SoundEvent $$5 = this.getStartSound($$4);
            SoundEvent $$6 = $$4 == 0 ? SoundEvents.CROSSBOW_LOADING_MIDDLE : null;
            float $$7 = (float)($$2.getUseDuration() - $$3) / (float)CrossbowItem.getChargeDuration($$2);
            if ($$7 < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if ($$7 >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                $$0.playSound(null, $$1.getX(), $$1.getY(), $$1.getZ(), $$5, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if ($$7 >= 0.5f && $$6 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                $$0.playSound(null, $$1.getX(), $$1.getY(), $$1.getZ(), $$6, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack $$0) {
        return CrossbowItem.getChargeDuration($$0) + 3;
    }

    public static int getChargeDuration(ItemStack $$0) {
        int $$1 = EnchantmentHelper.getItemEnchantmentLevel(Enchantments.QUICK_CHARGE, $$0);
        return $$1 == 0 ? 25 : 25 - 5 * $$1;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack $$0) {
        return UseAnim.CROSSBOW;
    }

    private SoundEvent getStartSound(int $$0) {
        switch ($$0) {
            case 1: {
                return SoundEvents.CROSSBOW_QUICK_CHARGE_1;
            }
            case 2: {
                return SoundEvents.CROSSBOW_QUICK_CHARGE_2;
            }
            case 3: {
                return SoundEvents.CROSSBOW_QUICK_CHARGE_3;
            }
        }
        return SoundEvents.CROSSBOW_LOADING_START;
    }

    private static float getPowerForTime(int $$0, ItemStack $$1) {
        float $$2 = (float)$$0 / (float)CrossbowItem.getChargeDuration($$1);
        if ($$2 > 1.0f) {
            $$2 = 1.0f;
        }
        return $$2;
    }

    @Override
    public void appendHoverText(ItemStack $$0, Item.TooltipContext $$1, List<Component> $$2, TooltipFlag $$3) {
        ChargedProjectiles $$4 = $$0.get(DataComponents.CHARGED_PROJECTILES);
        if ($$4 == null || $$4.isEmpty()) {
            return;
        }
        ItemStack $$5 = $$4.getItems().get(0);
        $$2.add(Component.translatable("item.minecraft.crossbow.projectile").append(CommonComponents.SPACE).append($$5.getDisplayName()));
        if ($$3.isAdvanced() && $$5.is(Items.FIREWORK_ROCKET)) {
            ArrayList $$6 = Lists.newArrayList();
            Items.FIREWORK_ROCKET.appendHoverText($$5, $$1, $$6, $$3);
            if (!$$6.isEmpty()) {
                for (int $$7 = 0; $$7 < $$6.size(); ++$$7) {
                    $$6.set($$7, Component.literal("  ").append((Component)$$6.get($$7)).withStyle(ChatFormatting.GRAY));
                }
                $$2.addAll($$6);
            }
        }
    }

    @Override
    public boolean useOnRelease(ItemStack $$0) {
        return $$0.is(this);
    }

    @Override
    public int getDefaultProjectileRange() {
        return 8;
    }
}

