/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class RecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HolderLookup.Provider registries;
    private Multimap<RecipeType<?>, RecipeHolder<?>> byType = ImmutableMultimap.of();
    private Map<ResourceLocation, RecipeHolder<?>> byName = ImmutableMap.of();
    private boolean hasErrors;

    public RecipeManager(HolderLookup.Provider $$0) {
        super(GSON, "recipes");
        this.registries = $$0;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> $$0, ResourceManager $$1, ProfilerFiller $$2) {
        this.hasErrors = false;
        ImmutableMultimap.Builder $$3 = ImmutableMultimap.builder();
        ImmutableMap.Builder $$4 = ImmutableMap.builder();
        RegistryOps $$5 = this.registries.createSerializationContext(JsonOps.INSTANCE);
        for (Map.Entry<ResourceLocation, JsonElement> $$6 : $$0.entrySet()) {
            ResourceLocation $$7 = $$6.getKey();
            try {
                Recipe $$8 = (Recipe)Recipe.CODEC.parse($$5, (Object)$$6.getValue()).getOrThrow(JsonParseException::new);
                RecipeHolder<Recipe> $$9 = new RecipeHolder<Recipe>($$7, $$8);
                $$3.put($$8.getType(), $$9);
                $$4.put((Object)$$7, $$9);
            }
            catch (JsonParseException | IllegalArgumentException $$10) {
                LOGGER.error("Parsing error loading recipe {}", (Object)$$7, (Object)$$10);
            }
        }
        this.byType = $$3.build();
        this.byName = $$4.build();
        LOGGER.info("Loaded {} recipes", (Object)this.byType.size());
    }

    public boolean hadErrorsLoading() {
        return this.hasErrors;
    }

    public <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> $$0, C $$1, Level $$22) {
        return this.byType($$0).stream().filter($$2 -> $$2.value().matches($$1, $$22)).findFirst();
    }

    public <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> $$0, C $$1, Level $$22, @Nullable ResourceLocation $$3) {
        RecipeHolder<T> $$4;
        if ($$3 != null && ($$4 = this.byKeyTyped($$0, $$3)) != null && $$4.value().matches($$1, $$22)) {
            return Optional.of($$4);
        }
        return this.byType($$0).stream().filter($$2 -> $$2.value().matches($$1, $$22)).findFirst();
    }

    public <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> getAllRecipesFor(RecipeType<T> $$0) {
        return List.copyOf(this.byType($$0));
    }

    public <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> getRecipesFor(RecipeType<T> $$0, C $$12, Level $$22) {
        return this.byType($$0).stream().filter($$2 -> $$2.value().matches($$12, $$22)).sorted(Comparator.comparing($$1 -> $$1.value().getResultItem($$22.registryAccess()).getDescriptionId())).collect(Collectors.toList());
    }

    private <C extends Container, T extends Recipe<C>> Collection<RecipeHolder<T>> byType(RecipeType<T> $$0) {
        return this.byType.get($$0);
    }

    public <C extends Container, T extends Recipe<C>> NonNullList<ItemStack> getRemainingItemsFor(RecipeType<T> $$0, C $$1, Level $$2) {
        Optional<RecipeHolder<T>> $$3 = this.getRecipeFor($$0, $$1, $$2);
        if ($$3.isPresent()) {
            return $$3.get().value().getRemainingItems($$1);
        }
        NonNullList<ItemStack> $$4 = NonNullList.withSize($$1.getContainerSize(), ItemStack.EMPTY);
        for (int $$5 = 0; $$5 < $$4.size(); ++$$5) {
            $$4.set($$5, $$1.getItem($$5));
        }
        return $$4;
    }

    public Optional<RecipeHolder<?>> byKey(ResourceLocation $$0) {
        return Optional.ofNullable(this.byName.get($$0));
    }

    @Nullable
    private <T extends Recipe<?>> RecipeHolder<T> byKeyTyped(RecipeType<T> $$0, ResourceLocation $$1) {
        RecipeHolder<?> $$2 = this.byName.get($$1);
        if ($$2 != null && $$2.value().getType().equals($$0)) {
            return $$2;
        }
        return null;
    }

    public Collection<RecipeHolder<?>> getOrderedRecipes() {
        return this.byType.values();
    }

    public Collection<RecipeHolder<?>> getRecipes() {
        return this.byName.values();
    }

    public Stream<ResourceLocation> getRecipeIds() {
        return this.byName.keySet().stream();
    }

    @VisibleForTesting
    protected static RecipeHolder<?> fromJson(ResourceLocation $$0, JsonObject $$1, HolderLookup.Provider $$2) {
        Recipe $$3 = (Recipe)Recipe.CODEC.parse($$2.createSerializationContext(JsonOps.INSTANCE), (Object)$$1).getOrThrow(JsonParseException::new);
        return new RecipeHolder<Recipe>($$0, $$3);
    }

    public void replaceRecipes(Iterable<RecipeHolder<?>> $$0) {
        this.hasErrors = false;
        ImmutableMultimap.Builder $$1 = ImmutableMultimap.builder();
        ImmutableMap.Builder $$2 = ImmutableMap.builder();
        for (RecipeHolder<?> $$3 : $$0) {
            RecipeType<?> $$4 = $$3.value().getType();
            $$1.put($$4, $$3);
            $$2.put((Object)$$3.id(), $$3);
        }
        this.byType = $$1.build();
        this.byName = $$2.build();
    }

    public static <C extends Container, T extends Recipe<C>> CachedCheck<C, T> createCheck(final RecipeType<T> $$0) {
        return new CachedCheck<C, T>(){
            @Nullable
            private ResourceLocation lastRecipe;

            @Override
            public Optional<RecipeHolder<T>> getRecipeFor(C $$02, Level $$1) {
                RecipeManager $$2 = $$1.getRecipeManager();
                Optional $$3 = $$2.getRecipeFor($$0, $$02, $$1, this.lastRecipe);
                if ($$3.isPresent()) {
                    RecipeHolder $$4 = $$3.get();
                    this.lastRecipe = $$4.id();
                    return Optional.of($$4);
                }
                return Optional.empty();
            }
        };
    }

    public static interface CachedCheck<C extends Container, T extends Recipe<C>> {
        public Optional<RecipeHolder<T>> getRecipeFor(C var1, Level var2);
    }
}

