/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class RepairItemRecipe
extends CustomRecipe {
    public RepairItemRecipe(CraftingBookCategory $$0) {
        super($$0);
    }

    @Nullable
    private Pair<ItemStack, ItemStack> getItemsToCombine(CraftingContainer $$0) {
        ItemStack $$1 = null;
        ItemStack $$2 = null;
        for (int $$3 = 0; $$3 < $$0.getContainerSize(); ++$$3) {
            ItemStack $$4 = $$0.getItem($$3);
            if ($$4.isEmpty()) continue;
            if ($$1 == null) {
                $$1 = $$4;
                continue;
            }
            if ($$2 == null) {
                $$2 = $$4;
                continue;
            }
            return null;
        }
        if ($$1 != null && $$2 != null && RepairItemRecipe.canCombine($$1, $$2)) {
            return Pair.of((Object)$$1, $$2);
        }
        return null;
    }

    private static boolean canCombine(ItemStack $$0, ItemStack $$1) {
        return $$1.is($$0.getItem()) && $$0.getCount() == 1 && $$1.getCount() == 1 && $$0.has(DataComponents.MAX_DAMAGE) && $$1.has(DataComponents.MAX_DAMAGE) && $$0.has(DataComponents.DAMAGE) && $$1.has(DataComponents.DAMAGE);
    }

    @Override
    public boolean matches(CraftingContainer $$0, Level $$1) {
        return this.getItemsToCombine($$0) != null;
    }

    @Override
    public ItemStack assemble(CraftingContainer $$0, HolderLookup.Provider $$1) {
        Pair<ItemStack, ItemStack> $$2 = this.getItemsToCombine($$0);
        if ($$2 == null) {
            return ItemStack.EMPTY;
        }
        ItemStack $$3 = (ItemStack)$$2.getFirst();
        ItemStack $$4 = (ItemStack)$$2.getSecond();
        int $$5 = Math.max($$3.getMaxDamage(), $$4.getMaxDamage());
        int $$6 = $$3.getMaxDamage() - $$3.getDamageValue();
        int $$7 = $$4.getMaxDamage() - $$4.getDamageValue();
        int $$8 = $$6 + $$7 + $$5 * 5 / 100;
        ItemStack $$9 = new ItemStack($$3.getItem());
        $$9.set(DataComponents.MAX_DAMAGE, $$5);
        $$9.setDamageValue(Math.max($$5 - $$8, 0));
        ItemEnchantments $$10 = EnchantmentHelper.getEnchantmentsForCrafting($$3);
        ItemEnchantments $$11 = EnchantmentHelper.getEnchantmentsForCrafting($$4);
        EnchantmentHelper.updateEnchantments($$9, $$32 -> $$1.lookupOrThrow(Registries.ENCHANTMENT).listElements().map(Holder::value).filter(Enchantment::isCurse).forEach($$3 -> {
            int $$4 = Math.max($$10.getLevel((Enchantment)$$3), $$11.getLevel((Enchantment)$$3));
            if ($$4 > 0) {
                $$32.upgrade((Enchantment)$$3, $$4);
            }
        }));
        return $$9;
    }

    @Override
    public boolean canCraftInDimensions(int $$0, int $$1) {
        return $$0 * $$1 >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.REPAIR_ITEM;
    }
}

