/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.Ingredient;

public record ShapedRecipePattern(int width, int height, NonNullList<Ingredient> ingredients, Optional<Data> data) {
    private static final int MAX_SIZE = 3;
    public static final MapCodec<ShapedRecipePattern> MAP_CODEC = Data.MAP_CODEC.flatXmap(ShapedRecipePattern::unpack, $$0 -> $$0.data().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Cannot encode unpacked recipe")));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapedRecipePattern> STREAM_CODEC = StreamCodec.ofMember(ShapedRecipePattern::toNetwork, ShapedRecipePattern::fromNetwork);

    public static ShapedRecipePattern of(Map<Character, Ingredient> $$0, String ... $$1) {
        return ShapedRecipePattern.of($$0, List.of($$1));
    }

    public static ShapedRecipePattern of(Map<Character, Ingredient> $$0, List<String> $$1) {
        Data $$2 = new Data($$0, $$1);
        return (ShapedRecipePattern)ShapedRecipePattern.unpack($$2).getOrThrow();
    }

    private static DataResult<ShapedRecipePattern> unpack(Data $$0) {
        String[] $$1 = ShapedRecipePattern.shrink($$0.pattern);
        int $$2 = $$1[0].length();
        int $$3 = $$1.length;
        NonNullList<Ingredient> $$4 = NonNullList.withSize($$2 * $$3, Ingredient.EMPTY);
        CharArraySet $$5 = new CharArraySet($$0.key.keySet());
        for (int $$6 = 0; $$6 < $$1.length; ++$$6) {
            String $$7 = $$1[$$6];
            for (int $$8 = 0; $$8 < $$7.length(); ++$$8) {
                Ingredient $$10;
                char $$9 = $$7.charAt($$8);
                Ingredient ingredient = $$10 = $$9 == ' ' ? Ingredient.EMPTY : $$0.key.get(Character.valueOf($$9));
                if ($$10 == null) {
                    return DataResult.error(() -> "Pattern references symbol '" + $$9 + "' but it's not defined in the key");
                }
                $$5.remove($$9);
                $$4.set($$8 + $$2 * $$6, $$10);
            }
        }
        if (!$$5.isEmpty()) {
            return DataResult.error(() -> ShapedRecipePattern.lambda$unpack$4((CharSet)$$5));
        }
        return DataResult.success((Object)new ShapedRecipePattern($$2, $$3, $$4, Optional.of($$0)));
    }

    @VisibleForTesting
    static String[] shrink(List<String> $$0) {
        int $$1 = Integer.MAX_VALUE;
        int $$2 = 0;
        int $$3 = 0;
        int $$4 = 0;
        for (int $$5 = 0; $$5 < $$0.size(); ++$$5) {
            String $$6 = $$0.get($$5);
            $$1 = Math.min($$1, ShapedRecipePattern.firstNonSpace($$6));
            int $$7 = ShapedRecipePattern.lastNonSpace($$6);
            $$2 = Math.max($$2, $$7);
            if ($$7 < 0) {
                if ($$3 == $$5) {
                    ++$$3;
                }
                ++$$4;
                continue;
            }
            $$4 = 0;
        }
        if ($$0.size() == $$4) {
            return new String[0];
        }
        String[] $$8 = new String[$$0.size() - $$4 - $$3];
        for (int $$9 = 0; $$9 < $$8.length; ++$$9) {
            $$8[$$9] = $$0.get($$9 + $$3).substring($$1, $$2 + 1);
        }
        return $$8;
    }

    private static int firstNonSpace(String $$0) {
        int $$1;
        for ($$1 = 0; $$1 < $$0.length() && $$0.charAt($$1) == ' '; ++$$1) {
        }
        return $$1;
    }

    private static int lastNonSpace(String $$0) {
        int $$1;
        for ($$1 = $$0.length() - 1; $$1 >= 0 && $$0.charAt($$1) == ' '; --$$1) {
        }
        return $$1;
    }

    public boolean matches(CraftingContainer $$0) {
        for (int $$1 = 0; $$1 <= $$0.getWidth() - this.width; ++$$1) {
            for (int $$2 = 0; $$2 <= $$0.getHeight() - this.height; ++$$2) {
                if (this.matches($$0, $$1, $$2, true)) {
                    return true;
                }
                if (!this.matches($$0, $$1, $$2, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer $$0, int $$1, int $$2, boolean $$3) {
        for (int $$4 = 0; $$4 < $$0.getWidth(); ++$$4) {
            for (int $$5 = 0; $$5 < $$0.getHeight(); ++$$5) {
                int $$6 = $$4 - $$1;
                int $$7 = $$5 - $$2;
                Ingredient $$8 = Ingredient.EMPTY;
                if ($$6 >= 0 && $$7 >= 0 && $$6 < this.width && $$7 < this.height) {
                    $$8 = $$3 ? this.ingredients.get(this.width - $$6 - 1 + $$7 * this.width) : this.ingredients.get($$6 + $$7 * this.width);
                }
                if ($$8.test($$0.getItem($$4 + $$5 * $$0.getWidth()))) continue;
                return false;
            }
        }
        return true;
    }

    private void toNetwork(RegistryFriendlyByteBuf $$0) {
        $$0.writeVarInt(this.width);
        $$0.writeVarInt(this.height);
        for (Ingredient $$1 : this.ingredients) {
            Ingredient.CONTENTS_STREAM_CODEC.encode($$0, $$1);
        }
    }

    private static ShapedRecipePattern fromNetwork(RegistryFriendlyByteBuf $$0) {
        int $$12 = $$0.readVarInt();
        int $$2 = $$0.readVarInt();
        NonNullList<Ingredient> $$3 = NonNullList.withSize($$12 * $$2, Ingredient.EMPTY);
        $$3.replaceAll($$1 -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode($$0));
        return new ShapedRecipePattern($$12, $$2, $$3, Optional.empty());
    }

    private static /* synthetic */ String lambda$unpack$4(CharSet $$0) {
        return "Key defines symbols that aren't used in pattern: " + String.valueOf($$0);
    }

    public record Data(Map<Character, Ingredient> key, List<String> pattern) {
        private static final Codec<List<String>> PATTERN_CODEC = Codec.STRING.listOf().comapFlatMap($$0 -> {
            if ($$0.size() > 3) {
                return DataResult.error(() -> "Invalid pattern: too many rows, 3 is maximum");
            }
            if ($$0.isEmpty()) {
                return DataResult.error(() -> "Invalid pattern: empty pattern not allowed");
            }
            int $$1 = ((String)$$0.get(0)).length();
            for (String $$2 : $$0) {
                if ($$2.length() > 3) {
                    return DataResult.error(() -> "Invalid pattern: too many columns, 3 is maximum");
                }
                if ($$1 == $$2.length()) continue;
                return DataResult.error(() -> "Invalid pattern: each row must be the same width");
            }
            return DataResult.success((Object)$$0);
        }, Function.identity());
        private static final Codec<Character> SYMBOL_CODEC = Codec.STRING.comapFlatMap($$0 -> {
            if ($$0.length() != 1) {
                return DataResult.error(() -> "Invalid key entry: '" + $$0 + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals($$0)) {
                return DataResult.error(() -> "Invalid key entry: ' ' is a reserved symbol.");
            }
            return DataResult.success((Object)Character.valueOf($$0.charAt(0)));
        }, String::valueOf);
        public static final MapCodec<Data> MAP_CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)ExtraCodecs.strictUnboundedMap(SYMBOL_CODEC, Ingredient.CODEC_NONEMPTY).fieldOf("key").forGetter($$0 -> $$0.key), (App)PATTERN_CODEC.fieldOf("pattern").forGetter($$0 -> $$0.pattern)).apply((Applicative)$$02, Data::new));
    }
}

