/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;

public class SmithingTrimRecipe
implements SmithingRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;

    public SmithingTrimRecipe(Ingredient $$0, Ingredient $$1, Ingredient $$2) {
        this.template = $$0;
        this.base = $$1;
        this.addition = $$2;
    }

    @Override
    public boolean matches(Container $$0, Level $$1) {
        return this.template.test($$0.getItem(0)) && this.base.test($$0.getItem(1)) && this.addition.test($$0.getItem(2));
    }

    @Override
    public ItemStack assemble(Container $$0, HolderLookup.Provider $$1) {
        ItemStack $$2 = $$0.getItem(1);
        if (this.base.test($$2)) {
            Optional<Holder.Reference<TrimMaterial>> $$3 = TrimMaterials.getFromIngredient($$1, $$0.getItem(2));
            Optional<Holder.Reference<TrimPattern>> $$4 = TrimPatterns.getFromTemplate($$1, $$0.getItem(0));
            if ($$3.isPresent() && $$4.isPresent()) {
                ArmorTrim $$5 = $$2.get(DataComponents.TRIM);
                if ($$5 != null && $$5.hasPatternAndMaterial((Holder<TrimPattern>)$$4.get(), (Holder<TrimMaterial>)$$3.get())) {
                    return ItemStack.EMPTY;
                }
                ItemStack $$6 = $$2.copyWithCount(1);
                $$6.set(DataComponents.TRIM, new ArmorTrim((Holder<TrimMaterial>)$$3.get(), (Holder<TrimPattern>)$$4.get()));
                return $$6;
            }
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider $$0) {
        ItemStack $$1 = new ItemStack(Items.IRON_CHESTPLATE);
        Optional $$2 = $$0.lookupOrThrow(Registries.TRIM_PATTERN).listElements().findFirst();
        Optional<Holder.Reference<TrimMaterial>> $$3 = $$0.lookupOrThrow(Registries.TRIM_MATERIAL).get(TrimMaterials.REDSTONE);
        if ($$2.isPresent() && $$3.isPresent()) {
            $$1.set(DataComponents.TRIM, new ArmorTrim((Holder<TrimMaterial>)$$3.get(), $$2.get()));
        }
        return $$1;
    }

    @Override
    public boolean isTemplateIngredient(ItemStack $$0) {
        return this.template.test($$0);
    }

    @Override
    public boolean isBaseIngredient(ItemStack $$0) {
        return this.base.test($$0);
    }

    @Override
    public boolean isAdditionIngredient(ItemStack $$0) {
        return this.addition.test($$0);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SMITHING_TRIM;
    }

    @Override
    public boolean isIncomplete() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(Ingredient::isEmpty);
    }

    public static class Serializer
    implements RecipeSerializer<SmithingTrimRecipe> {
        private static final MapCodec<SmithingTrimRecipe> CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)Ingredient.CODEC.fieldOf("template").forGetter($$0 -> $$0.template), (App)Ingredient.CODEC.fieldOf("base").forGetter($$0 -> $$0.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter($$0 -> $$0.addition)).apply((Applicative)$$02, SmithingTrimRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @Override
        public MapCodec<SmithingTrimRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SmithingTrimRecipe fromNetwork(RegistryFriendlyByteBuf $$0) {
            Ingredient $$1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode($$0);
            Ingredient $$2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode($$0);
            Ingredient $$3 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode($$0);
            return new SmithingTrimRecipe($$1, $$2, $$3);
        }

        private static void toNetwork(RegistryFriendlyByteBuf $$0, SmithingTrimRecipe $$1) {
            Ingredient.CONTENTS_STREAM_CODEC.encode($$0, $$1.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode($$0, $$1.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode($$0, $$1.addition);
        }
    }
}

