/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.BreachEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class EnchantmentHelper {
    private static final float SWIFT_SNEAK_EXTRA_FACTOR = 0.15f;

    public static int getItemEnchantmentLevel(Enchantment $$0, ItemStack $$1) {
        ItemEnchantments $$2 = $$1.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        return $$2.getLevel($$0);
    }

    public static ItemEnchantments updateEnchantments(ItemStack $$0, Consumer<ItemEnchantments.Mutable> $$1) {
        DataComponentType<ItemEnchantments> $$2 = EnchantmentHelper.getComponentType($$0);
        ItemEnchantments $$3 = $$0.get($$2);
        if ($$3 == null) {
            return ItemEnchantments.EMPTY;
        }
        ItemEnchantments.Mutable $$4 = new ItemEnchantments.Mutable($$3);
        $$1.accept($$4);
        ItemEnchantments $$5 = $$4.toImmutable();
        $$0.set($$2, $$5);
        return $$5;
    }

    public static boolean canStoreEnchantments(ItemStack $$0) {
        return $$0.has(EnchantmentHelper.getComponentType($$0));
    }

    public static void setEnchantments(ItemStack $$0, ItemEnchantments $$1) {
        $$0.set(EnchantmentHelper.getComponentType($$0), $$1);
    }

    public static ItemEnchantments getEnchantmentsForCrafting(ItemStack $$0) {
        return $$0.getOrDefault(EnchantmentHelper.getComponentType($$0), ItemEnchantments.EMPTY);
    }

    private static DataComponentType<ItemEnchantments> getComponentType(ItemStack $$0) {
        return $$0.is(Items.ENCHANTED_BOOK) ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS;
    }

    public static boolean hasAnyEnchantments(ItemStack $$0) {
        return !$$0.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty() || !$$0.getOrDefault(DataComponents.STORED_ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public static float getSweepingDamageRatio(int $$0) {
        return 1.0f - 1.0f / (float)($$0 + 1);
    }

    private static void runIterationOnItem(EnchantmentVisitor $$0, ItemStack $$1) {
        ItemEnchantments $$2 = $$1.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry<Holder<Enchantment>> $$3 : $$2.entrySet()) {
            $$0.accept((Enchantment)((Holder)$$3.getKey()).value(), $$3.getIntValue());
        }
    }

    private static void runIterationOnInventory(EnchantmentVisitor $$0, Iterable<ItemStack> $$1) {
        for (ItemStack $$2 : $$1) {
            EnchantmentHelper.runIterationOnItem($$0, $$2);
        }
    }

    public static int getDamageProtection(Iterable<ItemStack> $$0, DamageSource $$1) {
        MutableInt $$22 = new MutableInt();
        EnchantmentHelper.runIterationOnInventory(($$2, $$3) -> $$22.add($$2.getDamageProtection($$3, $$1)), $$0);
        return $$22.intValue();
    }

    public static float getDamageBonus(ItemStack $$0, @Nullable EntityType<?> $$1) {
        MutableFloat $$22 = new MutableFloat();
        EnchantmentHelper.runIterationOnItem(($$2, $$3) -> $$22.add($$2.getDamageBonus($$3, $$1)), $$0);
        return $$22.floatValue();
    }

    public static float getSweepingDamageRatio(LivingEntity $$0) {
        int $$1 = EnchantmentHelper.getEnchantmentLevel(Enchantments.SWEEPING_EDGE, $$0);
        if ($$1 > 0) {
            return EnchantmentHelper.getSweepingDamageRatio($$1);
        }
        return 0.0f;
    }

    public static float calculateArmorBreach(@Nullable Entity $$0, float $$1) {
        LivingEntity $$2;
        int $$3;
        if ($$0 instanceof LivingEntity && ($$3 = EnchantmentHelper.getEnchantmentLevel(Enchantments.BREACH, $$2 = (LivingEntity)$$0)) > 0) {
            return BreachEnchantment.calculateArmorBreach($$3, $$1);
        }
        return $$1;
    }

    public static void doPostHurtEffects(LivingEntity $$0, Entity $$1) {
        EnchantmentVisitor $$22 = ($$2, $$3) -> $$2.doPostHurt($$0, $$1, $$3);
        if ($$0 != null) {
            EnchantmentHelper.runIterationOnInventory($$22, $$0.getAllSlots());
        }
        if ($$1 instanceof Player) {
            EnchantmentHelper.runIterationOnItem($$22, $$0.getMainHandItem());
        }
    }

    public static void doPostDamageEffects(LivingEntity $$0, Entity $$1) {
        EnchantmentVisitor $$22 = ($$2, $$3) -> $$2.doPostAttack($$0, $$1, $$3);
        if ($$0 != null) {
            EnchantmentHelper.runIterationOnInventory($$22, $$0.getAllSlots());
        }
        if ($$0 instanceof Player) {
            EnchantmentHelper.runIterationOnItem($$22, $$0.getMainHandItem());
        }
    }

    public static void doPostItemStackHurtEffects(LivingEntity $$0, Entity $$1, ItemEnchantments $$2) {
        for (Object2IntMap.Entry<Holder<Enchantment>> $$3 : $$2.entrySet()) {
            ((Enchantment)((Holder)$$3.getKey()).value()).doPostItemStackHurt($$0, $$1, $$3.getIntValue());
        }
    }

    public static int getEnchantmentLevel(Enchantment $$0, LivingEntity $$1) {
        Collection<ItemStack> $$2 = $$0.getSlotItems($$1).values();
        if ($$2 == null) {
            return 0;
        }
        int $$3 = 0;
        for (ItemStack $$4 : $$2) {
            int $$5 = EnchantmentHelper.getItemEnchantmentLevel($$0, $$4);
            if ($$5 <= $$3) continue;
            $$3 = $$5;
        }
        return $$3;
    }

    public static float getSneakingSpeedBonus(LivingEntity $$0) {
        return (float)EnchantmentHelper.getEnchantmentLevel(Enchantments.SWIFT_SNEAK, $$0) * 0.15f;
    }

    public static int getKnockbackBonus(LivingEntity $$0) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.KNOCKBACK, $$0);
    }

    public static int getFireAspect(LivingEntity $$0) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FIRE_ASPECT, $$0);
    }

    public static int getRespiration(LivingEntity $$0) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.RESPIRATION, $$0);
    }

    public static int getDepthStrider(LivingEntity $$0) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.DEPTH_STRIDER, $$0);
    }

    public static int getBlockEfficiency(LivingEntity $$0) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.EFFICIENCY, $$0);
    }

    public static int getFishingLuckBonus(ItemStack $$0) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LUCK_OF_THE_SEA, $$0);
    }

    public static int getFishingSpeedBonus(ItemStack $$0) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LURE, $$0);
    }

    public static int getMobLooting(LivingEntity $$0) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.LOOTING, $$0);
    }

    public static boolean hasAquaAffinity(LivingEntity $$0) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.AQUA_AFFINITY, $$0) > 0;
    }

    public static boolean hasFrostWalker(LivingEntity $$0) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.FROST_WALKER, $$0) > 0;
    }

    public static boolean hasSoulSpeed(LivingEntity $$0) {
        return EnchantmentHelper.getEnchantmentLevel(Enchantments.SOUL_SPEED, $$0) > 0;
    }

    public static boolean hasBindingCurse(ItemStack $$0) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.BINDING_CURSE, $$0) > 0;
    }

    public static boolean hasVanishingCurse(ItemStack $$0) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.VANISHING_CURSE, $$0) > 0;
    }

    public static boolean hasSilkTouch(ItemStack $$0) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.SILK_TOUCH, $$0) > 0;
    }

    public static int getLoyalty(ItemStack $$0) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.LOYALTY, $$0);
    }

    public static int getRiptide(ItemStack $$0) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.RIPTIDE, $$0);
    }

    public static boolean hasChanneling(ItemStack $$0) {
        return EnchantmentHelper.getItemEnchantmentLevel(Enchantments.CHANNELING, $$0) > 0;
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment $$02, LivingEntity $$1) {
        return EnchantmentHelper.getRandomItemWith($$02, $$1, $$0 -> true);
    }

    @Nullable
    public static Map.Entry<EquipmentSlot, ItemStack> getRandomItemWith(Enchantment $$0, LivingEntity $$1, Predicate<ItemStack> $$2) {
        Map<EquipmentSlot, ItemStack> $$3 = $$0.getSlotItems($$1);
        if ($$3.isEmpty()) {
            return null;
        }
        ArrayList $$4 = Lists.newArrayList();
        for (Map.Entry<EquipmentSlot, ItemStack> $$5 : $$3.entrySet()) {
            ItemStack $$6 = $$5.getValue();
            if ($$6.isEmpty() || EnchantmentHelper.getItemEnchantmentLevel($$0, $$6) <= 0 || !$$2.test($$6)) continue;
            $$4.add($$5);
        }
        return $$4.isEmpty() ? null : (Map.Entry)$$4.get($$1.getRandom().nextInt($$4.size()));
    }

    public static int getEnchantmentCost(RandomSource $$0, int $$1, int $$2, ItemStack $$3) {
        Item $$4 = $$3.getItem();
        int $$5 = $$4.getEnchantmentValue();
        if ($$5 <= 0) {
            return 0;
        }
        if ($$2 > 15) {
            $$2 = 15;
        }
        int $$6 = $$0.nextInt(8) + 1 + ($$2 >> 1) + $$0.nextInt($$2 + 1);
        if ($$1 == 0) {
            return Math.max($$6 / 3, 1);
        }
        if ($$1 == 1) {
            return $$6 * 2 / 3 + 1;
        }
        return Math.max($$6, $$2 * 2);
    }

    public static ItemStack enchantItem(FeatureFlagSet $$0, RandomSource $$1, ItemStack $$2, int $$3, boolean $$4) {
        List<EnchantmentInstance> $$5 = EnchantmentHelper.selectEnchantment($$0, $$1, $$2, $$3, $$4);
        if ($$2.is(Items.BOOK)) {
            $$2 = new ItemStack(Items.ENCHANTED_BOOK);
        }
        for (EnchantmentInstance $$6 : $$5) {
            $$2.enchant($$6.enchantment, $$6.level);
        }
        return $$2;
    }

    public static List<EnchantmentInstance> selectEnchantment(FeatureFlagSet $$0, RandomSource $$1, ItemStack $$2, int $$3, boolean $$4) {
        ArrayList $$5 = Lists.newArrayList();
        Item $$6 = $$2.getItem();
        int $$7 = $$6.getEnchantmentValue();
        if ($$7 <= 0) {
            return $$5;
        }
        $$3 += 1 + $$1.nextInt($$7 / 4 + 1) + $$1.nextInt($$7 / 4 + 1);
        float $$8 = ($$1.nextFloat() + $$1.nextFloat() - 1.0f) * 0.15f;
        List<EnchantmentInstance> $$9 = EnchantmentHelper.getAvailableEnchantmentResults($$0, $$3 = Mth.clamp(Math.round((float)$$3 + (float)$$3 * $$8), 1, Integer.MAX_VALUE), $$2, $$4);
        if (!$$9.isEmpty()) {
            WeightedRandom.getRandomItem($$1, $$9).ifPresent($$5::add);
            while ($$1.nextInt(50) <= $$3) {
                if (!$$5.isEmpty()) {
                    EnchantmentHelper.filterCompatibleEnchantments($$9, (EnchantmentInstance)Util.lastOf($$5));
                }
                if ($$9.isEmpty()) break;
                WeightedRandom.getRandomItem($$1, $$9).ifPresent($$5::add);
                $$3 /= 2;
            }
        }
        return $$5;
    }

    public static void filterCompatibleEnchantments(List<EnchantmentInstance> $$0, EnchantmentInstance $$1) {
        Iterator<EnchantmentInstance> $$2 = $$0.iterator();
        while ($$2.hasNext()) {
            if ($$1.enchantment.isCompatibleWith($$2.next().enchantment)) continue;
            $$2.remove();
        }
    }

    public static boolean isEnchantmentCompatible(Collection<Holder<Enchantment>> $$0, Enchantment $$1) {
        for (Holder<Enchantment> $$2 : $$0) {
            if ($$2.value().isCompatibleWith($$1)) continue;
            return false;
        }
        return true;
    }

    public static List<EnchantmentInstance> getAvailableEnchantmentResults(FeatureFlagSet $$0, int $$1, ItemStack $$2, boolean $$3) {
        ArrayList $$4 = Lists.newArrayList();
        boolean $$5 = $$2.is(Items.BOOK);
        block0: for (Enchantment $$6 : BuiltInRegistries.ENCHANTMENT) {
            if (!$$6.isEnabled($$0) || $$6.isTreasureOnly() && !$$3 || !$$6.isDiscoverable() || !$$5 && (!$$6.canEnchant($$2) || !$$6.isPrimaryItem($$2))) continue;
            for (int $$7 = $$6.getMaxLevel(); $$7 > $$6.getMinLevel() - 1; --$$7) {
                if ($$1 < $$6.getMinCost($$7) || $$1 > $$6.getMaxCost($$7)) continue;
                $$4.add(new EnchantmentInstance($$6, $$7));
                continue block0;
            }
        }
        return $$4;
    }

    @FunctionalInterface
    static interface EnchantmentVisitor {
        public void accept(Enchantment var1, int var2);
    }
}

