/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class WindBurstEnchantment
extends Enchantment {
    public WindBurstEnchantment() {
        super(Enchantment.definition(ItemTags.MACE_ENCHANTABLE, 2, 3, Enchantment.dynamicCost(15, 9), Enchantment.dynamicCost(65, 9), 4, FeatureFlagSet.of(FeatureFlags.UPDATE_1_21), EquipmentSlot.MAINHAND));
    }

    @Override
    public void doPostItemStackHurt(LivingEntity $$0, Entity $$1, int $$2) {
        float $$3 = 0.25f + 0.25f * (float)$$2;
        $$0.level().explode(null, null, new WindBurstEnchantmentDamageCalculator($$3), $$0.getX(), $$0.getY(), $$0.getZ(), 3.5f, false, Level.ExplosionInteraction.BLOW, ParticleTypes.GUST_EMITTER_SMALL, ParticleTypes.GUST_EMITTER_LARGE, SoundEvents.WIND_CHARGE_BURST);
    }

    @Override
    public boolean isTradeable() {
        return false;
    }

    @Override
    public boolean isDiscoverable() {
        return false;
    }

    static final class WindBurstEnchantmentDamageCalculator
    extends AbstractWindCharge.WindChargeDamageCalculator {
        private final float knockBackPower;

        public WindBurstEnchantmentDamageCalculator(float $$0) {
            this.knockBackPower = $$0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public float getKnockbackMultiplier(Entity $$0) {
            if ($$0 instanceof Player) {
                Player $$1 = (Player)$$0;
                if ($$1.getAbilities().flying) {
                    return 0.0f;
                }
            }
            boolean bl = false;
            boolean $$2 = bl;
            if ($$2) return 0.0f;
            float f = this.knockBackPower;
            return f;
        }
    }
}

