/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTicks;
import org.slf4j.Logger;

public class ChunkSerializer {
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW(Block.BLOCK_STATE_REGISTRY, BlockState.CODEC, PalettedContainer.Strategy.SECTION_STATES, Blocks.AIR.defaultBlockState());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    public static ProtoChunk read(ServerLevel $$02, PoiManager $$1, ChunkPos $$22, CompoundTag $$3) {
        ProtoChunk $$38;
        BlendingData $$31;
        ChunkPos $$4 = new ChunkPos($$3.getInt(X_POS_TAG), $$3.getInt(Z_POS_TAG));
        if (!Objects.equals($$22, $$4)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{$$22, $$22, $$4});
        }
        UpgradeData $$5 = $$3.contains(TAG_UPGRADE_DATA, 10) ? new UpgradeData($$3.getCompound(TAG_UPGRADE_DATA), $$02) : UpgradeData.EMPTY;
        boolean $$6 = $$3.getBoolean(IS_LIGHT_ON_TAG);
        ListTag $$7 = $$3.getList(SECTIONS_TAG, 10);
        int $$8 = $$02.getSectionsCount();
        LevelChunkSection[] $$9 = new LevelChunkSection[$$8];
        boolean $$10 = $$02.dimensionType().hasSkyLight();
        ServerChunkCache $$11 = $$02.getChunkSource();
        LevelLightEngine $$12 = ((ChunkSource)$$11).getLightEngine();
        Registry<Biome> $$13 = $$02.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> $$14 = ChunkSerializer.makeBiomeCodec($$13);
        boolean $$15 = false;
        for (int $$16 = 0; $$16 < $$7.size(); ++$$16) {
            boolean $$27;
            CompoundTag $$17 = $$7.getCompound($$16);
            byte $$18 = $$17.getByte("Y");
            int $$19 = $$02.getSectionIndexFromSectionY($$18);
            if ($$19 >= 0 && $$19 < $$9.length) {
                LevelChunkSection $$24;
                PalettedContainer<Holder<Biome>> $$23;
                PalettedContainer<BlockState> $$21;
                if ($$17.contains("block_states", 10)) {
                    PalettedContainer $$20 = (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$17.getCompound("block_states")).promotePartial($$2 -> ChunkSerializer.logErrors($$22, $$18, $$2)).getOrThrow(ChunkReadException::new);
                } else {
                    $$21 = new PalettedContainer<BlockState>(Block.BLOCK_STATE_REGISTRY, Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                }
                if ($$17.contains("biomes", 10)) {
                    PalettedContainerRO $$222 = (PalettedContainerRO)$$14.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$17.getCompound("biomes")).promotePartial($$2 -> ChunkSerializer.logErrors($$22, $$18, $$2)).getOrThrow(ChunkReadException::new);
                } else {
                    $$23 = new PalettedContainer<Holder<Biome>>($$13.asHolderIdMap(), $$13.getHolderOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                }
                $$9[$$19] = $$24 = new LevelChunkSection($$21, $$23);
                SectionPos $$25 = SectionPos.of($$22, $$18);
                $$1.checkConsistencyWithBlocks($$25, $$24);
            }
            boolean $$26 = $$17.contains(BLOCK_LIGHT_TAG, 7);
            boolean bl = $$27 = $$10 && $$17.contains(SKY_LIGHT_TAG, 7);
            if (!$$26 && !$$27) continue;
            if (!$$15) {
                $$12.retainData($$22, true);
                $$15 = true;
            }
            if ($$26) {
                $$12.queueSectionData(LightLayer.BLOCK, SectionPos.of($$22, $$18), new DataLayer($$17.getByteArray(BLOCK_LIGHT_TAG)));
            }
            if (!$$27) continue;
            $$12.queueSectionData(LightLayer.SKY, SectionPos.of($$22, $$18), new DataLayer($$17.getByteArray(SKY_LIGHT_TAG)));
        }
        long $$28 = $$3.getLong("InhabitedTime");
        ChunkType $$29 = ChunkSerializer.getChunkTypeFromTag($$3);
        if ($$3.contains("blending_data", 10)) {
            BlendingData $$30 = BlendingData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)$$3.getCompound("blending_data"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
        } else {
            $$31 = null;
        }
        if ($$29 == ChunkType.LEVELCHUNK) {
            LevelChunkTicks<Block> $$32 = LevelChunkTicks.load($$3.getList(BLOCK_TICKS_TAG, 10), $$0 -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse($$0)), $$22);
            LevelChunkTicks<Fluid> $$33 = LevelChunkTicks.load($$3.getList(FLUID_TICKS_TAG, 10), $$0 -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse($$0)), $$22);
            LevelChunk $$34 = new LevelChunk($$02.getLevel(), $$22, $$5, $$32, $$33, $$28, $$9, ChunkSerializer.postLoadChunk($$02, $$3), $$31);
        } else {
            ProtoChunkTicks<Block> $$35 = ProtoChunkTicks.load($$3.getList(BLOCK_TICKS_TAG, 10), $$0 -> BuiltInRegistries.BLOCK.getOptional(ResourceLocation.tryParse($$0)), $$22);
            ProtoChunkTicks<Fluid> $$36 = ProtoChunkTicks.load($$3.getList(FLUID_TICKS_TAG, 10), $$0 -> BuiltInRegistries.FLUID.getOptional(ResourceLocation.tryParse($$0)), $$22);
            ProtoChunk $$37 = new ProtoChunk($$22, $$5, $$9, $$35, $$36, $$02, $$13, $$31);
            $$38 = $$37;
            $$38.setInhabitedTime($$28);
            if ($$3.contains("below_zero_retrogen", 10)) {
                BelowZeroRetrogen.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)$$3.getCompound("below_zero_retrogen"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$37::setBelowZeroRetrogen);
            }
            ChunkStatus $$39 = ChunkStatus.byName($$3.getString("Status"));
            $$37.setStatus($$39);
            if ($$39.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                $$37.setLightEngine($$12);
            }
        }
        $$38.setLightCorrect($$6);
        CompoundTag $$40 = $$3.getCompound(HEIGHTMAPS_TAG);
        EnumSet<Heightmap.Types> $$41 = EnumSet.noneOf(Heightmap.Types.class);
        for (Heightmap.Types $$42 : ((ChunkAccess)$$38).getStatus().heightmapsAfter()) {
            String $$43 = $$42.getSerializationKey();
            if ($$40.contains($$43, 12)) {
                $$38.setHeightmap($$42, $$40.getLongArray($$43));
                continue;
            }
            $$41.add($$42);
        }
        Heightmap.primeHeightmaps($$38, $$41);
        CompoundTag $$44 = $$3.getCompound("structures");
        $$38.setAllStarts(ChunkSerializer.unpackStructureStart(StructurePieceSerializationContext.fromLevel($$02), $$44, $$02.getSeed()));
        $$38.setAllReferences(ChunkSerializer.unpackStructureReferences($$02.registryAccess(), $$22, $$44));
        if ($$3.getBoolean("shouldSave")) {
            $$38.setUnsaved(true);
        }
        ListTag $$45 = $$3.getList("PostProcessing", 9);
        for (int $$46 = 0; $$46 < $$45.size(); ++$$46) {
            ListTag $$47 = $$45.getList($$46);
            for (int $$48 = 0; $$48 < $$47.size(); ++$$48) {
                ((ChunkAccess)$$38).addPackedPostProcess($$47.getShort($$48), $$46);
            }
        }
        if ($$29 == ChunkType.LEVELCHUNK) {
            return new ImposterProtoChunk((LevelChunk)((Object)$$38), false);
        }
        ProtoChunk $$49 = $$38;
        ListTag $$50 = $$3.getList("entities", 10);
        for (int $$51 = 0; $$51 < $$50.size(); ++$$51) {
            $$49.addEntity($$50.getCompound($$51));
        }
        ListTag $$52 = $$3.getList("block_entities", 10);
        for (int $$53 = 0; $$53 < $$52.size(); ++$$53) {
            CompoundTag $$54 = $$52.getCompound($$53);
            $$38.setBlockEntityNbt($$54);
        }
        CompoundTag $$55 = $$3.getCompound("CarvingMasks");
        for (String $$56 : $$55.getAllKeys()) {
            GenerationStep.Carving $$57 = GenerationStep.Carving.valueOf($$56);
            $$49.setCarvingMask($$57, new CarvingMask($$55.getLongArray($$56), $$38.getMinBuildHeight()));
        }
        return $$49;
    }

    private static void logErrors(ChunkPos $$0, int $$1, String $$2) {
        LOGGER.error("Recoverable errors when loading section [" + $$0.x + ", " + $$1 + ", " + $$0.z + "]: " + $$2);
    }

    private static Codec<PalettedContainerRO<Holder<Biome>>> makeBiomeCodec(Registry<Biome> $$0) {
        return PalettedContainer.codecRO($$0.asHolderIdMap(), $$0.holderByNameCodec(), PalettedContainer.Strategy.SECTION_BIOMES, $$0.getHolderOrThrow(Biomes.PLAINS));
    }

    public static CompoundTag write(ServerLevel $$0, ChunkAccess $$12) {
        UpgradeData $$6;
        BelowZeroRetrogen $$5;
        ChunkPos $$2 = $$12.getPos();
        CompoundTag $$3 = NbtUtils.addCurrentDataVersion(new CompoundTag());
        $$3.putInt(X_POS_TAG, $$2.x);
        $$3.putInt("yPos", $$12.getMinSection());
        $$3.putInt(Z_POS_TAG, $$2.z);
        $$3.putLong("LastUpdate", $$0.getGameTime());
        $$3.putLong("InhabitedTime", $$12.getInhabitedTime());
        $$3.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey($$12.getStatus()).toString());
        BlendingData $$4 = $$12.getBlendingData();
        if ($$4 != null) {
            BlendingData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)$$4).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$1 -> $$3.put("blending_data", (Tag)$$1));
        }
        if (($$5 = $$12.getBelowZeroRetrogen()) != null) {
            BelowZeroRetrogen.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)$$5).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent($$1 -> $$3.put("below_zero_retrogen", (Tag)$$1));
        }
        if (!($$6 = $$12.getUpgradeData()).isEmpty()) {
            $$3.put(TAG_UPGRADE_DATA, $$6.write());
        }
        LevelChunkSection[] $$7 = $$12.getSections();
        ListTag $$8 = new ListTag();
        ThreadedLevelLightEngine $$9 = $$0.getChunkSource().getLightEngine();
        Registry<Biome> $$10 = $$0.registryAccess().registryOrThrow(Registries.BIOME);
        Codec<PalettedContainerRO<Holder<Biome>>> $$11 = ChunkSerializer.makeBiomeCodec($$10);
        boolean $$122 = $$12.isLightCorrect();
        for (int $$13 = $$9.getMinLightSection(); $$13 < $$9.getMaxLightSection(); ++$$13) {
            int $$14 = $$12.getSectionIndexFromSectionY($$13);
            boolean $$15 = $$14 >= 0 && $$14 < $$7.length;
            DataLayer $$16 = $$9.getLayerListener(LightLayer.BLOCK).getDataLayerData(SectionPos.of($$2, $$13));
            DataLayer $$17 = $$9.getLayerListener(LightLayer.SKY).getDataLayerData(SectionPos.of($$2, $$13));
            if (!$$15 && $$16 == null && $$17 == null) continue;
            CompoundTag $$18 = new CompoundTag();
            if ($$15) {
                LevelChunkSection $$19 = $$7[$$14];
                $$18.put("block_states", (Tag)BLOCK_STATE_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, $$19.getStates()).getOrThrow());
                $$18.put("biomes", (Tag)$$11.encodeStart((DynamicOps)NbtOps.INSTANCE, $$19.getBiomes()).getOrThrow());
            }
            if ($$16 != null && !$$16.isEmpty()) {
                $$18.putByteArray(BLOCK_LIGHT_TAG, $$16.getData());
            }
            if ($$17 != null && !$$17.isEmpty()) {
                $$18.putByteArray(SKY_LIGHT_TAG, $$17.getData());
            }
            if ($$18.isEmpty()) continue;
            $$18.putByte("Y", (byte)$$13);
            $$8.add($$18);
        }
        $$3.put(SECTIONS_TAG, $$8);
        if ($$122) {
            $$3.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        ListTag $$20 = new ListTag();
        for (BlockPos $$21 : $$12.getBlockEntitiesPos()) {
            CompoundTag $$22 = $$12.getBlockEntityNbtForSaving($$21, $$0.registryAccess());
            if ($$22 == null) continue;
            $$20.add($$22);
        }
        $$3.put("block_entities", $$20);
        if ($$12.getStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            ProtoChunk $$23 = (ProtoChunk)$$12;
            ListTag $$24 = new ListTag();
            $$24.addAll($$23.getEntities());
            $$3.put("entities", $$24);
            CompoundTag $$25 = new CompoundTag();
            for (GenerationStep.Carving $$26 : GenerationStep.Carving.values()) {
                CarvingMask $$27 = $$23.getCarvingMask($$26);
                if ($$27 == null) continue;
                $$25.putLongArray($$26.toString(), $$27.toArray());
            }
            $$3.put("CarvingMasks", $$25);
        }
        ChunkSerializer.saveTicks($$0, $$3, $$12.getTicksForSerialization());
        $$3.put("PostProcessing", ChunkSerializer.packOffsets($$12.getPostProcessing()));
        CompoundTag $$28 = new CompoundTag();
        for (Map.Entry<Heightmap.Types, Heightmap> $$29 : $$12.getHeightmaps()) {
            if (!$$12.getStatus().heightmapsAfter().contains($$29.getKey())) continue;
            $$28.put($$29.getKey().getSerializationKey(), new LongArrayTag($$29.getValue().getRawData()));
        }
        $$3.put(HEIGHTMAPS_TAG, $$28);
        $$3.put("structures", ChunkSerializer.packStructureData(StructurePieceSerializationContext.fromLevel($$0), $$2, $$12.getAllStarts(), $$12.getAllReferences()));
        return $$3;
    }

    private static void saveTicks(ServerLevel $$02, CompoundTag $$1, ChunkAccess.TicksToSave $$2) {
        long $$3 = $$02.getLevelData().getGameTime();
        $$1.put(BLOCK_TICKS_TAG, $$2.blocks().save($$3, $$0 -> BuiltInRegistries.BLOCK.getKey((Block)$$0).toString()));
        $$1.put(FLUID_TICKS_TAG, $$2.fluids().save($$3, $$0 -> BuiltInRegistries.FLUID.getKey((Fluid)$$0).toString()));
    }

    public static ChunkType getChunkTypeFromTag(@Nullable CompoundTag $$0) {
        if ($$0 != null) {
            return ChunkStatus.byName($$0.getString("Status")).getChunkType();
        }
        return ChunkType.PROTOCHUNK;
    }

    @Nullable
    private static LevelChunk.PostLoadProcessor postLoadChunk(ServerLevel $$0, CompoundTag $$1) {
        ListTag $$2 = ChunkSerializer.getListOfCompoundsOrNull($$1, "entities");
        ListTag $$32 = ChunkSerializer.getListOfCompoundsOrNull($$1, "block_entities");
        if ($$2 == null && $$32 == null) {
            return null;
        }
        return $$3 -> {
            if ($$2 != null) {
                $$0.addLegacyChunkEntities(EntityType.loadEntitiesRecursive($$2, $$0));
            }
            if ($$32 != null) {
                for (int $$4 = 0; $$4 < $$32.size(); ++$$4) {
                    CompoundTag $$5 = $$32.getCompound($$4);
                    boolean $$6 = $$5.getBoolean("keepPacked");
                    if ($$6) {
                        $$3.setBlockEntityNbt($$5);
                        continue;
                    }
                    BlockPos $$7 = BlockEntity.getPosFromTag($$5);
                    BlockEntity $$8 = BlockEntity.loadStatic($$7, $$3.getBlockState($$7), $$5, $$0.registryAccess());
                    if ($$8 == null) continue;
                    $$3.setBlockEntity($$8);
                }
            }
        };
    }

    @Nullable
    private static ListTag getListOfCompoundsOrNull(CompoundTag $$0, String $$1) {
        ListTag $$2 = $$0.getList($$1, 10);
        return $$2.isEmpty() ? null : $$2;
    }

    private static CompoundTag packStructureData(StructurePieceSerializationContext $$0, ChunkPos $$1, Map<Structure, StructureStart> $$2, Map<Structure, LongSet> $$3) {
        CompoundTag $$4 = new CompoundTag();
        CompoundTag $$5 = new CompoundTag();
        Registry<Structure> $$6 = $$0.registryAccess().registryOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> $$7 : $$2.entrySet()) {
            ResourceLocation $$8 = $$6.getKey($$7.getKey());
            $$5.put($$8.toString(), $$7.getValue().createTag($$0, $$1));
        }
        $$4.put("starts", $$5);
        CompoundTag $$9 = new CompoundTag();
        for (Map.Entry<Structure, LongSet> $$10 : $$3.entrySet()) {
            if ($$10.getValue().isEmpty()) continue;
            ResourceLocation $$11 = $$6.getKey($$10.getKey());
            $$9.put($$11.toString(), new LongArrayTag($$10.getValue()));
        }
        $$4.put("References", $$9);
        return $$4;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext $$0, CompoundTag $$1, long $$2) {
        HashMap $$3 = Maps.newHashMap();
        Registry<Structure> $$4 = $$0.registryAccess().registryOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = $$1.getCompound("starts");
        for (String $$6 : $$5.getAllKeys()) {
            ResourceLocation $$7 = ResourceLocation.tryParse($$6);
            Structure $$8 = $$4.get($$7);
            if ($$8 == null) {
                LOGGER.error("Unknown structure start: {}", (Object)$$7);
                continue;
            }
            StructureStart $$9 = StructureStart.loadStaticStart($$0, $$5.getCompound($$6), $$2);
            if ($$9 == null) continue;
            $$3.put($$8, $$9);
        }
        return $$3;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(RegistryAccess $$0, ChunkPos $$1, CompoundTag $$22) {
        HashMap $$3 = Maps.newHashMap();
        Registry<Structure> $$4 = $$0.registryOrThrow(Registries.STRUCTURE);
        CompoundTag $$5 = $$22.getCompound("References");
        for (String $$6 : $$5.getAllKeys()) {
            ResourceLocation $$7 = ResourceLocation.tryParse($$6);
            Structure $$8 = $$4.get($$7);
            if ($$8 == null) {
                LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)$$7, (Object)$$1);
                continue;
            }
            long[] $$9 = $$5.getLongArray($$6);
            if ($$9.length == 0) continue;
            $$3.put($$8, new LongOpenHashSet(Arrays.stream($$9).filter($$2 -> {
                ChunkPos $$3 = new ChunkPos($$2);
                if ($$3.getChessboardDistance($$1) > 8) {
                    LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{$$7, $$3, $$1});
                    return false;
                }
                return true;
            }).toArray()));
        }
        return $$3;
    }

    public static ListTag packOffsets(ShortList[] $$0) {
        ListTag $$1 = new ListTag();
        for (ShortList $$2 : $$0) {
            ListTag $$3 = new ListTag();
            if ($$2 != null) {
                for (Short $$4 : $$2) {
                    $$3.add(ShortTag.valueOf($$4));
                }
            }
            $$1.add($$3);
        }
        return $$1;
    }

    public static class ChunkReadException
    extends NbtException {
        public ChunkReadException(String $$0) {
            super($$0);
        }
    }
}

