/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public record LootDataType<T>(ResourceKey<Registry<T>> registryKey, Codec<T> codec, String directory, Validator<T> validator) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LootDataType<LootItemCondition> PREDICATE = new LootDataType<LootItemCondition>(Registries.PREDICATE, LootItemConditions.DIRECT_CODEC, "predicates", LootDataType.createSimpleValidator());
    public static final LootDataType<LootItemFunction> MODIFIER = new LootDataType<LootItemFunction>(Registries.ITEM_MODIFIER, LootItemFunctions.ROOT_CODEC, "item_modifiers", LootDataType.createSimpleValidator());
    public static final LootDataType<LootTable> TABLE = new LootDataType<LootTable>(Registries.LOOT_TABLE, LootTable.DIRECT_CODEC, "loot_tables", LootDataType.createLootTableValidator());

    public void runValidation(ValidationContext $$0, ResourceKey<T> $$1, T $$2) {
        this.validator.run($$0, $$1, $$2);
    }

    public <V> Optional<T> deserialize(ResourceLocation $$0, DynamicOps<V> $$12, V $$2) {
        DataResult $$3 = this.codec.parse($$12, $$2);
        $$3.error().ifPresent($$1 -> LOGGER.error("Couldn't parse element {}:{} - {}", new Object[]{this.directory, $$0, $$1.message()}));
        return $$3.result();
    }

    public static Stream<LootDataType<?>> values() {
        return Stream.of(PREDICATE, MODIFIER, TABLE);
    }

    private static <T extends LootContextUser> Validator<T> createSimpleValidator() {
        return ($$0, $$1, $$2) -> $$2.validate($$0.enterElement("{" + String.valueOf($$1.registry()) + "/" + String.valueOf($$1.location()) + "}", $$1));
    }

    private static Validator<LootTable> createLootTableValidator() {
        return ($$0, $$1, $$2) -> $$2.validate($$0.setParams($$2.getParamSet()).enterElement("{" + String.valueOf($$1.registry()) + "/" + String.valueOf($$1.location()) + "}", $$1));
    }

    @FunctionalInterface
    public static interface Validator<T> {
        public void run(ValidationContext var1, ResourceKey<T> var2, T var3);
    }
}

