/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.lang.reflect.Modifier;
import net.minecraftforge.eventbus.LogMarkers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class EventAccessTransformer {
    private static final Logger LOGGER = LogManager.getLogger();

    public boolean transform(ClassNode classNode, Type classType) {
        boolean changed = false;
        for (MethodNode method : classNode.methods) {
            if (!this.hasAnnotation(method)) continue;
            if (Modifier.isPrivate(method.access)) {
                LOGGER.error(LogMarkers.EVENTBUS, "Illegal private member annotated as @SubscribeEvent : {}.{}", (Object)classNode.name, (Object)method.name);
                throw new RuntimeException("Illegal private member with @SubscribeEvent annotation");
            }
            LOGGER.debug(LogMarkers.EVENTBUS, "Transforming @SubscribeEvent method to public {}.{}", (Object)classNode.name, (Object)method.name);
            int access = classNode.access & 0xFFFFFFF9 | 1;
            if (classNode.access != access) {
                classNode.access = access;
                changed = true;
            }
            if (method.access == (access = method.access & 0xFFFFFFF9 | 1)) continue;
            method.access = access;
            changed = true;
        }
        return changed;
    }

    private boolean hasAnnotation(MethodNode method) {
        if (method.visibleAnnotations == null) {
            return false;
        }
        for (AnnotationNode ann : method.visibleAnnotations) {
            if (!"Lnet/minecraftforge/eventbus/api/SubscribeEvent;".equals(ann.desc)) continue;
            return true;
        }
        return false;
    }
}

