/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.crafting.conditions.ICondition;

public record TagEmptyCondition(TagKey<Item> tag) implements ICondition
{
    public static final MapCodec<TagEmptyCondition> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)ResourceLocation.CODEC.xmap(loc -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)loc), TagKey::location).fieldOf("tag").forGetter(TagEmptyCondition::tag)).apply((Applicative)b, TagEmptyCondition::new));

    @Override
    public boolean test(ICondition.IContext context, DynamicOps<?> ops) {
        RegistryOps reg;
        Optional items;
        if (ops instanceof RegistryOps && (items = (reg = (RegistryOps)ops).getter(Registries.ITEM)).isPresent()) {
            Optional optional = ((HolderGetter)items.get()).get(this.tag);
            return optional.isPresent();
        }
        return context.getTag(this.tag).isEmpty();
    }

    @Override
    public String toString() {
        return "tag_empty(\"" + String.valueOf(this.tag.location()) + "\")";
    }

    @Override
    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

