/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.controls;

import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;

@OnlyIn(value=Dist.CLIENT)
public class KeyBindsScreen
extends OptionsSubScreen {
    private static final Component TITLE = Component.translatable("controls.keybinds.title");
    @Nullable
    public KeyMapping selectedKey;
    public long lastKeySelection;
    private KeyBindsList keyBindsList;
    private Button resetButton;

    public KeyBindsScreen(Screen p_193980_, Options p_193981_) {
        super(p_193980_, p_193981_, TITLE);
    }

    protected void init() {
        this.keyBindsList = (KeyBindsList)this.addRenderableWidget((GuiEventListener)new KeyBindsList(this, this.minecraft));
        this.resetButton = Button.builder(Component.translatable("controls.resetAll"), p_269619_ -> {
            for (KeyMapping keymapping : this.options.keyMappings) {
                keymapping.setToDefault();
            }
            this.keyBindsList.resetMappingAndUpdateButtons();
        }).build();
        super.init();
    }

    protected void addFooter() {
        LinearLayout linearlayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearlayout.addChild((LayoutElement)this.resetButton);
        linearlayout.addChild((LayoutElement)Button.builder(CommonComponents.GUI_DONE, p_325377_ -> this.onClose()).build());
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        this.keyBindsList.updateSize(this.width, this.layout);
    }

    public boolean mouseClicked(double p_193983_, double p_193984_, int p_193985_) {
        if (this.selectedKey != null) {
            this.options.setKey(this.selectedKey, InputConstants.Type.MOUSE.getOrCreate(p_193985_));
            this.selectedKey = null;
            this.keyBindsList.resetMappingAndUpdateButtons();
            return true;
        }
        return super.mouseClicked(p_193983_, p_193984_, p_193985_);
    }

    public boolean keyPressed(int p_193987_, int p_193988_, int p_193989_) {
        if (this.selectedKey != null) {
            if (p_193987_ == 256) {
                this.selectedKey.setKeyModifierAndCode(null, InputConstants.UNKNOWN);
                this.options.setKey(this.selectedKey, InputConstants.UNKNOWN);
            } else {
                this.selectedKey.setKeyModifierAndCode(null, InputConstants.getKey((int)p_193987_, (int)p_193988_));
                this.options.setKey(this.selectedKey, InputConstants.getKey((int)p_193987_, (int)p_193988_));
            }
            if (p_193987_ == 256 || !KeyModifier.isKeyCodeModifier((InputConstants.Key)this.selectedKey.getKey())) {
                this.selectedKey = null;
            }
            this.lastKeySelection = Util.getMillis();
            this.keyBindsList.resetMappingAndUpdateButtons();
            return true;
        }
        return super.keyPressed(p_193987_, p_193988_, p_193989_);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.selectedKey != null && this.selectedKey.getKey() == key) {
            this.selectedKey = null;
            this.lastKeySelection = Util.getMillis();
            this.keyBindsList.resetMappingAndUpdateButtons();
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics p_282556_, int p_193992_, int p_193993_, float p_193994_) {
        super.render(p_282556_, p_193992_, p_193993_, p_193994_);
        boolean flag = false;
        for (KeyMapping keymapping : this.options.keyMappings) {
            if (keymapping.isDefault()) continue;
            flag = true;
            break;
        }
        this.resetButton.active = flag;
    }
}

