/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestListener {
    private int attempts = 0;
    private int successes = 0;

    @Override
    public void testStructureLoaded(GameTestInfo $$0) {
        ReportGameListener.spawnBeacon($$0, Blocks.LIGHT_GRAY_STAINED_GLASS);
        ++this.attempts;
    }

    private void handleRetry(GameTestInfo $$0, GameTestRunner $$1, boolean $$2) {
        RetryOptions $$3 = $$0.retryOptions();
        Object $$4 = String.format("[Run: %4d, Ok: %4d, Fail: %4d", this.attempts, this.successes, this.attempts - this.successes);
        if (!$$3.unlimitedTries()) {
            $$4 = (String)$$4 + String.format(", Left: %4d", $$3.numberOfTries() - this.attempts);
        }
        $$4 = (String)$$4 + "]";
        String $$5 = $$0.getTestName() + " " + ($$2 ? "passed" : "failed") + "! " + $$0.getRunTime() + "ms";
        String $$6 = String.format("%-53s%s", $$4, $$5);
        if ($$2) {
            ReportGameListener.reportPassed($$0, $$6);
        } else {
            ReportGameListener.say($$0.getLevel(), ChatFormatting.RED, $$6);
        }
        if ($$3.hasTriesLeft(this.attempts, this.successes)) {
            $$1.rerunTest($$0);
        }
    }

    @Override
    public void testPassed(GameTestInfo $$0, GameTestRunner $$1) {
        ++this.successes;
        if ($$0.retryOptions().hasRetries()) {
            this.handleRetry($$0, $$1, true);
            return;
        }
        if (!$$0.isFlaky()) {
            ReportGameListener.reportPassed($$0, $$0.getTestName() + " passed! (" + $$0.getRunTime() + "ms)");
            return;
        }
        if (this.successes >= $$0.requiredSuccesses()) {
            ReportGameListener.reportPassed($$0, String.valueOf($$0) + " passed " + this.successes + " times of " + this.attempts + " attempts.");
        } else {
            ReportGameListener.say($$0.getLevel(), ChatFormatting.GREEN, "Flaky test " + String.valueOf($$0) + " succeeded, attempt: " + this.attempts + " successes: " + this.successes);
            $$1.rerunTest($$0);
        }
    }

    @Override
    public void testFailed(GameTestInfo $$0, GameTestRunner $$1) {
        if (!$$0.isFlaky()) {
            ReportGameListener.reportFailure($$0, $$0.getError());
            if ($$0.retryOptions().hasRetries()) {
                this.handleRetry($$0, $$1, false);
            }
            return;
        }
        TestFunction $$2 = $$0.getTestFunction();
        String $$3 = "Flaky test " + String.valueOf($$0) + " failed, attempt: " + this.attempts + "/" + $$2.maxAttempts();
        if ($$2.requiredSuccesses() > 1) {
            $$3 = $$3 + ", successes: " + this.successes + " (" + $$2.requiredSuccesses() + " required)";
        }
        ReportGameListener.say($$0.getLevel(), ChatFormatting.YELLOW, $$3);
        if ($$0.maxAttempts() - this.attempts + this.successes >= $$0.requiredSuccesses()) {
            $$1.rerunTest($$0);
        } else {
            ReportGameListener.reportFailure($$0, new ExhaustedAttemptsException(this.attempts, this.successes, $$0));
        }
    }

    @Override
    public void testAddedForRerun(GameTestInfo $$0, GameTestInfo $$1, GameTestRunner $$2) {
        $$1.addListener(this);
    }

    public static void reportPassed(GameTestInfo $$0, String $$1) {
        ReportGameListener.spawnBeacon($$0, Blocks.LIME_STAINED_GLASS);
        ReportGameListener.visualizePassedTest($$0, $$1);
    }

    private static void visualizePassedTest(GameTestInfo $$0, String $$1) {
        ReportGameListener.say($$0.getLevel(), ChatFormatting.GREEN, $$1);
        GlobalTestReporter.onTestSuccess($$0);
    }

    protected static void reportFailure(GameTestInfo $$0, Throwable $$1) {
        ReportGameListener.spawnBeacon($$0, $$0.isRequired() ? Blocks.RED_STAINED_GLASS : Blocks.ORANGE_STAINED_GLASS);
        ReportGameListener.spawnLectern($$0, Util.describeError($$1));
        ReportGameListener.visualizeFailedTest($$0, $$1);
    }

    protected static void visualizeFailedTest(GameTestInfo $$0, Throwable $$1) {
        String $$2 = $$1.getMessage() + (String)($$1.getCause() == null ? "" : " cause: " + Util.describeError($$1.getCause()));
        String $$3 = ($$0.isRequired() ? "" : "(optional) ") + $$0.getTestName() + " failed! " + $$2;
        ReportGameListener.say($$0.getLevel(), $$0.isRequired() ? ChatFormatting.RED : ChatFormatting.YELLOW, $$3);
        Throwable $$4 = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)$$1), (Object)$$1);
        if ($$4 instanceof GameTestAssertPosException) {
            GameTestAssertPosException $$5 = (GameTestAssertPosException)$$4;
            ReportGameListener.showRedBox($$0.getLevel(), $$5.getAbsolutePos(), $$5.getMessageToShowAtBlock());
        }
        GlobalTestReporter.onTestFailed($$0);
    }

    protected static void spawnBeacon(GameTestInfo $$0, Block $$1) {
        ServerLevel $$2 = $$0.getLevel();
        BlockPos $$3 = $$0.getStructureBlockPos();
        BlockPos $$4 = new BlockPos(-1, -2, -1);
        BlockPos $$5 = StructureTemplate.transform($$3.offset($$4), Mirror.NONE, $$0.getRotation(), $$3);
        $$2.setBlockAndUpdate($$5, Blocks.BEACON.defaultBlockState().rotate($$0.getRotation()));
        BlockPos $$6 = $$5.offset(0, 1, 0);
        $$2.setBlockAndUpdate($$6, $$1.defaultBlockState());
        for (int $$7 = -1; $$7 <= 1; ++$$7) {
            for (int $$8 = -1; $$8 <= 1; ++$$8) {
                BlockPos $$9 = $$5.offset($$7, -1, $$8);
                $$2.setBlockAndUpdate($$9, Blocks.IRON_BLOCK.defaultBlockState());
            }
        }
    }

    private static void spawnLectern(GameTestInfo $$0, String $$1) {
        ServerLevel $$2 = $$0.getLevel();
        BlockPos $$3 = $$0.getStructureBlockPos();
        BlockPos $$4 = new BlockPos(-1, 0, -1);
        BlockPos $$5 = StructureTemplate.transform($$3.offset($$4), Mirror.NONE, $$0.getRotation(), $$3);
        $$2.setBlockAndUpdate($$5, Blocks.LECTERN.defaultBlockState().rotate($$0.getRotation()));
        BlockState $$6 = $$2.getBlockState($$5);
        ItemStack $$7 = ReportGameListener.createBook($$0.getTestName(), $$0.isRequired(), $$1);
        LecternBlock.tryPlaceBook(null, $$2, $$5, $$6, $$7);
    }

    private static ItemStack createBook(String $$0, boolean $$12, String $$2) {
        StringBuffer $$3 = new StringBuffer();
        Arrays.stream($$0.split("\\.")).forEach($$1 -> $$3.append((String)$$1).append('\n'));
        if (!$$12) {
            $$3.append("(optional)\n");
        }
        $$3.append("-------------------\n");
        ItemStack $$4 = new ItemStack(Items.WRITABLE_BOOK);
        $$4.set(DataComponents.WRITABLE_BOOK_CONTENT, new WritableBookContent(List.of(Filterable.passThrough(String.valueOf($$3) + $$2))));
        return $$4;
    }

    protected static void say(ServerLevel $$02, ChatFormatting $$1, String $$22) {
        $$02.getPlayers($$0 -> true).forEach($$2 -> $$2.sendSystemMessage(Component.literal($$22).withStyle($$1)));
    }

    private static void showRedBox(ServerLevel $$0, BlockPos $$1, String $$2) {
        DebugPackets.sendGameTestAddMarker($$0, $$1, $$2, -2130771968, Integer.MAX_VALUE);
    }
}

