/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class AnimalPanic<E extends PathfinderMob>
extends Behavior<E> {
    private static final int PANIC_MIN_DURATION = 100;
    private static final int PANIC_MAX_DURATION = 120;
    private static final int PANIC_DISTANCE_HORIZONTAL = 5;
    private static final int PANIC_DISTANCE_VERTICAL = 4;
    private static final Predicate<PathfinderMob> DEFAULT_SHOULD_PANIC_PREDICATE = $$0 -> $$0.getLastHurtByMob() != null || $$0.isFreezing() || $$0.isOnFire();
    private final float speedMultiplier;
    private final Predicate<E> shouldPanic;

    public AnimalPanic(float $$0) {
        this($$0, DEFAULT_SHOULD_PANIC_PREDICATE::test);
    }

    public AnimalPanic(float $$0, Predicate<E> $$1) {
        super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.REGISTERED, MemoryModuleType.HURT_BY, MemoryStatus.REGISTERED), 100, 120);
        this.speedMultiplier = $$0;
        this.shouldPanic = $$1;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel $$0, E $$1) {
        return this.shouldPanic.test($$1) && (((LivingEntity)$$1).getBrain().hasMemoryValue(MemoryModuleType.HURT_BY) || ((LivingEntity)$$1).getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING));
    }

    @Override
    protected boolean canStillUse(ServerLevel $$0, E $$1, long $$2) {
        return true;
    }

    @Override
    protected void start(ServerLevel $$0, E $$1, long $$2) {
        ((LivingEntity)$$1).getBrain().setMemory(MemoryModuleType.IS_PANICKING, true);
        ((LivingEntity)$$1).getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    @Override
    protected void stop(ServerLevel $$0, E $$1, long $$2) {
        Brain<?> $$3 = ((LivingEntity)$$1).getBrain();
        $$3.eraseMemory(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void tick(ServerLevel $$0, E $$1, long $$2) {
        Vec3 $$3;
        if (((Mob)$$1).getNavigation().isDone() && ($$3 = this.getPanicPos($$1, $$0)) != null) {
            ((LivingEntity)$$1).getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget($$3, this.speedMultiplier, 0));
        }
    }

    @Nullable
    private Vec3 getPanicPos(E $$0, ServerLevel $$1) {
        Optional<Vec3> $$2;
        if (((Entity)$$0).isOnFire() && ($$2 = this.lookForWater($$1, (Entity)$$0).map(Vec3::atBottomCenterOf)).isPresent()) {
            return $$2.get();
        }
        return LandRandomPos.getPos($$0, 5, 4);
    }

    private Optional<BlockPos> lookForWater(BlockGetter $$0, Entity $$13) {
        Predicate<BlockPos> $$4;
        BlockPos $$2 = $$13.blockPosition();
        if (!$$0.getBlockState($$2).getCollisionShape($$0, $$2).isEmpty()) {
            return Optional.empty();
        }
        if (Mth.ceil($$13.getBbWidth()) == 2) {
            Predicate<BlockPos> $$3 = $$12 -> BlockPos.squareOutSouthEast($$12).allMatch($$1 -> $$0.getFluidState((BlockPos)$$1).is(FluidTags.WATER));
        } else {
            $$4 = $$1 -> $$0.getFluidState((BlockPos)$$1).is(FluidTags.WATER);
        }
        return BlockPos.findClosestMatch($$2, 5, 1, $$4);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (E)((PathfinderMob)livingEntity), l);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (E)((PathfinderMob)livingEntity), l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (E)((PathfinderMob)livingEntity), l);
    }
}

