/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class RecordItem
extends Item {
    @Deprecated
    private static final Map<SoundEvent, RecordItem> BY_NAME = Maps.newHashMap();
    private final int analogOutput;
    @Deprecated
    private final SoundEvent sound;
    private final int lengthInTicks;
    private final Supplier<SoundEvent> soundSupplier;

    public RecordItem(int p_239614_, SoundEvent p_239615_, Item.Properties p_239616_, int p_239617_) {
        super(p_239616_);
        this.analogOutput = p_239614_;
        this.sound = p_239615_;
        this.lengthInTicks = p_239617_ * 20;
        BY_NAME.put(this.sound, this);
        this.soundSupplier = ForgeRegistries.SOUND_EVENTS.getDelegateOrThrow((Object)this.sound);
    }

    public RecordItem(int comparatorValue, Supplier<SoundEvent> soundSupplier, Item.Properties builder, int lengthInTicks) {
        super(builder);
        this.analogOutput = comparatorValue;
        this.sound = null;
        this.soundSupplier = soundSupplier;
        this.lengthInTicks = lengthInTicks;
    }

    @Override
    public InteractionResult useOn(UseOnContext p_43048_) {
        BlockPos blockpos;
        Level level = p_43048_.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = p_43048_.getClickedPos());
        if (blockstate.is(Blocks.JUKEBOX) && !blockstate.getValue(JukeboxBlock.HAS_RECORD).booleanValue()) {
            ItemStack itemstack = p_43048_.getItemInHand();
            if (!level.isClientSide) {
                Player player = p_43048_.getPlayer();
                BlockEntity blockEntity = level.getBlockEntity(blockpos);
                if (blockEntity instanceof JukeboxBlockEntity) {
                    JukeboxBlockEntity jukeboxblockentity = (JukeboxBlockEntity)blockEntity;
                    jukeboxblockentity.setTheItem(itemstack.copy());
                    level.gameEvent(GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of(player, blockstate));
                }
                itemstack.shrink(1);
                if (player != null) {
                    player.awardStat(Stats.PLAY_RECORD);
                }
            }
            return InteractionResult.sidedSuccess(level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public int getAnalogOutput() {
        return this.analogOutput;
    }

    @Override
    public void appendHoverText(ItemStack p_43043_, Item.TooltipContext p_333662_, List<Component> p_43045_, TooltipFlag p_43046_) {
        p_43045_.add(this.getDisplayName().withStyle(ChatFormatting.GRAY));
    }

    public MutableComponent getDisplayName() {
        return Component.translatable(this.getDescriptionId() + ".desc");
    }

    @Nullable
    public static RecordItem getBySound(SoundEvent p_43041_) {
        return BY_NAME.get(p_43041_);
    }

    public SoundEvent getSound() {
        return this.soundSupplier.get();
    }

    public int getLengthInTicks() {
        return this.lengthInTicks;
    }
}

