/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.common.Tags;

public class ShulkerBoxColoring
extends CustomRecipe {
    public ShulkerBoxColoring(CraftingBookCategory p_250756_) {
        super(p_250756_);
    }

    @Override
    public boolean matches(CraftingContainer p_44324_, Level p_44325_) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < p_44324_.getContainerSize(); ++k) {
            ItemStack itemstack = p_44324_.getItem(k);
            if (itemstack.isEmpty()) continue;
            if (Block.byItem(itemstack.getItem()) instanceof ShulkerBoxBlock) {
                ++i;
            } else {
                if (!itemstack.is(Tags.Items.DYES)) {
                    return false;
                }
                ++j;
            }
            if (j <= 1 && i <= 1) continue;
            return false;
        }
        return i == 1 && j == 1;
    }

    @Override
    public ItemStack assemble(CraftingContainer p_44322_, HolderLookup.Provider p_336251_) {
        ItemStack itemstack = ItemStack.EMPTY;
        DyeColor dyecolor = DyeColor.WHITE;
        for (int i = 0; i < p_44322_.getContainerSize(); ++i) {
            DyeColor tmp;
            ItemStack itemstack1 = p_44322_.getItem(i);
            if (itemstack1.isEmpty()) continue;
            Item item = itemstack1.getItem();
            if (Block.byItem(item) instanceof ShulkerBoxBlock) {
                itemstack = itemstack1;
                continue;
            }
            if (!(item instanceof DyeItem) || (tmp = DyeColor.getColor(itemstack1)) == null) continue;
            dyecolor = tmp;
        }
        Block block = ShulkerBoxBlock.getBlockByColor(dyecolor);
        return itemstack.transmuteCopy(block, 1);
    }

    @Override
    public boolean canCraftInDimensions(int p_44314_, int p_44315_) {
        return p_44314_ * p_44315_ >= 2;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializer.SHULKER_BOX_COLORING;
    }
}

