/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;

public class DamageEnchantment
extends Enchantment {
    private final Optional<TagKey<EntityType<?>>> targets;

    public DamageEnchantment(Enchantment.EnchantmentDefinition $$0, Optional<TagKey<EntityType<?>>> $$1) {
        super($$0);
        this.targets = $$1;
    }

    @Override
    public float getDamageBonus(int $$0, @Nullable EntityType<?> $$1) {
        if (this.targets.isEmpty()) {
            return 1.0f + (float)Math.max(0, $$0 - 1) * 0.5f;
        }
        if ($$1 != null && $$1.is(this.targets.get())) {
            return (float)$$0 * 2.5f;
        }
        return 0.0f;
    }

    @Override
    public boolean checkCompatibility(Enchantment $$0) {
        return !($$0 instanceof DamageEnchantment);
    }

    @Override
    public void doPostAttack(LivingEntity $$0, Entity $$1, int $$2) {
        if (this.targets.isPresent() && $$1 instanceof LivingEntity) {
            LivingEntity $$3 = (LivingEntity)$$1;
            if (this.targets.get() == EntityTypeTags.SENSITIVE_TO_BANE_OF_ARTHROPODS && $$2 > 0 && $$3.getType().is(this.targets.get())) {
                int $$4 = 20 + $$0.getRandom().nextInt(10 * $$2);
                $$3.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, $$4, 3));
            }
        }
    }
}

