/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class ProtectionEnchantment
extends Enchantment {
    public final Type type;

    public ProtectionEnchantment(Enchantment.EnchantmentDefinition $$0, Type $$1) {
        super($$0);
        this.type = $$1;
    }

    @Override
    public int getDamageProtection(int $$0, DamageSource $$1) {
        if ($$1.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return 0;
        }
        if (this.type == Type.ALL) {
            return $$0;
        }
        if (this.type == Type.FIRE && $$1.is(DamageTypeTags.IS_FIRE)) {
            return $$0 * 2;
        }
        if (this.type == Type.FALL && $$1.is(DamageTypeTags.IS_FALL)) {
            return $$0 * 3;
        }
        if (this.type == Type.EXPLOSION && $$1.is(DamageTypeTags.IS_EXPLOSION)) {
            return $$0 * 2;
        }
        if (this.type == Type.PROJECTILE && $$1.is(DamageTypeTags.IS_PROJECTILE)) {
            return $$0 * 2;
        }
        return 0;
    }

    @Override
    public boolean checkCompatibility(Enchantment $$0) {
        if ($$0 instanceof ProtectionEnchantment) {
            ProtectionEnchantment $$1 = (ProtectionEnchantment)$$0;
            if (this.type == $$1.type) {
                return false;
            }
            return this.type == Type.FALL || $$1.type == Type.FALL;
        }
        return super.checkCompatibility($$0);
    }

    public static int getFireAfterDampener(LivingEntity $$0, int $$1) {
        int $$2 = EnchantmentHelper.getEnchantmentLevel(Enchantments.FIRE_PROTECTION, $$0);
        if ($$2 > 0) {
            $$1 -= Mth.floor((float)$$1 * ((float)$$2 * 0.15f));
        }
        return $$1;
    }

    public static double getExplosionKnockbackAfterDampener(LivingEntity $$0, double $$1) {
        int $$2 = EnchantmentHelper.getEnchantmentLevel(Enchantments.BLAST_PROTECTION, $$0);
        if ($$2 > 0) {
            $$1 *= Mth.clamp(1.0 - (double)$$2 * 0.15, 0.0, 1.0);
        }
        return $$1;
    }

    public static enum Type {
        ALL,
        FIRE,
        FALL,
        EXPLOSION,
        PROJECTILE;

    }
}

