/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.ContainerSingleItem;

public class JukeboxBlockEntity
extends BlockEntity
implements Clearable,
ContainerSingleItem.BlockContainerSingleItem {
    private static final int SONG_END_PADDING = 20;
    private ItemStack item = ItemStack.EMPTY;
    private int ticksSinceLastEvent;
    private long tickCount;
    private long recordStartedTick;
    private boolean isPlaying;

    public JukeboxBlockEntity(BlockPos $$0, BlockState $$1) {
        super(BlockEntityType.JUKEBOX, $$0, $$1);
    }

    @Override
    protected void loadAdditional(CompoundTag $$0, HolderLookup.Provider $$1) {
        super.loadAdditional($$0, $$1);
        this.item = $$0.contains("RecordItem", 10) ? ItemStack.parse($$1, $$0.getCompound("RecordItem")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        this.isPlaying = $$0.getBoolean("IsPlaying");
        this.recordStartedTick = $$0.getLong("RecordStartTick");
        this.tickCount = $$0.getLong("TickCount");
    }

    @Override
    protected void saveAdditional(CompoundTag $$0, HolderLookup.Provider $$1) {
        super.saveAdditional($$0, $$1);
        if (!this.getTheItem().isEmpty()) {
            $$0.put("RecordItem", this.getTheItem().save($$1));
        }
        $$0.putBoolean("IsPlaying", this.isPlaying);
        $$0.putLong("RecordStartTick", this.recordStartedTick);
        $$0.putLong("TickCount", this.tickCount);
    }

    public boolean isRecordPlaying() {
        return !this.getTheItem().isEmpty() && this.isPlaying;
    }

    private void setHasRecordBlockState(@Nullable Entity $$0, boolean $$1) {
        if (this.level.getBlockState(this.getBlockPos()) == this.getBlockState()) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue(JukeboxBlock.HAS_RECORD, $$1), 2);
            this.level.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of($$0, this.getBlockState()));
        }
    }

    @VisibleForTesting
    public void startPlaying() {
        this.recordStartedTick = this.tickCount;
        this.isPlaying = true;
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.level.levelEvent(null, 1010, this.getBlockPos(), Item.getId(this.getTheItem().getItem()));
        this.setChanged();
    }

    private void stopPlaying() {
        this.isPlaying = false;
        this.level.gameEvent(GameEvent.JUKEBOX_STOP_PLAY, this.getBlockPos(), GameEvent.Context.of(this.getBlockState()));
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.level.levelEvent(1011, this.getBlockPos(), 0);
        this.setChanged();
    }

    private void tick(Level $$0, BlockPos $$1, BlockState $$2) {
        Item item;
        ++this.ticksSinceLastEvent;
        if (this.isRecordPlaying() && (item = this.getTheItem().getItem()) instanceof RecordItem) {
            RecordItem $$3 = (RecordItem)item;
            if (this.shouldRecordStopPlaying($$3)) {
                this.stopPlaying();
            } else if (this.shouldSendJukeboxPlayingEvent()) {
                this.ticksSinceLastEvent = 0;
                $$0.gameEvent(GameEvent.JUKEBOX_PLAY, $$1, GameEvent.Context.of($$2));
                this.spawnMusicParticles($$0, $$1);
            }
        }
        ++this.tickCount;
    }

    private boolean shouldRecordStopPlaying(RecordItem $$0) {
        return this.tickCount >= this.recordStartedTick + (long)$$0.getLengthInTicks() + 20L;
    }

    private boolean shouldSendJukeboxPlayingEvent() {
        return this.ticksSinceLastEvent >= 20;
    }

    @Override
    public ItemStack getTheItem() {
        return this.item;
    }

    @Override
    public ItemStack splitTheItem(int $$0) {
        ItemStack $$1 = this.item;
        this.item = ItemStack.EMPTY;
        if (!$$1.isEmpty()) {
            this.setHasRecordBlockState(null, false);
            this.stopPlaying();
        }
        return $$1;
    }

    @Override
    public void setTheItem(ItemStack $$0) {
        if ($$0.is(ItemTags.MUSIC_DISCS) && this.level != null) {
            this.item = $$0;
            this.setHasRecordBlockState(null, true);
            this.startPlaying();
        } else if ($$0.isEmpty()) {
            this.splitTheItem(1);
        }
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public BlockEntity getContainerBlockEntity() {
        return this;
    }

    @Override
    public boolean canPlaceItem(int $$0, ItemStack $$1) {
        return $$1.is(ItemTags.MUSIC_DISCS) && this.getItem($$0).isEmpty();
    }

    @Override
    public boolean canTakeItem(Container $$0, int $$1, ItemStack $$2) {
        return $$0.hasAnyMatching(ItemStack::isEmpty);
    }

    private void spawnMusicParticles(Level $$0, BlockPos $$1) {
        if ($$0 instanceof ServerLevel) {
            ServerLevel $$2 = (ServerLevel)$$0;
            Vec3 $$3 = Vec3.atBottomCenterOf($$1).add(0.0, 1.2f, 0.0);
            float $$4 = (float)$$0.getRandom().nextInt(4) / 24.0f;
            $$2.sendParticles(ParticleTypes.NOTE, $$3.x(), $$3.y(), $$3.z(), 0, $$4, 0.0, 0.0, 1.0);
        }
    }

    public void popOutRecord() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        BlockPos $$0 = this.getBlockPos();
        ItemStack $$1 = this.getTheItem();
        if ($$1.isEmpty()) {
            return;
        }
        this.removeTheItem();
        Vec3 $$2 = Vec3.atLowerCornerWithOffset($$0, 0.5, 1.01, 0.5).offsetRandom(this.level.random, 0.7f);
        ItemStack $$3 = $$1.copy();
        ItemEntity $$4 = new ItemEntity(this.level, $$2.x(), $$2.y(), $$2.z(), $$3);
        $$4.setDefaultPickUpDelay();
        this.level.addFreshEntity($$4);
    }

    public static void playRecordTick(Level $$0, BlockPos $$1, BlockState $$2, JukeboxBlockEntity $$3) {
        $$3.tick($$0, $$1, $$2);
    }

    @VisibleForTesting
    public void setRecordWithoutPlaying(ItemStack $$0) {
        this.item = $$0;
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
        this.setChanged();
    }
}

