/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public final class TrialSpawner {
    public static final String NORMAL_CONFIG_TAG_NAME = "normal_config";
    public static final String OMINOUS_CONFIG_TAG_NAME = "ominous_config";
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final TrialSpawnerConfig normalConfig;
    private final TrialSpawnerConfig ominousConfig;
    private final TrialSpawnerData data;
    private final int requiredPlayerRange;
    private final int targetCooldownLength;
    private final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    private boolean isOminous;

    public Codec<TrialSpawner> codec() {
        return RecordCodecBuilder.create($$02 -> $$02.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf(NORMAL_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getNormalConfig), (App)TrialSpawnerConfig.CODEC.optionalFieldOf(OMINOUS_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getOminousConfigForSerialization), (App)TrialSpawnerData.MAP_CODEC.forGetter(TrialSpawner::getData), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::getTargetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::getRequiredPlayerRange)).apply((Applicative)$$02, ($$0, $$1, $$2, $$3, $$4) -> new TrialSpawner((TrialSpawnerConfig)$$0, (TrialSpawnerConfig)$$1, (TrialSpawnerData)$$2, (int)$$3, (int)$$4, this.stateAccessor, this.playerDetector, this.entitySelector)));
    }

    public TrialSpawner(StateAccessor $$0, PlayerDetector $$1, PlayerDetector.EntitySelector $$2) {
        this(TrialSpawnerConfig.DEFAULT, TrialSpawnerConfig.DEFAULT, new TrialSpawnerData(), 36000, 14, $$0, $$1, $$2);
    }

    public TrialSpawner(TrialSpawnerConfig $$0, TrialSpawnerConfig $$1, TrialSpawnerData $$2, int $$3, int $$4, StateAccessor $$5, PlayerDetector $$6, PlayerDetector.EntitySelector $$7) {
        this.normalConfig = $$0;
        this.ominousConfig = $$1;
        this.data = $$2;
        this.targetCooldownLength = $$3;
        this.requiredPlayerRange = $$4;
        this.stateAccessor = $$5;
        this.playerDetector = $$6;
        this.entitySelector = $$7;
    }

    public TrialSpawnerConfig getConfig() {
        return this.isOminous ? this.ominousConfig : this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getNormalConfig() {
        return this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getOminousConfig() {
        return this.ominousConfig;
    }

    private TrialSpawnerConfig getOminousConfigForSerialization() {
        return !this.ominousConfig.equals(this.normalConfig) ? this.ominousConfig : TrialSpawnerConfig.DEFAULT;
    }

    public void applyOminous(ServerLevel $$0, BlockPos $$1) {
        $$0.setBlock($$1, (BlockState)$$0.getBlockState($$1).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        $$0.levelEvent(3020, $$1, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, $$0);
    }

    public void removeOminous(ServerLevel $$0, BlockPos $$1) {
        $$0.setBlock($$1, (BlockState)$$0.getBlockState($$1).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public TrialSpawnerData getData() {
        return this.data;
    }

    public int getTargetCooldownLength() {
        return this.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public void setState(Level $$0, TrialSpawnerState $$1) {
        this.stateAccessor.setState($$0, $$1);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(Level $$0) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        if ($$0.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        return $$0.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
    }

    public Optional<UUID> spawnMob(ServerLevel $$0, BlockPos $$1) {
        SpawnData.CustomSpawnRules $$13;
        double $$10;
        RandomSource $$2 = $$0.getRandom();
        SpawnData $$3 = this.data.getOrCreateNextSpawnData(this, $$0.getRandom());
        CompoundTag $$42 = $$3.entityToSpawn();
        ListTag $$5 = $$42.getList("Pos", 6);
        Optional<EntityType<?>> $$6 = EntityType.by($$42);
        if ($$6.isEmpty()) {
            return Optional.empty();
        }
        int $$7 = $$5.size();
        double $$8 = $$7 >= 1 ? $$5.getDouble(0) : (double)$$1.getX() + ($$2.nextDouble() - $$2.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
        double $$9 = $$7 >= 2 ? $$5.getDouble(1) : (double)($$1.getY() + $$2.nextInt(3) - 1);
        double d = $$10 = $$7 >= 3 ? $$5.getDouble(2) : (double)$$1.getZ() + ($$2.nextDouble() - $$2.nextDouble()) * (double)this.getConfig().spawnRange() + 0.5;
        if (!$$0.noCollision($$6.get().getSpawnAABB($$8, $$9, $$10))) {
            return Optional.empty();
        }
        Vec3 $$11 = new Vec3($$8, $$9, $$10);
        if (!TrialSpawner.inLineOfSight($$0, $$1.getCenter(), $$11)) {
            return Optional.empty();
        }
        BlockPos $$12 = BlockPos.containing($$11);
        if (!SpawnPlacements.checkSpawnRules($$6.get(), $$0, MobSpawnType.TRIAL_SPAWNER, $$12, $$0.getRandom())) {
            return Optional.empty();
        }
        if ($$3.getCustomSpawnRules().isPresent() && !($$13 = $$3.getCustomSpawnRules().get()).isValidPosition($$12, $$0)) {
            return Optional.empty();
        }
        Entity $$14 = EntityType.loadEntityRecursive($$42, $$0, $$4 -> {
            $$4.moveTo($$8, $$9, $$10, $$2.nextFloat() * 360.0f, 0.0f);
            return $$4;
        });
        if ($$14 == null) {
            return Optional.empty();
        }
        if ($$14 instanceof Mob) {
            boolean $$16;
            Mob $$15 = (Mob)$$14;
            if (!$$15.checkSpawnObstruction($$0)) {
                return Optional.empty();
            }
            boolean bl = $$16 = $$3.getEntityToSpawn().size() == 1 && $$3.getEntityToSpawn().contains("id", 8);
            if ($$16) {
                $$15.finalizeSpawn($$0, $$0.getCurrentDifficultyAt($$15.blockPosition()), MobSpawnType.TRIAL_SPAWNER, null);
            }
            $$15.setPersistenceRequired();
            $$3.getEquipment().ifPresent($$15::equip);
        }
        if (!$$0.tryAddFreshEntityWithPassengers($$14)) {
            return Optional.empty();
        }
        FlameParticle $$17 = this.isOminous ? FlameParticle.OMINOUS : FlameParticle.NORMAL;
        $$0.levelEvent(3011, $$1, $$17.encode());
        $$0.levelEvent(3012, $$12, $$17.encode());
        $$0.gameEvent($$14, GameEvent.ENTITY_PLACE, $$12);
        return Optional.of($$14.getUUID());
    }

    public void ejectReward(ServerLevel $$0, BlockPos $$1, ResourceKey<LootTable> $$2) {
        LootParams $$4;
        LootTable $$3 = $$0.getServer().reloadableRegistries().getLootTable($$2);
        ObjectArrayList<ItemStack> $$5 = $$3.getRandomItems($$4 = new LootParams.Builder($$0).create(LootContextParamSets.EMPTY));
        if (!$$5.isEmpty()) {
            for (ItemStack $$6 : $$5) {
                DefaultDispenseItemBehavior.spawnItem($$0, $$6, 2, Direction.UP, Vec3.atBottomCenterOf($$1).relative(Direction.UP, 1.2));
            }
            $$0.levelEvent(3014, $$1, 0);
        }
    }

    public void tickClient(Level $$0, BlockPos $$1, boolean $$2) {
        RandomSource $$5;
        if (!this.canSpawnInLevel($$0)) {
            this.data.oSpin = this.data.spin;
            return;
        }
        TrialSpawnerState $$3 = this.getState();
        $$3.emitParticles($$0, $$1, $$2);
        if ($$3.hasSpinningMob()) {
            double $$4 = Math.max(0L, this.data.nextMobSpawnsAt - $$0.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + $$3.spinningMobSpeed() / ($$4 + 200.0)) % 360.0;
        }
        if ($$3.isCapableOfSpawning() && ($$5 = $$0.getRandom()).nextFloat() <= 0.02f) {
            SoundEvent $$6 = $$2 ? SoundEvents.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEvents.TRIAL_SPAWNER_AMBIENT;
            $$0.playLocalSound($$1, $$6, SoundSource.BLOCKS, $$5.nextFloat() * 0.25f + 0.75f, $$5.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(ServerLevel $$0, BlockPos $$1, boolean $$22) {
        TrialSpawnerState $$4;
        this.isOminous = $$22;
        TrialSpawnerState $$3 = this.getState();
        if (!this.canSpawnInLevel($$0)) {
            if ($$3.isCapableOfSpawning()) {
                this.data.reset();
                this.setState($$0, TrialSpawnerState.INACTIVE);
            }
            return;
        }
        if (this.data.currentMobs.removeIf($$2 -> TrialSpawner.shouldMobBeUntracked($$0, $$1, $$2))) {
            this.data.nextMobSpawnsAt = $$0.getGameTime() + (long)this.getConfig().ticksBetweenSpawn();
        }
        if (($$4 = $$3.tickAndGetNext($$1, this, $$0)) != $$3) {
            this.setState($$0, $$4);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel $$0, BlockPos $$1, UUID $$2) {
        Entity $$3 = $$0.getEntity($$2);
        return $$3 == null || !$$3.isAlive() || !((Object)$$3.level().dimension()).equals($$0.dimension()) || $$3.blockPosition().distSqr($$1) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level $$0, Vec3 $$1, Vec3 $$2) {
        BlockHitResult $$3 = $$0.clip(new ClipContext($$2, $$1, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        return $$3.getBlockPos().equals(BlockPos.containing($$1)) || $$3.getType() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(Level $$0, BlockPos $$1, RandomSource $$2, SimpleParticleType $$3) {
        for (int $$4 = 0; $$4 < 20; ++$$4) {
            double $$5 = (double)$$1.getX() + 0.5 + ($$2.nextDouble() - 0.5) * 2.0;
            double $$6 = (double)$$1.getY() + 0.5 + ($$2.nextDouble() - 0.5) * 2.0;
            double $$7 = (double)$$1.getZ() + 0.5 + ($$2.nextDouble() - 0.5) * 2.0;
            $$0.addParticle(ParticleTypes.SMOKE, $$5, $$6, $$7, 0.0, 0.0, 0.0);
            $$0.addParticle($$3, $$5, $$6, $$7, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(Level $$0, BlockPos $$1, RandomSource $$2) {
        for (int $$3 = 0; $$3 < 20; ++$$3) {
            double $$4 = (double)$$1.getX() + 0.5 + ($$2.nextDouble() - 0.5) * 2.0;
            double $$5 = (double)$$1.getY() + 0.5 + ($$2.nextDouble() - 0.5) * 2.0;
            double $$6 = (double)$$1.getZ() + 0.5 + ($$2.nextDouble() - 0.5) * 2.0;
            double $$7 = $$2.nextGaussian() * 0.02;
            double $$8 = $$2.nextGaussian() * 0.02;
            double $$9 = $$2.nextGaussian() * 0.02;
            $$0.addParticle(ParticleTypes.TRIAL_OMEN, $$4, $$5, $$6, $$7, $$8, $$9);
            $$0.addParticle(ParticleTypes.SOUL_FIRE_FLAME, $$4, $$5, $$6, $$7, $$8, $$9);
        }
    }

    public static void addDetectPlayerParticles(Level $$0, BlockPos $$1, RandomSource $$2, int $$3, ParticleOptions $$4) {
        for (int $$5 = 0; $$5 < 30 + Math.min($$3, 10) * 5; ++$$5) {
            double $$6 = (double)(2.0f * $$2.nextFloat() - 1.0f) * 0.65;
            double $$7 = (double)(2.0f * $$2.nextFloat() - 1.0f) * 0.65;
            double $$8 = (double)$$1.getX() + 0.5 + $$6;
            double $$9 = (double)$$1.getY() + 0.1 + (double)$$2.nextFloat() * 0.8;
            double $$10 = (double)$$1.getZ() + 0.5 + $$7;
            $$0.addParticle($$4, $$8, $$9, $$10, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(Level $$0, BlockPos $$1, RandomSource $$2) {
        for (int $$3 = 0; $$3 < 20; ++$$3) {
            double $$4 = (double)$$1.getX() + 0.4 + $$2.nextDouble() * 0.2;
            double $$5 = (double)$$1.getY() + 0.4 + $$2.nextDouble() * 0.2;
            double $$6 = (double)$$1.getZ() + 0.4 + $$2.nextDouble() * 0.2;
            double $$7 = $$2.nextGaussian() * 0.02;
            double $$8 = $$2.nextGaussian() * 0.02;
            double $$9 = $$2.nextGaussian() * 0.02;
            $$0.addParticle(ParticleTypes.SMALL_FLAME, $$4, $$5, $$6, $$7, $$8, $$9 * 0.25);
            $$0.addParticle(ParticleTypes.SMOKE, $$4, $$5, $$6, $$7, $$8, $$9);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector $$0) {
        this.playerDetector = $$0;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static enum FlameParticle {
        NORMAL(ParticleTypes.FLAME),
        OMINOUS(ParticleTypes.SOUL_FIRE_FLAME);

        public final SimpleParticleType particleType;

        private FlameParticle(SimpleParticleType $$0) {
            this.particleType = $$0;
        }

        public static FlameParticle decode(int $$0) {
            FlameParticle[] $$1 = FlameParticle.values();
            if ($$0 > $$1.length || $$0 < 0) {
                return NORMAL;
            }
            return $$1[$$0];
        }

        public int encode() {
            return this.ordinal();
        }
    }
}

